package com.ejianc.business.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.income.bean.SchemeIndirectEntity;
/**
 * 标前策划成本
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_scheme")
public class SchemeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="labor_mny")
    private BigDecimal laborMny; // 工程人工费
    @TableField(value="materials_mny")
    private BigDecimal materialsMny; // 工程材料费
    @TableField(value="direct_total_mny")
    private BigDecimal directTotalMny; // 工程直接费合计
    @TableField(value="indirectly_total_mny")
    private BigDecimal indirectlyTotalMny; // 工程间接费合计
    @TableField(value="other_total_mny")
    private BigDecimal otherTotalMny; // 其他费合计
    @TableField(value="amount_mny")
    private BigDecimal amountMny; // 成本总金额
    @TableField(value="bidding_mny")
    private BigDecimal biddingMny; // 预估中标金额
    @TableField(value="net_return_mny")
    private BigDecimal netReturnMny; // 净利润金额
    @TableField(value="net_return_scale")
    private BigDecimal netReturnScale; // 净利润率
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="schemeIndirectService")
    private List<SchemeIndirectEntity> schemeIndirectList = new ArrayList<>(); // 标签策划成本-间接费用
    @TableField(exist=false)
    @SubEntity(serviceName="schemeOtherService")
    private List<SchemeOtherEntity> schemeOtherList = new ArrayList<>(); // 标签策划成本-其他费用


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMaterialsMny() {
        return materialsMny;
    }

    public void setMaterialsMny(BigDecimal materialsMny) {
        this.materialsMny = materialsMny;
    }
    public BigDecimal getDirectTotalMny() {
        return directTotalMny;
    }

    public void setDirectTotalMny(BigDecimal directTotalMny) {
        this.directTotalMny = directTotalMny;
    }
    public BigDecimal getIndirectlyTotalMny() {
        return indirectlyTotalMny;
    }

    public void setIndirectlyTotalMny(BigDecimal indirectlyTotalMny) {
        this.indirectlyTotalMny = indirectlyTotalMny;
    }
    public BigDecimal getOtherTotalMny() {
        return otherTotalMny;
    }

    public void setOtherTotalMny(BigDecimal otherTotalMny) {
        this.otherTotalMny = otherTotalMny;
    }
    public BigDecimal getAmountMny() {
        return amountMny;
    }

    public void setAmountMny(BigDecimal amountMny) {
        this.amountMny = amountMny;
    }
    public BigDecimal getBiddingMny() {
        return biddingMny;
    }

    public void setBiddingMny(BigDecimal biddingMny) {
        this.biddingMny = biddingMny;
    }
    public BigDecimal getNetReturnMny() {
        return netReturnMny;
    }

    public void setNetReturnMny(BigDecimal netReturnMny) {
        this.netReturnMny = netReturnMny;
    }
    public BigDecimal getNetReturnScale() {
        return netReturnScale;
    }

    public void setNetReturnScale(BigDecimal netReturnScale) {
        this.netReturnScale = netReturnScale;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<SchemeIndirectEntity> getSchemeIndirectList() {
        return schemeIndirectList;
    }

    public void setSchemeIndirectList(List<SchemeIndirectEntity> schemeIndirectList) {
        this.schemeIndirectList = schemeIndirectList;
    }

    public List<SchemeOtherEntity> getSchemeOtherList() {
        return schemeOtherList;
    }

    public void setSchemeOtherList(List<SchemeOtherEntity> schemeOtherList) {
        this.schemeOtherList = schemeOtherList;
    }
}
