package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * @description: HomeStatisticController
 * @author songlx
 * @date 2024/11/11
 * @version 1.0
 */
@Controller
@RequestMapping("homeStatistic")
public class HomeStatisticController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IContractService contractService;


    /**
     * @Description 合同额信息管理
     */
    @RequestMapping(value = "/contractInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> contractInfo() {
        return CommonResponse.success("合同额信息管理：本年数据", contractService.contractInfo());
    }



}
