package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * <p>
 * 施工合同变更表
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_change")
public class ChangeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private Integer contractStatus;

    /**
     * 发包单位
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 承包单位
     */
    @TableField("contractor_unit")
    private Long contractorUnit;
    /**
     * 质保金
     */
    @TableField("quality_assurance_mny")
    private BigDecimal qualityAssuranceMny;
    /**
     * 质保金到期日期
     */
    @TableField("quality_assurance_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date qualityAssuranceEndDate;
    /**
     * 经营方式：1-自营，2-联营
     */
    @TableField("type")
    private Integer type;

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    @TableField("manage_charge_rate")
    private BigDecimal manageChargeRate;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同计价形式，档案
     */
    @TableField("contract_valuation_type")
    private Long contractValuationType;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 开工日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 竣工日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 总工期
     */
    @TableField("term")
    private Integer term;

    /**
     * 合同是否浮动单价 0-否，1-是
     */
    @TableField("float_flag")
    private Integer floatFlag;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更（编制）时间
     */
    @TableField("change_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeTime;

    /**
     * 生效时间
     */
    @TableField("used_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date usedTime;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 发包单位名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 承包单位名称
     */
    @TableField("contractor_unit_name")
    private String contractorUnitName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 变更原因
     */
    @TableField("change_reason")
    private String changeReason;

    /**
     * 项目负责人
     */
    @TableField("project_manager")
    private Long projectManager;

    /**
     * 项目负责人名称
     */
    @TableField("project_manager_name")
    private String projectManagerName;

    /**
     * 项目所属人
     */
    @TableField("project_owner")
    private String projectOwner;

    /**
     * 对方单位负责人
     */
    @TableField("other_party_manager")
    private String otherPartyManager;

    /**
     * 对方单位负责人联系方式
     */
    @TableField("other_party_manager_phone")
    private String otherPartyManagerPhone;

    /**
     * 合同类型
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同类型名称
     */
    @TableField("contract_type_name")
    private String contractTypeName;

    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 补充协议1是0否
    @TableField(value="contract_temp_mny")
    private BigDecimal contractTempMny; // 合同暂列金
    @TableField(value="estimate_price")
    private BigDecimal estimatePrice; // 暂估价
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="building_pay_scale")
    private BigDecimal buildingPayScale; // 在建支付比例
    @TableField(value="finished_pay_scale")
    private BigDecimal finishedPayScale; // 完工支付比例
    @TableField(value="audit_pay_scale")
    private BigDecimal auditPayScale; // 审计支付比例
    @TableField(value="quality_pay_scale")
    private BigDecimal qualityPayScale; // 质保到期比例




    @TableField(exist = false)
    @SubEntity(serviceName = "ChangeDetailService", pidName = "changeId")
    private List<ChangeDetailEntity> checkList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "ChangeClauseService", pidName = "changeId")
    private List<ChangeClauseEntity> clauseList = new ArrayList<>();

    @TableField(value="quality_period")
    private String qualityPeriod; // 质保期

    @TableField(value="prepay_scale")
    private BigDecimal prepayScale; // 预付款比例

    /**
     * 项目编码
     */
    @TableField("project_code")
    private String projectCode;

    @TableField(value="tender_profit_mny")
    private BigDecimal tenderProfitMny; // 投资利润额
    @TableField(value="tender_profit_rate")
    private BigDecimal tenderProfitRate; // 投资利润率

    /**
     * 计划完成合同额
     */
    @TableField(value="plan_finish_contract_mny")
    private BigDecimal planFinishContractMny;

    /**
     * 投标成本金额
     */
    @TableField(value="tender_cost_mny")
    private BigDecimal tenderCostMny;

    // 2025-6-21 新增字段
    // 新增设计合同总金额
    @TableField(value="contract_total")
    private BigDecimal contractTotal;
    // 新增设计合同总金额（无税）
    @TableField(value="contract_no_tax")
    private BigDecimal contractNoTax;
    // 新增设计税金
    @TableField(value="tax_amount")
    private BigDecimal taxAmount;
    // 新增设计在建支付比例
    @TableField(value="constr_pay_ratio")
    private BigDecimal constrPayRatio;
    // 新增设计完工支付比例
    @TableField(value="completion_pay_ratio")
    private BigDecimal completionPayRatio;
    // 新增设计审计支付比例
    @TableField(value="audit_pay_ratio")
    private BigDecimal auditPayRatio;
    // 新增设计质保到期比例
    @TableField(value="warranty_exp_ratio")
    private BigDecimal warrantyExpRatio;
    // 新增设计预付款比例
    @TableField(value="advance_pay_ratio")
    private BigDecimal advancePayRatio;


    public BigDecimal getPlanFinishContractMny() {
        return planFinishContractMny;
    }

    public void setPlanFinishContractMny(BigDecimal planFinishContractMny) {
        this.planFinishContractMny = planFinishContractMny;
    }

    public BigDecimal getTenderCostMny() {
        return tenderCostMny;
    }

    public void setTenderCostMny(BigDecimal tenderCostMny) {
        this.tenderCostMny = tenderCostMny;
    }


    public BigDecimal getTenderProfitMny() {
        return tenderProfitMny;
    }

    public void setTenderProfitMny(BigDecimal tenderProfitMny) {
        this.tenderProfitMny = tenderProfitMny;
    }

    public BigDecimal getTenderProfitRate() {
        return tenderProfitRate;
    }

    public void setTenderProfitRate(BigDecimal tenderProfitRate) {
        this.tenderProfitRate = tenderProfitRate;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getQualityPeriod() {
        return qualityPeriod;
    }

    public void setQualityPeriod(String qualityPeriod) {
        this.qualityPeriod = qualityPeriod;
    }

    public BigDecimal getPrepayScale() {
        return prepayScale;
    }

    public void setPrepayScale(BigDecimal prepayScale) {
        this.prepayScale = prepayScale;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public BigDecimal getContractTempMny() {
        return contractTempMny;
    }

    public void setContractTempMny(BigDecimal contractTempMny) {
        this.contractTempMny = contractTempMny;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getBuildingPayScale() {
        return buildingPayScale;
    }

    public void setBuildingPayScale(BigDecimal buildingPayScale) {
        this.buildingPayScale = buildingPayScale;
    }

    public BigDecimal getFinishedPayScale() {
        return finishedPayScale;
    }

    public void setFinishedPayScale(BigDecimal finishedPayScale) {
        this.finishedPayScale = finishedPayScale;
    }

    public BigDecimal getAuditPayScale() {
        return auditPayScale;
    }

    public void setAuditPayScale(BigDecimal auditPayScale) {
        this.auditPayScale = auditPayScale;
    }

    public BigDecimal getQualityPayScale() {
        return qualityPayScale;
    }

    public void setQualityPayScale(BigDecimal qualityPayScale) {
        this.qualityPayScale = qualityPayScale;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getProjectOwner() {
        return projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public String getOtherPartyManager() {
        return otherPartyManager;
    }

    public void setOtherPartyManager(String otherPartyManager) {
        this.otherPartyManager = otherPartyManager;
    }

    public String getOtherPartyManagerPhone() {
        return otherPartyManagerPhone;
    }

    public void setOtherPartyManagerPhone(String otherPartyManagerPhone) {
        this.otherPartyManagerPhone = otherPartyManagerPhone;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public List<ChangeDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ChangeDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public List<ChangeClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public BigDecimal getQualityAssuranceMny() {
        return qualityAssuranceMny;
    }

    public void setQualityAssuranceMny(BigDecimal qualityAssuranceMny) {
        this.qualityAssuranceMny = qualityAssuranceMny;
    }

    public Date getQualityAssuranceEndDate() {
        return qualityAssuranceEndDate;
    }

    public void setQualityAssuranceEndDate(Date qualityAssuranceEndDate) {
        this.qualityAssuranceEndDate = qualityAssuranceEndDate;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getFloatFlag() {
        return floatFlag;
    }

    public void setFloatFlag(Integer floatFlag) {
        this.floatFlag = floatFlag;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getContractTotal() {
        return contractTotal;
    }

    public void setContractTotal(BigDecimal contractTotal) {
        this.contractTotal = contractTotal;
    }

    public BigDecimal getContractNoTax() {
        return contractNoTax;
    }

    public void setContractNoTax(BigDecimal contractNoTax) {
        this.contractNoTax = contractNoTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getConstrPayRatio() {
        return constrPayRatio;
    }

    public void setConstrPayRatio(BigDecimal constrPayRatio) {
        this.constrPayRatio = constrPayRatio;
    }

    public BigDecimal getCompletionPayRatio() {
        return completionPayRatio;
    }

    public void setCompletionPayRatio(BigDecimal completionPayRatio) {
        this.completionPayRatio = completionPayRatio;
    }

    public BigDecimal getAuditPayRatio() {
        return auditPayRatio;
    }

    public void setAuditPayRatio(BigDecimal auditPayRatio) {
        this.auditPayRatio = auditPayRatio;
    }

    public BigDecimal getWarrantyExpRatio() {
        return warrantyExpRatio;
    }

    public void setWarrantyExpRatio(BigDecimal warrantyExpRatio) {
        this.warrantyExpRatio = warrantyExpRatio;
    }

    public BigDecimal getAdvancePayRatio() {
        return advancePayRatio;
    }

    public void setAdvancePayRatio(BigDecimal advancePayRatio) {
        this.advancePayRatio = advancePayRatio;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Override
    public String toString() {
        return "ChangeEntity{" +
                "contractId=" + contractId +
                ", projectId=" + projectId +
                ", orgId=" + orgId +
                ", contractName=" + contractName +
                ", billCode=" + billCode +
                ", contractStatus=" + contractStatus +
                ", customerId=" + customerId +
                ", contractorUnit=" + contractorUnit +
                ", type=" + type +
                ", manageChargeRate=" + manageChargeRate +
                ", taxRate=" + taxRate +
                ", contractValuationType=" + contractValuationType +
                ", signDate=" + signDate +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", term=" + term +
                ", employeeId=" + employeeId +
                ", memo=" + memo +
                ", contractTaxMny=" + contractTaxMny +
                ", taxMny=" + taxMny +
                ", contractMny=" + contractMny +
                ", baseTaxMoney=" + baseTaxMoney +
                ", baseMoney=" + baseMoney +
                ", beforeChangeTaxMny=" + beforeChangeTaxMny +
                ", beforeChangeMny=" + beforeChangeMny +
                ", changeVersion=" + changeVersion +
                ", changeTime=" + changeTime +
                ", usedTime=" + usedTime +
                ", billState=" + billState +
                ", projectName=" + projectName +
                ", customerName=" + customerName +
                ", contractorUnitName=" + contractorUnitName +
                ", employeeName=" + employeeName +
                ", beforeContractName=" + beforeContractName +
                ", orgName=" + orgName +
                "}";
    }
}
