package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.vo.BiVo;
import com.ejianc.business.income.vo.ProjectWarnVo;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/BILargeScreen")
public class BILargeScreenController {
    @Autowired
    private IContractService contractService;
    /**
     * Bi大屏
     * 项目进度 项目收付款数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/queryProjectMnyCollection", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BiVo> queryProjectMnyCollection(@RequestParam(value = "orgId", required = false) Long orgId
            , @RequestParam(value = "dateIn", required = false) String dateIn
            , @RequestParam(value = "projectStatus", defaultValue = "2") String projectStatus) {
        BiVo biVo = contractService.queryProjectMnyCollection(orgId,dateIn,projectStatus);
        return CommonResponse.success("查询成功",biVo);
    }
    /**
     * Bi项目逾期未预警
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/queryProjectOverDueWarn", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectWarnVo>> queryProjectOverDueWarn(@RequestParam(value = "orgId", required = false) Long orgId
            , @RequestParam(value = "dateIn", required = false) String dateIn
            , @RequestParam(value = "projectStatus", defaultValue = "2") String projectStatus) {
        List<ProjectWarnVo> projectWarnVos = contractService.queryProjectOverDueWarn(orgId,dateIn,projectStatus);
        return CommonResponse.success("查询成功",projectWarnVos);
    }

}
