package com.ejianc.business.income.controller.api;

import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/report/")
public class ReportApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReportService reportService;

    /**
     * 查起始日期和结束日期
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/projectMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectReportVo> projectMonth(@RequestParam(value = "projectId") Long projectId,
                                                        @RequestParam(value = "lastDay") Integer lastDay) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectMonth(projectId, lastDay));
    }

    /**
     * 根据项目查合同总金额
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/sumContractMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> sumContractMny(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.sumContractMny(projectId));
    }

    /**
     * 查产值
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/getMonthProductionMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProductionMny(@RequestParam(value = "projectId") Long projectId,
                                                                       @RequestParam(value = "lastDay") Integer lastDay) {
        return CommonResponse.success("查询列表数据成功！", reportService.getMonthProductionMny(projectId, lastDay));
    }

    /**
     * 查收入数据
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/getIncomeMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IncomeReportMnyVo> getIncomeMny(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.getIncomeMny(projectId));
    }

    /**
     * 查月度产值
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/getMonthProduction", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectReportVo>> getMonthProduction(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.getMonthProduction(projectId));
    }
}
