package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.report.FinanceUseResVO;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.income.vo.warn.QualityAssuranceEndDateWarnVo;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 施工合同表 服务类
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
public interface IContractService extends IBaseService<ContractEntity> {

    CommonResponse<ContractVo> saveOrUpdate(ContractVo contractVo);

    ContractVo queryDetail(Long id);

    void deleteContract(List<ContractVo> ids);

    //void updateEntity(ContractEntity contractEntity);

    Map<String,Object> countContractAmount(QueryParam param);

    Date getSignDate(Long contractId);

    void updateCollectMny(Long contractId, BigDecimal collectMny, Boolean type);

    void updateInvoicingMny(Long contractId,BigDecimal invoicingTaxMny, BigDecimal invoicingMny, Boolean type);

    ContractVo searchContract(Long projectId);

    ContractEntity queryFinanceHistory(Long id);

    InvoiceOpenRecordVO queryTaxHistory(Long id);

    ContractVo contractDetail(Long id);

    CommonResponse<Map<String,BigDecimal>> capitalCount(Integer range,List<Long> orgIds);

    CommonResponse<List<Map>> getproject(List<Long> collect);

    CommonResponse<Map> getprogress(Long projectId);

    CommonResponse<List<ProjectProgressVo>>getprogressList(List<Long> projectIds);

    CommonResponse<List<Map>> costCount(Integer range, List<Long> collect);

    CommonResponse<JSONObject> projectCount(String range,String name,String dateIn,String projectType, Long engineeringType, List<Long> collect, boolean queryBudgetCostAndVideo);

    IPage<ProjectInOutVO> proPageList(Map<String,Object> params);

    List<Map<String,Object>> incomeMnyWarn(List<SqlParam> sqlParamList);

    List<IncomeContractWarnVo> outIncomeMnyWarn(List<Long> tenantIds);

    List<QualityAssuranceEndDateWarnVo> qualityAssuranceEndDateWarn(List<Long> tenantIds);

    BigDecimal getInContractMoneySum(Map<String, Object> params);

    void refreshInvoiceMny(Map<Long, BigDecimal> map);

    IPage selectPage(Page<ContractEntity> pageData, QueryWrapper wrapper);

    CommonResponse<String> refreshAddress(Long projectId, String address);

    List<ContractVo> projectSumCollectMny(List<Long> tids);


    CommonResponse<FinanceUseResVO> queryFinanceUse(String dateIn, List<Long> orgIds);

	BigDecimal fetchSghtzje(Long projectId);

    Map<String, BigDecimal> costSquareChart(Long projectId);

    BiVo queryProjectMnyCollection(Long orgId, String dateIn, String projectStatus);

    List<ProjectWarnVo> queryProjectOverDueWarn(Long orgId, String dateIn, String projectStatus);

    JSONObject contractInfo();

    JSONObject tenderInfo();
}
