package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.comparator.ProductionDetailComparatorVo;
import com.ejianc.business.income.vo.comparator.ProductionReportComparatorVo;
import com.ejianc.business.income.vo.report.ProductionReportVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 产值进度 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Service("ProductionService")
public class ProductionServiceImpl extends BaseServiceImpl<ProductionMapper, ProductionEntity> implements IProductionService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String PRODUCTION_BILL_CODE = "INCOME_PRODUCTION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionClaimService productionClaimService;

    @Autowired
    private IProductionOtherService productionOtherService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IClaimService claimService;

    @Override
    public CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo) {
//        if(null == productionVo.getCheckList() || productionVo.getCheckList().size()<1){
//            throw new BusinessException("产值明细不可以为空");
//        }
        //保存时校验合同version是否一致
        ContractEntity contractEntity = contractService.selectById(productionVo.getContractId());

        Jedis jedis = jedisPool.getResource();
        boolean locked = false;
        try {
            locked = RedisTool.tryLock(jedis, String.valueOf(productionVo.getContractId()), "saveOrUpdate", 1000);
            logger.info("判断单据单据锁结果------" + locked);
            if (productionVo.getContractVersion() != null && productionVo.getContractVersion() != 0) {
                if (locked) {
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    Integer conVersion = productionVo.getContractVersion();
                    if (!version.equals(conVersion)) {
                        return CommonResponse.error("施工合同已被更新，请刷新后重做！");
                    }
                } else {
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }
            List<ProductionClaimVo> claimVos = productionVo.getClaimList();
            if (claimVos != null && claimVos.size() > 0) {
                Map<Long, Integer> versionMap = new HashMap<>();
                for (ProductionClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() != null && claimVo.getClaimVersion() != 0) {
                        versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                    }
                }
                if (versionMap != null && versionMap.size() > 0) {
                    if (locked) {
                        QueryParam param = new QueryParam();
                        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(versionMap.keySet())));
                        List<ClaimEntity> claimEntities = claimService.queryList(param, false);
                        for (ClaimEntity claimEntity : claimEntities) {
                            if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) != versionMap.get(claimEntity.getId())) {
                                return CommonResponse.error("变更签证洽商索赔已被更新，请刷新后重做！");
                            }
                        }
                    } else {
                        return CommonResponse.error("出现并发操作,请稍后重试！");
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (locked) {
                RedisTool.releaseLock(jedis, String.valueOf(productionVo.getContractId()), "saveOrUpdate");
            }
            jedis.close();
        }

        Date signDate = contractEntity.getSignDate();
        if (null != signDate && productionVo.getProductionDate().getTime() < signDate.getTime()) {
            throw new BusinessException("产值时间只能是大于等于施工合同的签约日期");
        }
        Date lastDate = productionMapper.getLastDate(productionVo.getContractId());
        if (null != lastDate && productionVo.getProductionDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("产值时间要大于等于该合同下的产值时间");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionEntity entity = null;
        String operateType = null;
        if (productionVo.getId() != null && productionVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(productionVo.getBillCode())) {
                productionVo.setBillCode(null);
            }
            entity = BeanMapper.map(productionVo, ProductionEntity.class);
            operateType = "edit";
        } else {
            //同一个合同只能存在一个自由态或审批中的单据
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, productionVo.getContractId()));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            List<ProductionEntity> entities = super.queryList(queryParam, false);
            if (null != entities && entities.size() > 0) {
                throw new BusinessException("合同存在进行中的单据，不允许保存");
            }
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PRODUCTION_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                productionVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity = BeanMapper.map(productionVo, ProductionEntity.class);
            operateType = "add";
        }
        if (productionVo.getId() != null && productionVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ProductionEntity> lambda = Wrappers.<ProductionEntity>lambdaQuery();
            lambda.eq(ProductionEntity::getBillCode, productionVo.getBillCode());
            lambda.eq(ProductionEntity::getTenantId, tenantId);
            lambda.ne(ProductionEntity::getId, productionVo.getId());
            List<ProductionEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ProductionEntity> lambda = Wrappers.<ProductionEntity>lambdaQuery();
            lambda.eq(ProductionEntity::getTenantId, tenantId);
            lambda.eq(ProductionEntity::getBillCode, productionVo.getBillCode());
            List<ProductionEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        for (ProductionDetailEntity detailEntity : entity.getCheckList()) {
            if ("add".equals(detailEntity.getRowState())) {
                detailEntity.setId(null);
            }
        }

        for (ProductionClaimEntity claimEntity : entity.getClaimList()) {
            if ("add".equals(claimEntity.getRowState())) {
                claimEntity.setId(null);
            }
        }
        for (ProductionOtherEntity otherEntity : entity.getOtherList()) {
            if ("add".equals(otherEntity.getRowState())) {
                otherEntity.setId(null);
            }
        }
        super.saveOrUpdateNoES(entity);
        if (CollectionUtils.isNotEmpty(entity.getCheckList())) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (ProductionDetailEntity cdEntity : entity.getCheckList()) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProductionDetailEntity cdEntity : entity.getCheckList()) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            productionDetailService.saveOrUpdateBatch(entity.getCheckList(), entity.getCheckList().size(), false);
        }

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public ProductionVo queryDetail(Long id) {
        ProductionEntity entity = this.selectById(id);
        if (entity != null) {
            ProductionVo vo = BeanMapper.map(entity, ProductionVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("productionId", new Parameter(QueryParam.EQ, vo.getId()));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<ProductionDetailEntity> details = productionDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ProductionDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List<ProductionDetailVo> resultMapList = BeanMapper.mapList(details, ProductionDetailVo.class);
                //实现排序
                Collections.sort(resultMapList, new ProductionDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("productionId", new Parameter(QueryParam.EQ, vo.getId()));
            List<ProductionClaimEntity> productionClaimEntities = productionClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList(productionClaimEntities, ProductionClaimVo.class));
            List<ProductionOtherEntity> productionOtherEntities = productionOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList(productionOtherEntities, ProductionOtherVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteProduction(List<ProductionVo> vos) {
        super.removeByIds(vos.stream().map(ProductionVo::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ProductionHistoryVo queryProductionHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", id);
        queryWrapper.orderByDesc("production_date", "create_time");
        List<ProductionEntity> prodEntitiesAllState = productionMapper.selectList(queryWrapper);
        queryWrapper.in("bill_state", billStatus);
        List<ProductionEntity> prodEntities = productionMapper.selectList(queryWrapper);
        ContractEntity contractEntity = contractService.selectById(id);
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        ProductionHistoryVo vo = new ProductionHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());//累计完成产值
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //第一版
        BigDecimal add = contractTaxMny;
        //第二版
        //BigDecimal add = contractTaxMny.add(sumClaimMny);
        if (add.compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumImageProgress(BigDecimal.ZERO);//累计形象进度
        } else {
            vo.setSumImageProgress(sumProductionTaxMny.divide(add, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
        }

        vo.setProductionRecord(BeanMapper.mapList(prodEntitiesAllState, ProductionVo.class));
        return vo;
    }

    @Override
    public List<ProductionDetailVo> detailRef(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("productionId", new Parameter(QueryParam.EQ, id));
        //queryParam.getOrderMap().put("detailIndex", "asc");
        List<ProductionDetailEntity> details = productionDetailService.queryList(queryParam, false);
        if (details != null && details.size() > 0) {
            for (ProductionDetailEntity cdEntity : details) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<ProductionDetailVo> resultMapList = BeanMapper.mapList(details, ProductionDetailVo.class);
            //实现排序
            Collections.sort(resultMapList, new ProductionDetailComparatorVo());
            return TreeNodeBUtil.buildTree(resultMapList);
        }
        return null;
    }

    @Override
    public JSONObject queryProductionDetailHistory(ProductionDetailVo productionDetailVo) {
        BigDecimal sumFinishNum = new BigDecimal(0);
        BigDecimal sumFinishMny = new BigDecimal(0);
        if (productionDetailVo.getContractDetailId() != null) {
            productionDetailVo.setSourceType(1);
            List<ProductionDetailVo> list = baseMapper.queryProductionDetailHistory(productionDetailVo);
            if (CollectionUtils.isNotEmpty(list)) {
                //计算历史含本期金额
                for (ProductionDetailVo vo : list) {
                    sumFinishNum = BigDecimalUtils.safeAdd(sumFinishNum, vo.getFinishNum());
                    sumFinishMny = BigDecimalUtils.safeAdd(sumFinishMny, vo.getFinishMny());
                }
            }
        }

        JSONObject jo = new JSONObject();
        jo.put("sumFinishNum", sumFinishNum);
        jo.put("sumFinishMny", sumFinishMny);
        return jo;
    }

    /***
     * 根据项目id 查询 累计完成产值
     * @param projectId
     * @return
     */
    @Override
    public ProductionVo queryInfoProjectId(Long projectId) {
        QueryWrapper<ProductionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.select("IFNULL(sum(finish_tax_mny) , 0 ) AS sumProductionTaxMny");
        List<ProductionEntity> list = this.list(wrapper);
        BigDecimal sumProductionTaxMny = BigDecimal.ZERO;
        if (list.get(0) != null) {
            sumProductionTaxMny = list.stream().map(ProductionEntity::getSumProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        ProductionVo productionVo = new ProductionVo();
        productionVo.setSumProductionTaxMny(sumProductionTaxMny);
        return productionVo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ProductionDetailVo> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ProductionDetailVo vo = new ProductionDetailVo();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "清单编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }
                    vo.setUnit(datas.get(3));//计量单位
                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setFinishNum(null);
                        warnType = warnType + "本期完成量为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setFinishNum(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setFinishNum(null);
                            warnType = warnType + "工程量只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setPrice(null);
                        warnType = warnType + "综合单价为空,";
                        flag = true;
                    } else {
                        try {
                            vo.setPrice(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setPrice(null);
                            warnType = warnType + "综合单价只能为数字或小数,";
                            flag = true;
                        }
                    }
                    if (!flag) {
                        vo.setFinishMny(vo.getFinishNum().multiply(vo.getPrice()));
                    }
//                    if (StringUtils.isNotEmpty(datas.get(6))) {
//                        try {
//                            vo.setFinishMny(new BigDecimal(datas.get(6)));
//                        } catch (Exception e) {
//                            vo.setFinishMny(null);
//                            warnType = warnType+"本期完成只能为数字或小数,";
//                            flag = true;
//                        }
//                    }else {
//
//                    }
                    vo.setMemo(datas.get(7));
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setSourceType(2);//增补项
                    detailVoList.add(vo);
                }

                for (ProductionDetailVo tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", allList.get(0));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<ProjectRegisterVO> queryNoProductionProject(List<Long> tenantIds) {
        return productionMapper.queryNoProductionProject(tenantIds);
    }

    @Override
    public JSONObject queryProductionReport(QueryParam param, Boolean excelBoolean) {
        JSONObject jsonObject = new JSONObject();
        Parameter projectId = param.getParams().get("projectId");
        Parameter year = param.getParams().get("yyear");
        if (null == projectId) {
            return null;
        }
        String yearValue = null;
        if (null != year) {
            yearValue = year.getValue().toString();
            param.getParams().remove("yyear");
        }
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("c.tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, billstate));
        //因涉及到合同变更后只会把dr变为0无法关联到变更合同前的产值进度因此去除dr过滤    获取产值后处理删除数据
        //param.getParams().put("c.dr", new Parameter(QueryParam.EQ, 0));
        //param.getParams().put("d.dr", new Parameter(QueryParam.EQ, 0));
        //param.getParams().put("d.change_type", new Parameter(QueryParam.NE, 5));//变更删除后changetype变为5
        if (null!=param.getParams().get("detailCode")){
            param.getParams().put("d.code", new Parameter(QueryParam.LIKE, param.getParams().get("detailCode").getValue()));//变更删除后changetype变为5
            param.getParams().remove("detailCode");
        }
        Page<ProductionReportVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<ProductionReportVO> wrapper = changeToQueryWrapper(param);
        List<ProductionReportVO> allDataList = productionMapper.queryProductionReport(wrapper, yearValue);
        //合同变更后数据处理
        allDataList=handleDate(allDataList);
        //将已删除数据过滤掉
        allDataList= allDataList.stream().filter(v -> v.getDr()==0).collect(Collectors.toList());

        //合同项目列
        List<Long> conProjectDateId = allDataList.stream().filter(v -> ("合同项目".equals(v.getName()))).map(ProductionReportVO::getId).collect(Collectors.toList());
        List<Long> conNewProjectDateId = allDataList.stream().filter(v -> ("合同新增项目".equals(v.getName()))).map(ProductionReportVO::getId).collect(Collectors.toList());
        //
        BigDecimal mnyTotal = null;
        BigDecimal sumMnyTotal = null;
        BigDecimal yearMnyTotal = null;
        BigDecimal mnyTotal1 = null;
        BigDecimal mnyTotal2 = null;
        BigDecimal mnyTotal3 = null;
        BigDecimal mnyTotal4 = null;
        BigDecimal mnyTotal5 = null;
        BigDecimal mnyTotal6 = null;
        BigDecimal mnyTotal7 = null;
        BigDecimal mnyTotal8 = null;
        BigDecimal mnyTotal9 = null;
        BigDecimal mnyTotal10 = null;
        BigDecimal mnyTotal11 = null;
        BigDecimal mnyTotal12 = null;
        BigDecimal mnyTotalNew = null;
        BigDecimal sumMnyTotalNew = null;
        BigDecimal yearMnyTotalNew = null;
        BigDecimal mnyTotal1New = null;
        BigDecimal mnyTotal2New = null;
        BigDecimal mnyTotal3New = null;
        BigDecimal mnyTotal4New = null;
        BigDecimal mnyTotal5New = null;
        BigDecimal mnyTotal6New = null;
        BigDecimal mnyTotal7New = null;
        BigDecimal mnyTotal8New = null;
        BigDecimal mnyTotal9New = null;
        BigDecimal mnyTotal10New = null;
        BigDecimal mnyTotal11New = null;
        BigDecimal mnyTotal12New = null;
        for (ProductionReportVO productionReportVO : allDataList) {
            if (conProjectDateId.contains(productionReportVO.getParentId())) {
                productionReportVO.setParentId(1L);
                mnyTotal = ComputeUtil.safeAdd(productionReportVO.getMnyTotal(), mnyTotal);
                sumMnyTotal = ComputeUtil.safeAdd(productionReportVO.getSumMnyTotal(), sumMnyTotal);
                yearMnyTotal = ComputeUtil.safeAdd(productionReportVO.getYearMnyTotal(), yearMnyTotal);
                mnyTotal1 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal1(), mnyTotal1);
                mnyTotal2 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal2(), mnyTotal2);
                mnyTotal3 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal3(), mnyTotal3);
                mnyTotal4 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal4(), mnyTotal4);
                mnyTotal5 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal5(), mnyTotal5);
                mnyTotal6 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal6(), mnyTotal6);
                mnyTotal7 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal7(), mnyTotal7);
                mnyTotal8 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal8(), mnyTotal8);
                mnyTotal9 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal9(), mnyTotal9);
                mnyTotal10 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal10(), mnyTotal10);
                mnyTotal11 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal11(), mnyTotal11);
                mnyTotal12 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal12(), mnyTotal12);
            }
            if (conNewProjectDateId.contains(productionReportVO.getParentId())) {
                productionReportVO.setParentId(2L);
                mnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getMnyTotal(), mnyTotalNew);
                sumMnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getSumMnyTotal(), sumMnyTotalNew);
                yearMnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getYearMnyTotal(), yearMnyTotalNew);
                mnyTotal1New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal1(), mnyTotal1New);
                mnyTotal2New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal2(), mnyTotal2New);
                mnyTotal3New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal3(), mnyTotal3New);
                mnyTotal4New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal4(), mnyTotal4New);
                mnyTotal5New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal5(), mnyTotal5New);
                mnyTotal6New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal6(), mnyTotal6New);
                mnyTotal7New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal7(), mnyTotal7New);
                mnyTotal8New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal8(), mnyTotal8New);
                mnyTotal9New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal9(), mnyTotal9New);
                mnyTotal10New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal10(), mnyTotal10New);
                mnyTotal11New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal11(), mnyTotal11New);
                mnyTotal12New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal12(), mnyTotal12New);
            }
        }
        List<ProductionReportVO> conProList = allDataList.stream().filter(v -> ("合同项目".equals(v.getName()))).collect(Collectors.toList());
        List<ProductionReportVO> conProListNew = allDataList.stream().filter(v -> ("合同新增项目".equals(v.getName()))).collect(Collectors.toList());
        List<ProductionReportVO> dataList = allDataList.stream().filter(v -> !"合同项目".equals(v.getName())).filter(v -> !"合同新增项目".equals(v.getName())).collect(Collectors.toList());
        HashMap indexMap = new HashMap();
        if (CollectionUtils.isNotEmpty(conProList)) {
            ProductionReportVO productionReportVOOne = new ProductionReportVO();
            productionReportVOOne.setName("合同项目");
            productionReportVOOne.setDetailCode("1");
            productionReportVOOne.setDetailIndex("1");
            productionReportVOOne.setId(1L);
            productionReportVOOne.setMnyTotal(mnyTotal);
            productionReportVOOne.setSumMnyTotal(sumMnyTotal);
            productionReportVOOne.setYearMnyTotal(yearMnyTotal);
            productionReportVOOne.setMnyTotal1(mnyTotal1);
            productionReportVOOne.setMnyTotal2(mnyTotal2);
            productionReportVOOne.setMnyTotal3(mnyTotal3);
            productionReportVOOne.setMnyTotal4(mnyTotal4);
            productionReportVOOne.setMnyTotal5(mnyTotal5);
            productionReportVOOne.setMnyTotal6(mnyTotal6);
            productionReportVOOne.setMnyTotal7(mnyTotal7);
            productionReportVOOne.setMnyTotal8(mnyTotal8);
            productionReportVOOne.setMnyTotal9(mnyTotal9);
            productionReportVOOne.setMnyTotal10(mnyTotal10);
            productionReportVOOne.setMnyTotal11(mnyTotal11);
            productionReportVOOne.setMnyTotal12(mnyTotal12);
            dataList.add(productionReportVOOne);
            indexMap.put(productionReportVOOne.getId(), productionReportVOOne.getDetailIndex());

        }
        if (CollectionUtils.isNotEmpty(conProListNew)) {
            ProductionReportVO productionReportVOTwo = new ProductionReportVO();
            productionReportVOTwo.setName("合同新增项目");
            productionReportVOTwo.setDetailCode("2");
            productionReportVOTwo.setDetailIndex("2");
            productionReportVOTwo.setId(2L);
            productionReportVOTwo.setMnyTotal(mnyTotalNew);
            productionReportVOTwo.setSumMnyTotal(sumMnyTotalNew);
            productionReportVOTwo.setYearMnyTotal(yearMnyTotalNew);
            productionReportVOTwo.setMnyTotal1(mnyTotal1New);
            productionReportVOTwo.setMnyTotal2(mnyTotal2New);
            productionReportVOTwo.setMnyTotal3(mnyTotal3New);
            productionReportVOTwo.setMnyTotal4(mnyTotal4New);
            productionReportVOTwo.setMnyTotal5(mnyTotal5New);
            productionReportVOTwo.setMnyTotal6(mnyTotal6New);
            productionReportVOTwo.setMnyTotal7(mnyTotal7New);
            productionReportVOTwo.setMnyTotal8(mnyTotal8New);
            productionReportVOTwo.setMnyTotal9(mnyTotal9New);
            productionReportVOTwo.setMnyTotal10(mnyTotal10New);
            productionReportVOTwo.setMnyTotal11(mnyTotal11New);
            productionReportVOTwo.setMnyTotal12(mnyTotal12New);
            dataList.add(productionReportVOTwo);
            indexMap.put(productionReportVOTwo.getId(), productionReportVOTwo.getDetailIndex());
        }

        dataList=createIndex(indexMap, dataList);
        //实现排序
        Collections.sort(dataList, new ProductionReportComparatorVo());
        List<ProductionReportVO> resultList = new ArrayList();
        //导出数据不用构建树形
        if (Boolean.TRUE == excelBoolean) {
            resultList.addAll(dataList);
        } else {
            resultList.addAll(TreeNodeBUtil.buildTree(dataList));
        }

        jsonObject.put("records", resultList);
        jsonObject.put("total", pages.getTotal());
        jsonObject.put("current", pages.getCurrent());
        jsonObject.put("size", pages.getSize());
        jsonObject.put("pages", pages.getPages());
        return jsonObject;
    }

    @Override
    public List<ProductionReportVO> excelExportProductionReport(QueryParam queryParam) {
        List<ProductionReportVO> records = (List<ProductionReportVO>) queryProductionReport(queryParam, Boolean.TRUE).get("records");
        return records;
    }

    //重写报表需要重新创建序号=========因为一个项目多个合同清单  导致序号相同
    public List<ProductionReportVO> createIndex(Map<Long, String> indexMap, List<ProductionReportVO> list) {

        List<ProductionReportVO> collect = list.stream().sorted(Comparator.comparing(ProductionReportVO::getDetailIndex)).collect(Collectors.toList());
        int i = 1;
        int length = 0;
        for (ProductionReportVO productionReportVO : collect) {
            if (length != productionReportVO.getDetailIndex().length()) {
                length = productionReportVO.getDetailIndex().length();
                i = 1;
            }
            if (null != productionReportVO.getParentId() ) {
                if (null!=indexMap.get(productionReportVO.getParentId())) {//搜索可能出现没有parentId情况
                    productionReportVO.setDetailIndex(indexMap.get(productionReportVO.getParentId()) + "." + i);
                    indexMap.put(productionReportVO.getId(), productionReportVO.getDetailIndex());
                    i++;
                }else{
                    productionReportVO.setDetailIndex(i+"");
                    indexMap.put(productionReportVO.getId(), productionReportVO.getDetailIndex());
                    i++;
                }
            }
        }
        return collect;
    }

    private List<ProductionReportVO> handleDate(List<ProductionReportVO> list) {
        //生成所有需要累计数据的MAP
        Map<Long, BigDecimal> sumMnyTotalMap = new HashMap();
        Map<Long, BigDecimal> yearNumMap = new HashMap();
        Map<Long, BigDecimal> yearMnyTotalMap = new HashMap();
        Map<Long, BigDecimal> num1Map = new HashMap();
        Map<Long, BigDecimal> num2Map = new HashMap();
        Map<Long, BigDecimal> num3Map = new HashMap();
        Map<Long, BigDecimal> num4Map = new HashMap();
        Map<Long, BigDecimal> num5Map = new HashMap();
        Map<Long, BigDecimal> num6Map = new HashMap();
        Map<Long, BigDecimal> num7Map = new HashMap();
        Map<Long, BigDecimal> num8Map = new HashMap();
        Map<Long, BigDecimal> num9Map = new HashMap();
        Map<Long, BigDecimal> num10Map = new HashMap();
        Map<Long, BigDecimal> num11Map = new HashMap();
        Map<Long, BigDecimal> num12Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal1Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal2Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal3Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal4Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal5Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal6Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal7Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal8Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal9Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal10Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal11Map = new HashMap();
        Map<Long, BigDecimal> mnyTotal12Map = new HashMap();

      for (ProductionReportVO productionReportVO : list) {
          Long id = productionReportVO.getId();
        //循环所有数据将各数据根据类型分别插入相应map
          sumMnyTotalMap.put(id,productionReportVO.getSumMnyTotal());
          yearNumMap.put(id,productionReportVO.getYearNum());
          yearMnyTotalMap.put(id,productionReportVO.getYearMnyTotal());
          num1Map.put(id,productionReportVO.getNum1());
          num2Map.put(id,productionReportVO.getNum2());
          num3Map.put(id,productionReportVO.getNum3());
          num4Map.put(id,productionReportVO.getNum4());
          num5Map.put(id,productionReportVO.getNum5());
          num6Map.put(id,productionReportVO.getNum6());
          num7Map.put(id,productionReportVO.getNum7());
          num8Map.put(id,productionReportVO.getNum8());
          num9Map.put(id,productionReportVO.getNum9());
          num10Map.put(id,productionReportVO.getNum10());
          num11Map.put(id,productionReportVO.getNum11());
          num12Map.put(id,productionReportVO.getNum12());
          mnyTotal1Map.put(id,productionReportVO.getMnyTotal1());
          mnyTotal2Map.put(id,productionReportVO.getMnyTotal2());
          mnyTotal3Map.put(id,productionReportVO.getMnyTotal3());
          mnyTotal4Map.put(id,productionReportVO.getMnyTotal4());
          mnyTotal5Map.put(id,productionReportVO.getMnyTotal5());
          mnyTotal6Map.put(id,productionReportVO.getMnyTotal6());
          mnyTotal7Map.put(id,productionReportVO.getMnyTotal7());
          mnyTotal8Map.put(id,productionReportVO.getMnyTotal8());
          mnyTotal9Map.put(id,productionReportVO.getMnyTotal9());
          mnyTotal10Map.put(id,productionReportVO.getMnyTotal10());
          mnyTotal11Map.put(id,productionReportVO.getMnyTotal11());
          mnyTotal12Map.put(id,productionReportVO.getMnyTotal12());
        }



        for (ProductionReportVO productionReportVO : list) {
            //合同项目后面手动生成 所以此处不做处理
            if (!"合同项目".equals(productionReportVO.getName())&&!"合同新增项目".equals(productionReportVO.getName())) {
                Long id = productionReportVO.getId();
                Long oldDetailId = productionReportVO.getOldDetailId();
                //将根据变更前的oldId获取变更前所获产值并相加  目前产值=变更前产值+当前产值
                productionReportVO.setSumMnyTotal(ComputeUtil.safeAdd(ComputeUtil.nullToZero(sumMnyTotalMap.get(oldDetailId)), ComputeUtil.nullToZero(productionReportVO.getSumMnyTotal())));
                productionReportVO.setYearNum(ComputeUtil.safeAdd(yearNumMap.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getYearNum())));
                productionReportVO.setYearMnyTotal(ComputeUtil.safeAdd(yearMnyTotalMap.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getYearMnyTotal())));
                productionReportVO.setNum1(ComputeUtil.safeAdd(num1Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum1())));
                productionReportVO.setNum2(ComputeUtil.safeAdd(num2Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum2())));
                productionReportVO.setNum3(ComputeUtil.safeAdd(num3Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum3())));
                productionReportVO.setNum4(ComputeUtil.safeAdd(num4Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum4())));
                productionReportVO.setNum5(ComputeUtil.safeAdd(num5Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum5())));
                productionReportVO.setNum6(ComputeUtil.safeAdd(num6Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum6())));
                productionReportVO.setNum7(ComputeUtil.safeAdd(num7Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum7())));
                productionReportVO.setNum8(ComputeUtil.safeAdd(num8Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum8())));
                productionReportVO.setNum9(ComputeUtil.safeAdd(num9Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum9())));
                productionReportVO.setNum10(ComputeUtil.safeAdd(num10Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum10())));
                productionReportVO.setNum11(ComputeUtil.safeAdd(num11Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum11())));
                productionReportVO.setNum12(ComputeUtil.safeAdd(num12Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum12())));
                productionReportVO.setMnyTotal1(ComputeUtil.safeAdd(mnyTotal1Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal1())));
                productionReportVO.setMnyTotal2(ComputeUtil.safeAdd(mnyTotal2Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal2())));
                productionReportVO.setMnyTotal3(ComputeUtil.safeAdd(mnyTotal3Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal3())));
                productionReportVO.setMnyTotal4(ComputeUtil.safeAdd(mnyTotal4Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal4())));
                productionReportVO.setMnyTotal5(ComputeUtil.safeAdd(mnyTotal5Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal5())));
                productionReportVO.setMnyTotal6(ComputeUtil.safeAdd(mnyTotal6Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal6())));
                productionReportVO.setMnyTotal7(ComputeUtil.safeAdd(mnyTotal7Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal7())));
                productionReportVO.setMnyTotal8(ComputeUtil.safeAdd(mnyTotal8Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal8())));
                productionReportVO.setMnyTotal9(ComputeUtil.safeAdd(mnyTotal9Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal9())));
                productionReportVO.setMnyTotal10(ComputeUtil.safeAdd(mnyTotal10Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal10())));
                productionReportVO.setMnyTotal11(ComputeUtil.safeAdd(mnyTotal11Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal11())));
                productionReportVO.setMnyTotal12(ComputeUtil.safeAdd(mnyTotal12Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal12())));
                
                //将累加后的产值放入map   防止多次变更数据无法累加
                sumMnyTotalMap.put(id, productionReportVO.getSumMnyTotal());
                yearNumMap.put(id, productionReportVO.getYearNum());
                yearMnyTotalMap.put(id, productionReportVO.getYearMnyTotal());
                num1Map.put(id,productionReportVO.getNum1());
                num2Map.put(id,productionReportVO.getNum2());
                num3Map.put(id,productionReportVO.getNum3());
                num4Map.put(id,productionReportVO.getNum4());
                num5Map.put(id,productionReportVO.getNum5());
                num6Map.put(id,productionReportVO.getNum6());
                num7Map.put(id,productionReportVO.getNum7());
                num8Map.put(id,productionReportVO.getNum8());
                num9Map.put(id,productionReportVO.getNum9());
                num10Map.put(id,productionReportVO.getNum10());
                num11Map.put(id,productionReportVO.getNum11());
                num12Map.put(id,productionReportVO.getNum12());
                mnyTotal1Map.put(id,productionReportVO.getMnyTotal1());
                mnyTotal2Map.put(id,productionReportVO.getMnyTotal2());
                mnyTotal3Map.put(id,productionReportVO.getMnyTotal3());
                mnyTotal4Map.put(id,productionReportVO.getMnyTotal4());
                mnyTotal5Map.put(id,productionReportVO.getMnyTotal5());
                mnyTotal6Map.put(id,productionReportVO.getMnyTotal6());
                mnyTotal7Map.put(id,productionReportVO.getMnyTotal7());
                mnyTotal8Map.put(id,productionReportVO.getMnyTotal8());
                mnyTotal9Map.put(id,productionReportVO.getMnyTotal9());
                mnyTotal10Map.put(id,productionReportVO.getMnyTotal10());
                mnyTotal11Map.put(id,productionReportVO.getMnyTotal11());
                mnyTotal12Map.put(id,productionReportVO.getMnyTotal12());
            }
        }

        return list;
    }
}
