/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"homeStatistic"})
public class HomeStatisticController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/contractInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contractInfo() {
        return CommonResponse.success((String)"\u5408\u540c\u989d\u4fe1\u606f\u7ba1\u7406\uff1a\u672c\u5e74\u6570\u636e", (Object)this.contractService.contractInfo());
    }

    @RequestMapping(value={"/tenderInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> tenderInfo() {
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u7ba1\u7406-\u6295\u6807\u51c0\u5229\u6da6\u3001\u6e38\u6807\u5229\u6da6\u7387\u3001\u6295\u6807\u6210\u672c", (Object)this.contractService.tenderInfo());
    }

    @RequestMapping(value={"/costInfo"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<List<JSONObject>> costInfo() {
        ArrayList<JSONObject> resVO = new ArrayList<JSONObject>();
        List<String> sumList = Arrays.asList("projectNum", "tenderProfitRate", "baseTotalMoney", "targetCostMny", "CALCbec9d61477", "CALC1d3918a8dd");
        SearchRequest searchRequest = new SearchRequest(new String[]{"project_dynamic_cost"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
        TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"areaName").field("orgName.keyword");
        for (String key : sumList) {
            SumAggregationBuilder aggregation = (SumAggregationBuilder)((SumAggregationBuilder)AggregationBuilders.sum((String)("sum_" + key)).field(key)).missing((Object)0);
            termsAggregationBuilder.subAggregation((AggregationBuilder)aggregation);
        }
        sourceBuilder.aggregation((AggregationBuilder)termsAggregationBuilder);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Aggregations aggregations = response.getAggregations();
            ParsedStringTerms sourceWay = (ParsedStringTerms)aggregations.get("areaName");
            for (Terms.Bucket bucket : sourceWay.getBuckets()) {
                JSONObject obj = new JSONObject();
                obj.put("areaName", (Object)bucket.getKeyAsString());
                for (String key : sumList) {
                    ParsedSum sum_mny = (ParsedSum)bucket.getAggregations().get("sum_" + key);
                    obj.put("sum_" + key, (Object)ComputeUtil.toBigDecimal((Double)sum_mny.getValue()));
                }
                BigDecimal tenderProfitRate = ComputeUtil.bigDecimalPercent((BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_tenderProfitRate")), (BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_projectNum")), (int)2);
                obj.put("tenderProfitRate", (Object)tenderProfitRate);
                BigDecimal targetSub = ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_tenderProfitRate")), (BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_projectNum")));
                BigDecimal targetProfitRate = ComputeUtil.bigDecimalPercent((BigDecimal)targetSub, (BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_baseTotalMoney")), (int)2);
                obj.put("targetProfitRate", (Object)targetProfitRate);
                BigDecimal realSub = ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_CALCbec9d61477")), (BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_CALC1d3918a8dd")));
                BigDecimal realProfitRate = ComputeUtil.bigDecimalPercent((BigDecimal)realSub, (BigDecimal)ComputeUtil.toBigDecimal((Object)obj.get((Object)"sum_CALCbec9d61477")), (int)2);
                obj.put("realProfitRate", (Object)realProfitRate);
                resVO.add(obj);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success(resVO);
    }
}

