package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 甲方报量-签证索赔明细
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_quote_claim")
public class QuoteClaimEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 甲方报量主键
     */
    @TableField("quote_id")
    private Long quoteId;

    /**
     * 签证变更主键
     */
    @TableField("claim_id")
    private Long claimId;

    /**
     * 签证变更单号
     */
    @TableField("claim_code")
    private String claimCode;

    /**
     * 变更摘要
     */
    @TableField("change_summary")
    private String changeSummary;

    /**
     * 变更类型，0-现场签证，1-变更洽商，2-索赔
     */
    @TableField("change_type")
    private Integer changeType;

    /**
     * 批复金额
     */
    @TableField("reply_mny")
    private BigDecimal replyMny;

    /**
     * 本期统计金额
     */
    @TableField("occur_mny")
    private BigDecimal occurMny;

    /**
     * 累计统计金额
     */
    @TableField("sum_occur_mny")
    private BigDecimal sumOccurMny;

    /**
     * 累计统计金额
     */
    @TableField("sum_occur_tax_mny")
    private BigDecimal sumOccurTaxMny;

    /**
     * 税率
     */
    @TableField("claim_tax_rate")
    private BigDecimal claimTaxRate;

    /**
     * 审核金额
     */
    @TableField("claim_reply_tax_mny")
    private BigDecimal claimReplyTaxMny;
    /**
     * 本期统计金额
     */
    @TableField("claim_occur_tax_mny")
    private BigDecimal claimOccurTaxMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Long getClaimId() {
        return claimId;
    }

    public void setClaimId(Long claimId) {
        this.claimId = claimId;
    }
    public String getClaimCode() {
        return claimCode;
    }

    public void setClaimCode(String claimCode) {
        this.claimCode = claimCode;
    }
    public String getChangeSummary() {
        return changeSummary;
    }

    public void setChangeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
    }
    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }
    public BigDecimal getOccurMny() {
        return occurMny;
    }

    public void setOccurMny(BigDecimal occurMny) {
        this.occurMny = occurMny;
    }
    public BigDecimal getSumOccurMny() {
        return sumOccurMny;
    }

    public void setSumOccurMny(BigDecimal sumOccurMny) {
        this.sumOccurMny = sumOccurMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getSumOccurTaxMny() {
        return sumOccurTaxMny;
    }

    public void setSumOccurTaxMny(BigDecimal sumOccurTaxMny) {
        this.sumOccurTaxMny = sumOccurTaxMny;
    }

    public BigDecimal getClaimTaxRate() {
        return claimTaxRate;
    }

    public void setClaimTaxRate(BigDecimal claimTaxRate) {
        this.claimTaxRate = claimTaxRate;
    }

    public BigDecimal getClaimReplyTaxMny() {
        return claimReplyTaxMny;
    }

    public void setClaimReplyTaxMny(BigDecimal claimReplyTaxMny) {
        this.claimReplyTaxMny = claimReplyTaxMny;
    }

    public BigDecimal getClaimOccurTaxMny() {
        return claimOccurTaxMny;
    }

    public void setClaimOccurTaxMny(BigDecimal claimOccurTaxMny) {
        this.claimOccurTaxMny = claimOccurTaxMny;
    }

    @Override
    public String toString() {
        return "QuoteClaimEntity{" +
                "quoteId=" + quoteId +
                ", claimId=" + claimId +
                ", claimCode=" + claimCode +
                ", changeSummary=" + changeSummary +
                ", changeType=" + changeType +
                ", replyMny=" + replyMny +
                ", occurMny=" + occurMny +
                ", sumOccurMny=" + sumOccurMny +
                ", sumOccurTaxMny=" + sumOccurTaxMny +
                ", claimTaxRate=" + claimTaxRate +
                ", claimReplyTaxMny=" + claimReplyTaxMny +
                ", claimOccurTaxMny=" + claimOccurTaxMny +
                ", memo=" + memo  +
                "}";
    }
}
