/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.FinishEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IFinishService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finish")
public class FinishBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFinishService service;
    @Autowired
    private IContractService contractService;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private ComputeUtil computeUtil;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishEntity finishEntity = (FinishEntity)((Object)this.service.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(finishEntity.getContractId()));
        this.pushToNC(finishEntity, contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        FinishEntity finishEntity = (FinishEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isNotEmpty((CharSequence)finishEntity.getSourceId())) {
            String[] split;
            for (String sourceId : split = finishEntity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deletearbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
        }
        return CommonResponse.success();
    }

    private void pushToNC(FinishEntity entity, ContractEntity contractEntity) {
        ArBillVO vo = this.transferToNCVO(entity, contractEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        StringBuffer stringBuffer = new StringBuffer();
        for (Long orgId : orgIds) {
            OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            stringBuffer.append(sourceId).append(",");
        }
        String sourceIds = stringBuffer.substring(0, stringBuffer.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(FinishEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.service.update((Wrapper)wrapper);
    }

    private ArBillVO transferToNCVO(FinishEntity entity, ContractEntity contractEntity) {
        this.logger.info("----\u5e94\u6536\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = this.ncUtil.queryCustomerById(contractEntity.getCustomerId());
        ArBillVO vo = new ArBillVO();
        vo.setBusitype("arbill");
        vo.setTradetype("F0-Cxx-001");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setPk_org(orgVO.getCode());
        if (project.getMaterialVerification() == null) {
            vo.setDef1(Boolean.valueOf(false));
        } else {
            vo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        }
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        vo.setDef5(project.getAreaCode());
        vo.setPk_customer(String.valueOf(contractEntity.getCustomerId()));
        if (customerVO.getInsideOrgId() == null) {
            vo.setDef6(Boolean.valueOf(false));
        } else {
            vo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        }
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        vo.setDef8(contractEntity.getBillCode());
        vo.setDef9(contractEntity.getContractName());
        ArrayList<ArBillDetailVO> detailVOS = new ArrayList<ArBillDetailVO>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        BigDecimal sumSettleMny = entity.getSumSettleMny();
        BigDecimal sumQuoteMny = entity.getSumQuoteMny();
        BigDecimal sumSettleCutTaxMny = ComputeUtil.safeSub(sumSettleMny, sumQuoteMny);
        detailVO.setNotaxmny(sumSettleCutTaxMny);
        detailVO.setTotalmny(entity.getSumSettleCutMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

