/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteClaimEntity;
import com.ejianc.business.income.bean.QuoteDetailEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteClaimService;
import com.ejianc.business.income.service.IQuoteDetailService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="quote")
public class QuoteBpmService
implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IProductionService productionService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List checkList;
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteEntity.getContractId()));
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        contractEntity.setSumQuoteTaxMny(quoteTaxMny.add(sumQuoteTaxMny));
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        contractEntity.setSumQuoteMny(quoteMny.add(sumQuoteMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter("eq", (Object)quoteEntity.getId()));
        List claimList = this.quoteClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> idTaxMap = new HashMap<Long, BigDecimal>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumQuoteMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny()).add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
                ce.setSumQuoteTaxMny((ce.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : ce.getSumQuoteTaxMny()).add(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idTaxMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
        if (null != (checkList = this.quoteDetailService.queryList(parm, false)) && checkList.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (QuoteDetailEntity qde : checkList) {
                if (null == qde.getProductionId() || qde.getProductionId() <= 0L || !ids.add(qde.getProductionId())) continue;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ProductionEntity::getQuoteFlag, (Object)1);
                updateWrapper.eq(BaseEntity::getId, (Object)qde.getProductionId());
                this.productionService.update((Wrapper)updateWrapper);
            }
        }
        this.pushToNC(quoteEntity, contractEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QuoteEntity entity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        LambdaQueryWrapper lamb = new LambdaQueryWrapper();
        lamb.eq(QuoteEntity::getContractId, (Object)entity.getContractId());
        lamb.last("and date_format(quote_date,'%Y-%m')>'" + DateUtil.getYearAndMonth((Date)entity.getQuoteDate()) + "'");
        List list = this.quoteService.list((Wrapper)lamb);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5b58\u5728\u6bd4\u5f53\u524d\u7532\u65b9\u6279\u91cf\u6708\u4efd\u66f4\u665a\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u8de8\u671f\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            this.callBackQuote(billId, state, billTypeCode);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        if (StringUtils.isNotEmpty((CharSequence)quoteEntity.getSourceId())) {
            String[] split;
            for (String sourceId : split = quoteEntity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deletearbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
        }
        return CommonResponse.success();
    }

    private void callBackQuote(Long billId, Integer state, String billTypeCode) {
        List checkList;
        QuoteEntity quoteEntity = (QuoteEntity)((Object)this.quoteService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(quoteEntity.getContractId()));
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        contractEntity.setSumQuoteTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        contractEntity.setSumQuoteMny(sumQuoteMny.subtract(quoteMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter("eq", (Object)quoteEntity.getId()));
        List claimList = this.quoteClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> idTaxMap = new HashMap<Long, BigDecimal>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumQuoteMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny()).subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
                ce.setSumQuoteTaxMny((ce.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : ce.getSumQuoteTaxMny()).subtract(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idTaxMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
        if (null != (checkList = this.quoteDetailService.queryList(parm, false)) && checkList.size() > 0) {
            HashSet<Long> ids = new HashSet<Long>();
            for (QuoteDetailEntity qde : checkList) {
                if (null == qde.getProductionId() || qde.getProductionId() <= 0L || !ids.add(qde.getProductionId())) continue;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ProductionEntity::getQuoteFlag, (Object)0);
                updateWrapper.eq(BaseEntity::getId, (Object)qde.getProductionId());
                this.productionService.update((Wrapper)updateWrapper);
            }
        }
    }

    private void pushToNC(QuoteEntity entity, ContractEntity contractEntity) {
        ArBillVO vo = this.transferToNCVO(entity, contractEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        StringBuffer stringBuffer = new StringBuffer();
        for (Long orgId : orgIds) {
            OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            stringBuffer.append(sourceId).append(",");
        }
        String sourceIds = stringBuffer.substring(0, stringBuffer.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(QuoteEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.quoteService.update((Wrapper)wrapper);
    }

    private ArBillVO transferToNCVO(QuoteEntity entity, ContractEntity contractEntity) {
        this.logger.info("----\u5e94\u6536\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = this.ncUtil.queryCustomerById(contractEntity.getCustomerId());
        ArBillVO vo = new ArBillVO();
        vo.setBusitype("arbill");
        vo.setTradetype("F0-Cxx-008");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setPk_org(orgVO.getCode());
        if (project.getMaterialVerification() == null) {
            vo.setDef1(Boolean.valueOf(false));
        } else {
            vo.setDef1(Boolean.valueOf(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate()));
        }
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        vo.setDef4(this.ncUtil.getDefDocById(project.getEngineeringType()).getCode());
        vo.setDef5(project.getAreaCode());
        vo.setPk_customer(String.valueOf(contractEntity.getCustomerId()));
        if (customerVO.getInsideOrgId() == null) {
            vo.setDef6(Boolean.valueOf(false));
        } else {
            vo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        }
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        vo.setDef8(contractEntity.getBillCode());
        vo.setDef9(contractEntity.getContractName());
        ArrayList<ArBillDetailVO> detailVOS = new ArrayList<ArBillDetailVO>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getQuoteMny());
        detailVO.setTotalmny(entity.getQuoteTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

