package com.ejianc.business.income.bean;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;

/**
 * <p>
 * 施工合同-条款
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_contract_clause")
public class ContractClauseEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 施工合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 条款名称
     */
    @TableField("name")
    private String name;

    /**
     * 条款内容
     */
    @TableField("content")
    private String content;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    @Override
    public String toString() {
        return "ContractClauseEntity{" +
                "contractId=" + contractId +
                ", name=" + name +
                ", content=" + content +
                ", changeId=" + changeId +
                ", changeBid=" + changeBid +
                "}";
    }
}
