package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.FinishVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.income.mapper.FinishMapper;
import com.ejianc.business.income.bean.FinishEntity;
import com.ejianc.business.income.service.IFinishService;

import java.util.List;

/**
 * 竣工结算
 *
 * @author generator
 */
@Service("finishService")
public class FinishServiceImpl extends BaseServiceImpl<FinishMapper, FinishEntity> implements IFinishService {


    private final String FINISH_CODE = "FINISH_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IQuoteService quoteService;

    @Autowired
    private IContractService contractService;

    @Override
    public CommonResponse<FinishVO> saveOrUpdateFinish(FinishVO saveorUpdateVO, boolean b) {
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(FINISH_CODE, tenantId);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        ContractEntity contractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if(contractEntity != null && contractEntity.getChangeStatus() == 2){
            return CommonResponse.error("该合同处于变更中状态，不能做竣工结算!");
        }


        //存在未生效的产值单，不能做竣工结算
        LambdaQueryWrapper<ProductionEntity> lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ProductionEntity::getContractId, saveorUpdateVO.getContractId());
        lambdachange.ne(ProductionEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ProductionEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int proNum = productionService.count(lambdachange);
        if (proNum > 0) {
            return CommonResponse.error("该合同存在未生效的产值单，不能做竣工结算!");
        }
        //存在未生效的甲方报量单，不能做竣工结算
        LambdaQueryWrapper<QuoteEntity> lambdQuote = Wrappers.lambdaQuery();
        lambdQuote.eq(QuoteEntity::getContractId, saveorUpdateVO.getContractId());
        lambdQuote.ne(QuoteEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdQuote.ne(QuoteEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int quoteNum = quoteService.count(lambdQuote);
        if (quoteNum > 0) {
            return CommonResponse.error("该合同存在未生效的报量单，不能做竣工结算!");
        }
        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getMainContractId, saveorUpdateVO.getContractId());
        lambda.eq(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(ContractEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(ContractEntity::getSupplementFlag, 1);
        int conNum = contractService.count(lambda);
        if (conNum > 0) {
            return CommonResponse.error("该合同存在未生效的补充协议，不能做竣工结算单!");
        }


        //竣工结算只能存在一条未生效的
        LambdaQueryWrapper<FinishEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(FinishEntity::getContractId, saveorUpdateVO.getContractId());
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            lambdaQuery.ne(FinishEntity::getId, saveorUpdateVO.getId());
        }
        int num = this.count(lambdaQuery);
        if (num > 0) {
            return CommonResponse.error("该合同已做过竣工结算单!");
        }





        FinishEntity entity = BeanMapper.map(saveorUpdateVO, FinishEntity.class);
        this.saveOrUpdate(entity, false);

        //更新合同是否竣工结算标志，合同做完竣工结算则做产值和报量参照不到
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getIsFinish, 1);
        updateWrapper.eq(ContractEntity::getId, saveorUpdateVO.getContractId());
        contractService.update(updateWrapper);

        FinishVO vo = BeanMapper.map(entity, FinishVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }
}
