package com.ejianc.business.income.mapper;

import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 产值进度 Mapper 接口
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Mapper
public interface ProductionMapper extends BaseCrudMapper<ProductionEntity> {
    @Select("SELECT MAX(production_date) from ejc_income_production eip where eip.dr=0 and contract_id=#{contractId} and eip.bill_state in (1,3)")
    Date getLastDate(Long contractId);

    List<ProductionVo> queryTotalFinishTaxMny(@Param("orgIds") List<Long> orgIds, @Param("yearFlag") Integer yearFlag);

}
