package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.other.bean.OtherHistoryClauseEntity;
import com.ejianc.business.other.bean.OtherHistoryDetailEntity;
import com.ejianc.business.other.bean.OtherHistoryEntity;
import com.ejianc.business.other.service.IOtherHistoryClauseService;
import com.ejianc.business.other.service.IOtherHistoryDetailService;
import com.ejianc.business.other.vo.OtherHistoryClauseVO;
import com.ejianc.business.other.vo.OtherHistoryDetailVO;
import com.ejianc.business.other.vo.OtherHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherHistoryMapper;
import com.ejianc.business.other.service.IOtherHistoryService;

import java.util.Collections;
import java.util.List;

/**
 * 其他收入合同记录表
 * 
 * @author generator
 * 
 */
@Service("otherHistoryService")
public class OtherHistoryServiceImpl extends BaseServiceImpl<OtherHistoryMapper, OtherHistoryEntity> implements IOtherHistoryService{

    @Autowired
    private IOtherHistoryDetailService historyDetailService;
    @Autowired
    private IOtherHistoryClauseService historyClauseService;

    @Override
    public OtherHistoryVO queryDetailByChangeId(Long changeId) {

        OtherHistoryEntity OtherHistoryEntity = baseMapper.selectOne(new QueryWrapper<OtherHistoryEntity>().eq("change_id", changeId));
        if(OtherHistoryEntity !=null){
            OtherHistoryVO OtherHistoryVO = BeanMapper.map(OtherHistoryEntity, OtherHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("historyId", new Parameter(QueryParam.EQ, OtherHistoryEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            List<OtherHistoryDetailEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);
            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<OtherHistoryDetailVO> detailVos = BeanMapper.mapList(historyDetailEntities, OtherHistoryDetailVO.class);
                OtherHistoryVO.setCheckList(detailVos);
            }
            QueryParam query = new QueryParam();
            query.getParams().put("historyId", new Parameter(QueryParam.EQ, OtherHistoryEntity.getId()));
            query.getOrderMap().put("createTime", "desc");
            List<OtherHistoryClauseEntity> clauses = historyClauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<OtherHistoryClauseVO> clauseVoList = BeanMapper.mapList(clauses, OtherHistoryClauseVO.class);
                OtherHistoryVO.setClauseList(clauseVoList);
            }
            return OtherHistoryVO;
        }
        return null;
    }
}
