package com.ejianc.business.other.service.impl;

import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;

@Service("otherSettle") 
public class OtherSettleBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOtherContractService contractService;
	@Autowired
	private IOtherSettleService quoteService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写主表
		OtherSettleEntity otherSettleEntity = quoteService.selectById(billId);
		OtherContractEntity contractEntity = contractService.selectById(otherSettleEntity.getContractId());
		//本期报量金额（含税）
		BigDecimal quoteTaxMny = otherSettleEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : otherSettleEntity.getQuoteTaxMny();
		//累计报量（含税）
		BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
		//累加
		contractEntity.setSumQuoteTaxMny(quoteTaxMny.add(sumQuoteTaxMny));
		//本期报量金额（不含税）
		BigDecimal quoteMny = otherSettleEntity.getQuoteMny() == null ? BigDecimal.ZERO : otherSettleEntity.getQuoteMny();
		//累计报量（不含税）
		BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
		//累计报量（不含税）
		contractEntity.setSumQuoteMny(quoteMny.add(sumQuoteMny));
		contractService.updateById(contractEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OtherSettleEntity quoteEntity = quoteService.selectById(billId);
		OtherContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
		//本期报量金额（含税）
		BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
		//累计报量（含税）
		BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
		//累减
		contractEntity.setSumQuoteTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));
		//本期报量金额（不含税）
		BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
		//累计报量（不含税）
		BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
		//累计报量（不含税）
		contractEntity.setSumQuoteMny(sumQuoteMny.subtract(quoteMny));

		contractService.updateById(contractEntity);

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
