package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleDetailEntity;
import com.ejianc.business.other.history.OtherSettleHistoryVO;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleDetailService;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherSettleMapper;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherSettleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 其他收入合同结算
 * 
 * @author generator
 * 
 */
@Service("otherSettleService")
public class OtherSettleServiceImpl extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity> implements IOtherSettleService{

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String OTHER_SETTLE_CODE = "OTHER_IN_SETTLE";
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private OtherSettleMapper otherSettleMapper;
    
    @Autowired
    private IOtherContractService contractService;
    
    @Autowired
    private IOtherSettleDetailService service;
    
    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(OTHER_SETTLE_CODE, tenantId);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode(billCode.getData());
            } else {
                return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        OtherContractEntity contractEntity = contractService.selectById(saveorUpdateVO.getContractId());
        if(contractEntity != null && contractEntity.getChangeStatus() == 2){
            return CommonResponse.error("该合同处于变更中状态，不能做合同结算!");
        }

        LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherContractEntity::getMainContractId,saveorUpdateVO.getContractId());
        lambda.eq(OtherContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getSupplementFlag, 1);
        int conNum = contractService.count(lambda);
        if (conNum > 0) {
            return CommonResponse.error("该合同存在未生效的补充协议，不能做合同结算!");
        }


        //合同结算只能存在一条未生效的
        LambdaQueryWrapper<OtherSettleEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, saveorUpdateVO.getContractId());
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            lambdaQuery.ne(OtherSettleEntity::getId, saveorUpdateVO.getId());
        }
        int num = this.count(lambdaQuery);
        if (num > 0) {
            return CommonResponse.error("该合同已做过合同结算!");
        }

        OtherSettleEntity entity = BeanMapper.map(saveorUpdateVO, OtherSettleEntity.class);
        this.saveOrUpdate(entity, false);

        //更新合同是否竣工结算标志，合同做完竣工结算则做产值和报量参照不到
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OtherContractEntity::getIsFinish, 1);
        updateWrapper.eq(OtherContractEntity::getId, saveorUpdateVO.getContractId());
        contractService.update(updateWrapper);

        OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = otherSettleMapper.selectById(id);
        if (entity != null) {
            OtherSettleVO vo = BeanMapper.map(entity, OtherSettleVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("quoteId", new Parameter(QueryParam.EQ, vo.getId()));
            List<OtherSettleDetailEntity> details = service.queryList(queryParam, false);
            vo.setCheckList(BeanMapper.mapList(details, OtherSettleDetailVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public OtherSettleHistoryVO queryQuoteHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<OtherSettleEntity> quoteEntities = otherSettleMapper.selectList(new QueryWrapper<OtherSettleEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("quote_date", "create_time"));
        OtherContractEntity contractEntity = contractService.selectById(id);
        OtherSettleHistoryVO vo = new OtherSettleHistoryVO();
        vo.setContractId(id);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setSumQuoteTaxMny(contractEntity.getSumQuoteTaxMny());
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumQuoteRate(BigDecimal.ZERO);//累计形象进度
        } else {
            vo.setSumQuoteRate(sumQuoteTaxMny.divide(contractEntity.getContractTaxMny(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
        }
        vo.setQuoteRecord(BeanMapper.mapList(quoteEntities, OtherSettleVO.class));
        return vo;
    }
}
