package com.ejianc.business.inother.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.inother.bean.*;
import com.ejianc.business.inother.service.*;
import com.ejianc.business.inother.vo.*;
import com.ejianc.business.inother.history.OtherChangeHistoryVO;
import com.ejianc.business.inother.mapper.OtherContractMapper;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.inother.mapper.OtherChangeMapper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 其他收入合同变更实体
 * 
 * @author generator
 * 
 */
@Service("otherChangeService")
public class OtherChangeServiceImpl extends BaseServiceImpl<OtherChangeMapper, OtherChangeEntity> implements IOtherChangeService {

    private static final String CHANGE_BILL_CODE = "OTHER_IN_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherChangeDetailService changeDetailService;
    @Autowired
    private IOtherChangeClauseService changeClauseService;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private OtherChangeMapper changeMapper;
    @Autowired
    private OtherContractMapper contractMapper;
    @Autowired
    private IOtherDetailService detailsService;
    @Autowired
    private IOtherClauseService clauseService;

    @Autowired
    private IOtherSupplementService supplementService;

    @Override
    public CommonResponse<OtherChangeVO> saveOrUpdate(OtherChangeVO OtherChangeVO) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherChangeEntity entity = null;
        String operateType = null;
        if (OtherChangeVO.getId() != null && OtherChangeVO.getId() > 0) { //修改
            if(StringUtils.isEmpty(OtherChangeVO.getBillCode())){
                OtherChangeVO.setBillCode(null);
            }
            entity = BeanMapper.map(OtherChangeVO, OtherChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == OtherChangeVO.getChangeVersion() || OtherChangeVO.getChangeVersion() == 0) {
                OtherChangeVO.setChangeVersion(1);//第一次变更
            } else {
                OtherChangeVO.setChangeVersion(OtherChangeVO.getChangeVersion() + 1);//版本号+1
            }
            if(2==OtherChangeVO.getChangeStatus()){
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(OtherChangeVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CHANGE_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    OtherChangeVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(OtherChangeVO, OtherChangeEntity.class);

            operateType = "add";
        }
        if (OtherChangeVO.getId() != null && OtherChangeVO.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherChangeEntity> lambda = Wrappers.<OtherChangeEntity>lambdaQuery();
            lambda.eq(OtherChangeEntity::getBillCode, OtherChangeVO.getBillCode());
            lambda.eq(OtherChangeEntity::getTenantId, tenantId);
            lambda.ne(OtherChangeEntity::getId, OtherChangeVO.getId());
            lambda.ne(OtherChangeEntity::getContractId, OtherChangeVO.getContractId());
            List<OtherChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherChangeEntity> lambda = Wrappers.<OtherChangeEntity>lambdaQuery();
            lambda.eq(OtherChangeEntity::getTenantId, tenantId);
            lambda.eq(OtherChangeEntity::getBillCode, OtherChangeVO.getBillCode());
            lambda.ne(OtherChangeEntity::getContractId, OtherChangeVO.getContractId());
            List<OtherChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, OtherChangeVO.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, OtherChangeVO.getContractId()));
        List<OtherContractEntity> entitiesc = contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<OtherSupplementEntity> lambdaQuery = Wrappers.<OtherSupplementEntity>lambdaQuery();
        lambdaQuery.eq(OtherSupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(OtherSupplementEntity::getMainContractId, OtherChangeVO.getContractId());
        lambdaQuery.ne(OtherSupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(OtherSupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int supnum = supplementService.count(lambdaQuery);
        if(supnum > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }
        entity.setBillType("other");
        super.saveOrUpdate(entity);

        List<OtherChangeDetailVO> detailsVos = OtherChangeVO.getCheckList();
        List<OtherChangeDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();

        if (operateType.equals("add")) {
            for (OtherChangeDetailVO detailsVo : detailsVos) {
                OtherChangeDetailEntity detailslist = BeanMapper.map(detailsVo, OtherChangeDetailEntity.class);
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setContractDetailId(detailsVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(detailsVo.getMny());
                detailslist.setBeforeChangePrice(detailsVo.getPrice());
                detailslist.setBeforeChangeNum(detailsVo.getNum());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (OtherChangeDetailVO detailsVo : detailsVos) {
                if ("add".equals(detailsVo.getRowState())) {
                    OtherChangeDetailEntity detailslist = BeanMapper.map(detailsVo, OtherChangeDetailEntity.class);
                    detailslist.setChangeId(entity.getId());
                    detailslist.setContractId(entity.getContractId());
                    detailslist.setContractDetailId(detailsVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                } else if ("edit".equals(detailsVo.getRowState())) {
                    OtherChangeDetailEntity detailslist = BeanMapper.map(detailsVo, OtherChangeDetailEntity.class);
                    saveOrUpldates.add(detailslist);
                } else if ("del".equals(detailsVo.getRowState())) {
                    deleteIds.add(detailsVo.getId());
                }
            }
        }

        if (saveOrUpldates.size() > 0) {
            changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            changeDetailService.removeByIds(deleteIds, false);
        }


        List<OtherChangeClauseVO> clauseVos = OtherChangeVO.getClauseList();
        List<OtherChangeClauseEntity> clauseList = new ArrayList<>();
        List<Long> deleteClauseIds = new ArrayList<>();
        for(OtherChangeClauseVO clauseVo:clauseVos) {
            if("add".equals(clauseVo.getRowState())) {
                OtherChangeClauseEntity detailslist = BeanMapper.map(clauseVo, OtherChangeClauseEntity.class);
                detailslist.setChangeId(entity.getId());
                detailslist.setContractId(entity.getContractId());
                detailslist.setId(null);
                clauseList.add(detailslist);
            }else if("edit".equals(clauseVo.getRowState())) {
                OtherChangeClauseEntity detailslist = BeanMapper.map(clauseVo, OtherChangeClauseEntity.class);
                clauseList.add(detailslist);
            } else if("del".equals(clauseVo.getRowState())) {
                deleteClauseIds.add(clauseVo.getId());
            }
        }
        if(clauseList.size() > 0) {
            changeClauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if(deleteClauseIds.size() > 0) {
            changeClauseService.removeByIds(deleteClauseIds, false);
        }

        //回写主表
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny,OtherChangeVO.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny,OtherChangeVO.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId,entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus,2);
        updateWrapper.set(OtherContractEntity::getChangeCode,entity.getBillCode());
        updateWrapper.eq(OtherContractEntity::getId,entity.getContractId());
        contractService.update(updateWrapper);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherChangeVO queryDetail(Long id) {
        OtherChangeEntity entity = super.selectById(id);
        OtherChangeVO OtherChangeVO = BeanMapper.map(entity, OtherChangeVO.class);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getOrderMap().put("createTime", "desc");
//        List<OtherChangeDetailEntity> detailEntityList = changeDetailService.queryList(queryParam, false);
//        if(CollectionUtils.isNotEmpty(detailEntityList)) {
//            List<OtherChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, OtherChangeDetailVO.class);
//            OtherChangeVO.setCheckList(resultMapList);
//        }
        List<OtherChangeDetailVO> checkList = OtherChangeVO.getCheckList();
        if (checkList != null && checkList.size() > 0) {
            OtherChangeVO.setCheckList(checkList);
        }
        List<OtherChangeClauseVO> clauses = OtherChangeVO.getClauseList();
        if (clauses != null && clauses.size() > 0) {
            OtherChangeVO.setClauseList(clauses);
        }
        return OtherChangeVO;
    }

    @Override
    public void deleteChange(List<OtherChangeVO> vos) {
        for (OtherChangeVO vo : vos) {
            OtherChangeEntity OtherChangeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny,BigDecimal.ZERO);
            if(OtherChangeEntity.getChangeVersion() == 1){
                updateWrapper.set(OtherContractEntity::getChangeStatus,1);
            }else {
                updateWrapper.set(OtherContractEntity::getChangeStatus,3);
            }
            updateWrapper.eq(OtherContractEntity::getId,OtherChangeEntity.getContractId());
            contractService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public OtherChangeHistoryVO queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<OtherChangeEntity> changeEntities = changeMapper.selectList(new QueryWrapper<OtherChangeEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        OtherContractEntity OtherContractEntity = contractService.selectById(id);
        OtherChangeHistoryVO vo = new OtherChangeHistoryVO();
        vo.setIsFinish(OtherContractEntity.getIsFinish());
        vo.setContractId(id);
        vo.setContractTaxMny(OtherContractEntity.getContractTaxMny()== null ? BigDecimal.ZERO : OtherContractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(OtherContractEntity.getBaseTaxMoney()== null ? BigDecimal.ZERO : OtherContractEntity.getBaseTaxMoney());
        vo.setChangeStatus(OtherContractEntity.getChangeStatus());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List<OtherChangeVO> OtherChangeVOs = BeanMapper.mapList(changeEntities, OtherChangeVO.class);
            for (OtherChangeVO cvo : OtherChangeVOs) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = ComputeUtil.safeSub(cvo.getContractTaxMny(), cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny() != null && cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = ComputeUtil.safeDiv(subtract, cvo.getBeforeChangeTaxMny()).setScale(8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
            }
            vo.setChangeRecord(OtherChangeVOs);
        }
        return vo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = contractMapper.selectById(id);
        if(entity != null) {
            OtherContractVO OtherContractVO = BeanMapper.map(entity, OtherContractVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, OtherContractVO.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            List<OtherDetailEntity> purchaseDetailss = detailsService.queryList(queryParam, false);
            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for(OtherDetailEntity cdEntity:purchaseDetailss){
                    cdEntity.setRowState("edit");
                }
                List<OtherDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, OtherDetailVO.class);
                OtherContractVO.setCheckList(resultMapList);
            }
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter(QueryParam.EQ, OtherContractVO.getId()));
            query.getOrderMap().put("createTime", "asc");
            List<OtherClauseEntity> clauses = clauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<OtherClauseVO> clauseVoList = BeanMapper.mapList(clauses, OtherClauseVO.class);
                for(OtherClauseVO ccv:clauseVoList){
                    ccv.setRowState("add");
                }
                OtherContractVO.setClauseList(clauseVoList);
            }
            OtherContractVO.setBeforeChangeTaxMny(entity.getContractTaxMny());
            OtherContractVO.setBillState(null);
            OtherContractVO.setCreateUserCode(null);
            OtherContractVO.setCreateTime(null);
            OtherContractVO.setUpdateUserCode(null);
            OtherContractVO.setUpdateTime(null);
            OtherContractVO.setChangeReason(null);
            return OtherContractVO;
        }
        return null;
    }
}
