/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.mapper.ContractDetailMapper;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="ContractDetailService")
public class ContractDetailServiceImpl
extends BaseServiceImpl<ContractDetailMapper, ContractDetailEntity>
implements IContractDetailService {
    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"contract_id", (Object)id);
        ((ContractDetailMapper)this.baseMapper).delete((Wrapper)deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ContractDetailVo> detailVoList = new ArrayList<ContractDetailVo>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractDetailVo vo = new ContractDetailVo();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "[\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "[\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a]";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setUnit((String)datas.get(3));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setDetailTaxRate(null);
                } else {
                    try {
                        vo.setDetailTaxRate(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxRate(null);
                        warnType = warnType + "[\u7a0e\u7387\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "[\u5de5\u7a0b\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "[\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setPrice(null);
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                    vo.setDetailTaxPrice(null);
                } else {
                    try {
                        vo.setDetailTaxPrice(new BigDecimal((String)datas.get(7)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxPrice(null);
                        warnType = warnType + "[\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(8)))) {
                    vo.setMny(null);
                } else {
                    try {
                        vo.setMny(new BigDecimal((String)datas.get(8)));
                    }
                    catch (Exception e) {
                        vo.setMny(null);
                        warnType = warnType + "[\u5408\u4ef7(\u65e0\u7a0e)\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                    vo.setDetailTaxMny(null);
                } else {
                    try {
                        vo.setDetailTaxMny(new BigDecimal((String)datas.get(9)));
                    }
                    catch (Exception e) {
                        vo.setDetailTaxMny(null);
                        warnType = warnType + "[\u5408\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(10)))) {
                    vo.setDetailTax(null);
                } else {
                    try {
                        vo.setDetailTax(new BigDecimal((String)datas.get(10)));
                    }
                    catch (Exception e) {
                        vo.setDetailTax(null);
                        warnType = warnType + "[\u7a0e\u989d\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setMemo((String)datas.get(11));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            for (ContractDetailVo tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            new TaxCalculateUtil().calculate(detailVoList);
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<ContractDetailVo> detailRef(Long contractId, String qureyText) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.ne((Object)"change_type", (Object)5);
        if (StringUtils.isNotEmpty((CharSequence)qureyText)) {
            wrapper.like((Object)"name", (Object)qureyText);
        }
        wrapper.orderBy(true, true, (Object[])new String[]{"detail_index"});
        List entities = ((ContractDetailMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            if (StringUtils.isNotEmpty((CharSequence)qureyText)) {
                ArrayList listTemp = new ArrayList();
                ArrayList<ContractDetailEntity> listChild = new ArrayList<ContractDetailEntity>();
                for (ContractDetailEntity cdEntity : entities) {
                    if (cdEntity.getParentId() != null) {
                        this.addFather(cdEntity.getParentId(), listTemp);
                    }
                    if (cdEntity.getLeafFlag().booleanValue()) continue;
                    this.addChild(cdEntity.getId(), listChild);
                }
                entities.addAll(listTemp);
                entities.addAll(listChild);
                entities.stream().distinct().collect(Collectors.toList());
            }
            for (ContractDetailEntity cdEntity : entities) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        List detailVos = BeanMapper.mapList((Iterable)entities, ContractDetailVo.class);
        Collections.sort(detailVos, new ContractDetailComparatorVo());
        return TreeNodeBUtil.buildTree((List)detailVos);
    }

    public List<ContractDetailEntity> addFather(Long id, List<ContractDetailEntity> list) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"id", (Object)id);
        ContractDetailEntity entity = (ContractDetailEntity)((Object)((ContractDetailMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        entity.setIsOpen("1");
        list.add(entity);
        if (entity.getParentId() != null) {
            this.addFather(entity.getParentId(), list);
        }
        return list;
    }

    public List<ContractDetailEntity> addChild(Long id, List<ContractDetailEntity> list) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        List entityList = ((ContractDetailMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entityList != null) {
            entityList.forEach(e -> {
                list.add((ContractDetailEntity)((Object)e));
                if (!e.getLeafFlag().booleanValue()) {
                    this.addChild(e.getId(), list);
                }
            });
        }
        return list;
    }
}

