/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.FinishEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.mapper.FinishMapper;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IFinishService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.FinishVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finishService")
public class FinishServiceImpl
extends BaseServiceImpl<FinishMapper, FinishEntity>
implements IFinishService {
    private final String FINISH_CODE = "FINISH_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IContractService contractService;

    @Override
    public CommonResponse<FinishVO> saveOrUpdateFinish(FinishVO saveorUpdateVO, boolean b) {
        int num;
        ContractEntity contractEntity;
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("FINISH_CODE", tenantId);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((contractEntity = (ContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))) != null && contractEntity.getChangeStatus() == 2) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5904\u4e8e\u53d8\u66f4\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u505a\u7ae3\u5de5\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ProductionEntity::getContractId, (Object)saveorUpdateVO.getContractId());
        lambdachange.ne(ProductionEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ProductionEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int proNum = this.productionService.count((Wrapper)lambdachange);
        if (proNum > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u4ea7\u503c\u5355\uff0c\u4e0d\u80fd\u505a\u7ae3\u5de5\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambdQuote = Wrappers.lambdaQuery();
        lambdQuote.eq(QuoteEntity::getContractId, (Object)saveorUpdateVO.getContractId());
        lambdQuote.ne(QuoteEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdQuote.ne(QuoteEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int quoteNum = this.quoteService.count((Wrapper)lambdQuote);
        if (quoteNum > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u62a5\u91cf\u5355\uff0c\u4e0d\u80fd\u505a\u7ae3\u5de5\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getMainContractId, (Object)saveorUpdateVO.getContractId());
        lambda.eq(ContractEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(ContractEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(ContractEntity::getSupplementFlag, (Object)1);
        int conNum = this.contractService.count((Wrapper)lambda);
        if (conNum > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u505a\u7ae3\u5de5\u7ed3\u7b97\u5355!");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(FinishEntity::getContractId, (Object)saveorUpdateVO.getContractId());
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if ((num = this.count((Wrapper)lambdaQuery)) > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u505a\u8fc7\u7ae3\u5de5\u7ed3\u7b97\u5355!");
        }
        FinishEntity entity = (FinishEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, FinishEntity.class));
        this.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getIsFinish, (Object)1);
        updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        FinishVO vo = (FinishVO)BeanMapper.map((Object)((Object)entity), FinishVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

