/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.mapper.ReportMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.utils.MathUtil;
import com.ejianc.business.income.utils.MonthUtil;
import com.ejianc.business.income.vo.ProjectProductionVo;
import com.ejianc.business.income.vo.comparator.MonthComparatorVo;
import com.ejianc.business.income.vo.comparator.ReportComparatorVo;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProductionCountVO;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.business.income.vo.report.ReportMonthVo;
import com.ejianc.business.income.vo.report.ReportSumVo;
import com.ejianc.business.income.vo.report.ReportVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
extends BaseServiceImpl<ReportMapper, ContractEntity>
implements IReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IQuoteService quoteService;

    @Override
    public JSONObject pageList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        String beginTime = "";
        String endTime = "";
        if (params.get("occTime") == null) {
            Date date = new Date();
            SimpleDateFormat yearformat = new SimpleDateFormat("yyyy");
            SimpleDateFormat monthformat = new SimpleDateFormat("yyyy-MM");
            beginTime = yearformat.format(date) + "-01-01";
            endTime = monthformat.format(date) + "-31";
        } else {
            String occTime = (String)((Parameter)params.get("occTime")).getValue();
            String[] split = occTime.split(",");
            beginTime = split[0].substring(0, 7) + "-01";
            endTime = split[1].substring(0, 7) + "-31";
        }
        String projectManager = params.get("projectManager") == null ? null : (String)((Parameter)params.get("projectManager")).getValue();
        String engineeringType = params.get("engineeringType") == null ? null : (String)((Parameter)params.get("engineeringType")).getValue();
        String text = param.getSearchText();
        List<Long> orgids = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        List<ReportVo> reportList = new ArrayList<ReportVo>();
        if (orgids != null && orgids.size() > 0) {
            reportList = this.reportMapper.getFinance(tenantId, endTime, projectManager, engineeringType, text, orgids);
        }
        List<ReportVo> reportVos = this.dateInterval(reportList, beginTime);
        JSONObject page = new JSONObject();
        if (reportVos == null || reportVos.size() < 1) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        Collections.sort(reportVos, new ReportComparatorVo());
        total = reportVos.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList<ReportVo> reportVoList = new ArrayList<ReportVo>();
        HashSet<Long> contractIds = new HashSet<Long>();
        HashMap<Long, Set<String>> cidTimeMap = new HashMap<Long, Set<String>>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            Set<String> ctime;
            ReportVo reportVo = reportVos.get(i);
            contractIds.add(reportVo.getContractId());
            if (cidTimeMap.containsKey(reportVo.getContractId())) {
                ctime = (Set)cidTimeMap.get(reportVo.getContractId());
                ctime.add(reportVo.getConfirmTime());
                cidTimeMap.put(reportVo.getContractId(), ctime);
            } else {
                ctime = new HashSet<String>();
                ctime.add(reportVo.getConfirmTime());
                cidTimeMap.put(reportVo.getContractId(), ctime);
            }
            reportVoList.add(reportVo);
        }
        List<ReportSumVo> proSumList = this.reportMapper.getProductionMny(contractIds, endTime);
        List<ReportSumVo> quoSumList = this.reportMapper.getQuoteMny(contractIds, endTime);
        Map<String, BigDecimal> receiveMny = this.getSumReceiveMny(reportList, cidTimeMap);
        Map<String, BigDecimal> proFinishMny = this.getFinishMny(proSumList, cidTimeMap);
        Map<String, BigDecimal> quoFinishMny = this.getFinishMny(quoSumList, cidTimeMap);
        for (ReportVo vo : reportVoList) {
            BigDecimal sumProductionTaxMny = proFinishMny.get(vo.getContractId() + vo.getConfirmTime());
            BigDecimal sumQuoteTaxMny = quoFinishMny.get(vo.getContractId() + vo.getConfirmTime());
            BigDecimal sumReceiveMny = receiveMny.get(vo.getContractId() + vo.getConfirmTime());
            BigDecimal receiveMnyRate = null;
            BigDecimal sumReceiveMnyRate = null;
            if (sumProductionTaxMny == null || sumProductionTaxMny.compareTo(BigDecimal.ZERO) == 0) {
                receiveMnyRate = BigDecimal.ZERO;
                sumReceiveMnyRate = BigDecimal.ZERO;
            } else {
                receiveMnyRate = vo.getReceiveMny().divide(sumProductionTaxMny, 8, 4).multiply(new BigDecimal(100));
                sumReceiveMnyRate = sumReceiveMny.divide(sumProductionTaxMny, 8, 4).multiply(new BigDecimal(100));
                if (receiveMnyRate.compareTo(BigDecimal.ZERO) > 0 && receiveMnyRate.compareTo(new BigDecimal("0.01")) < 0 && receiveMnyRate.compareTo(new BigDecimal("-0.01")) > 0) {
                    receiveMnyRate = new BigDecimal("0.01");
                }
                if (sumReceiveMnyRate.compareTo(BigDecimal.ZERO) > 0 && sumReceiveMnyRate.compareTo(new BigDecimal("0.01")) < 0 && sumReceiveMnyRate.compareTo(new BigDecimal("-0.01")) > 0) {
                    sumReceiveMnyRate = new BigDecimal("0.01");
                }
            }
            vo.setSumProductionTaxMny(sumProductionTaxMny);
            vo.setSumQuoteTaxMny(sumQuoteTaxMny);
            vo.setSumReceiveMny(sumReceiveMny);
            vo.setReceiveMnyRate(receiveMnyRate);
            vo.setSumReceiveMnyRate(sumReceiveMnyRate);
        }
        page.put("records", reportVoList);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public JSONObject monthPageList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        String beginTime = "";
        String endTime = "";
        if (params.get("occTime") == null) {
            Date date = new Date();
            SimpleDateFormat yearformat = new SimpleDateFormat("yyyy");
            SimpleDateFormat monthformat = new SimpleDateFormat("yyyy-MM");
            beginTime = yearformat.format(date) + "-01";
            endTime = monthformat.format(date);
        } else {
            String occTime = (String)((Parameter)params.get("occTime")).getValue();
            String[] split = occTime.split(",");
            beginTime = split[0].substring(0, 7);
            endTime = split[1].substring(0, 7);
        }
        String projectManager = params.get("projectManager") == null ? null : (String)((Parameter)params.get("projectManager")).getValue();
        String engineeringType = params.get("engineeringType") == null ? null : (String)((Parameter)params.get("engineeringType")).getValue();
        Integer monthRule = 1;
        Integer monthTime = 25;
        if (params.get("monthRule") != null && ((Parameter)params.get("monthRule")).getValue() != null) {
            monthRule = Integer.parseInt((String)((Parameter)params.get("monthRule")).getValue());
        }
        if (params.get("monthTime") != null && ((Parameter)params.get("monthTime")).getValue() != null) {
            monthTime = Integer.parseInt((String)((Parameter)params.get("monthTime")).getValue());
        }
        String text = param.getSearchText();
        List<Long> orgids = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        List<ReportMonthVo> reportVos = this.reportMapper.getProjectMonth(tenantId, projectManager, engineeringType, text, orgids);
        JSONObject page = new JSONObject();
        if (reportVos == null || reportVos.size() < 1) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        Integer lastDay = 0;
        lastDay = monthRule == 1 ? Integer.valueOf(monthTime + 1) : Integer.valueOf(32);
        String lastTime = endTime + "-" + lastDay;
        HashMap<Long, ReportMonthVo> proMap = new HashMap<Long, ReportMonthVo>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (ReportMonthVo vo : reportVos) {
            projectIds.add(vo.getProjectId());
            proMap.put(vo.getProjectId(), vo);
        }
        List<ReportSumVo> pcList = this.reportMapper.getProductionAndCost(lastTime, lastDay, projectIds);
        List<ReportSumVo> skList = this.reportMapper.getReceive(tenantId, lastTime, lastDay, projectIds);
        ArrayList<ReportMonthVo> allList = new ArrayList<ReportMonthVo>();
        for (ReportSumVo rsvo : pcList) {
            if ((rsvo.getProductionMny() == null || rsvo.getProductionMny().compareTo(BigDecimal.ZERO) == 0) && (rsvo.getFinishMny() == null || rsvo.getFinishMny().compareTo(BigDecimal.ZERO) == 0)) continue;
            rsvo.setProductionMny(rsvo.getProductionMny() == null ? BigDecimal.ZERO : rsvo.getProductionMny());
            rsvo.setFinishMny(rsvo.getFinishMny() == null ? BigDecimal.ZERO : rsvo.getFinishMny());
            if (!this.indexTime(rsvo.getOccurDate(), beginTime, endTime)) continue;
            ReportMonthVo rv = (ReportMonthVo)BeanMapper.map(proMap.get(rsvo.getRid()), ReportMonthVo.class);
            rv.setCountMonth(rsvo.getOccurDate());
            rv.setMonthProductionTaxMny(rsvo.getProductionMny());
            rv.setMonthCostMny(rsvo.getFinishMny());
            rv.setMonthProfit(rsvo.getProductionMny().subtract(rsvo.getFinishMny()));
            if (rsvo.getProductionMny() == null || rsvo.getProductionMny().compareTo(BigDecimal.ZERO) == 0) {
                rv.setMonthProfitRate(BigDecimal.ZERO);
            } else {
                BigDecimal monthProfitRate = rv.getMonthProfit().divide(rsvo.getProductionMny(), 8, 4).multiply(new BigDecimal(100));
                if (monthProfitRate.compareTo(BigDecimal.ZERO) > 0 && monthProfitRate.compareTo(new BigDecimal("0.01")) < 0 && monthProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                    monthProfitRate = new BigDecimal("0.01");
                }
                rv.setMonthProfitRate(monthProfitRate);
            }
            allList.add(rv);
        }
        if (allList == null || allList.size() < 1) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        Collections.sort(allList, new MonthComparatorVo());
        total = allList.size();
        if (size == -1) {
            size = total;
        }
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList<ReportMonthVo> responseList = new ArrayList<ReportMonthVo>();
        HashMap<Long, Set<String>> cidTimeMap = new HashMap<Long, Set<String>>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            Set<String> ctime;
            ReportMonthVo rmVo = (ReportMonthVo)allList.get(i);
            if (cidTimeMap.containsKey(rmVo.getProjectId())) {
                ctime = (Set)cidTimeMap.get(rmVo.getProjectId());
                ctime.add(rmVo.getCountMonth());
                cidTimeMap.put(rmVo.getProjectId(), ctime);
            } else {
                ctime = new HashSet<String>();
                ctime.add(rmVo.getCountMonth());
                cidTimeMap.put(rmVo.getProjectId(), ctime);
            }
            responseList.add(rmVo);
        }
        Map<String, BigDecimal> skFinishMny = this.getFinishMny(skList, cidTimeMap);
        HashMap<String, BigDecimal> chanzhiMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> chengbenMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> chanzhiYear = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> chengbenYear = new HashMap<String, BigDecimal>();
        for (ReportSumVo reportSumVo : pcList) {
            if (!cidTimeMap.containsKey(reportSumVo.getRid())) continue;
            Set ctimeList = (Set)cidTimeMap.get(reportSumVo.getRid());
            for (String ctime : ctimeList) {
                BigDecimal add;
                if (MonthUtil.compareTime(ctime, reportSumVo.getOccurDate()) >= 0) {
                    if (chanzhiMap.containsKey(reportSumVo.getRid() + ctime)) {
                        add = MathUtil.safeAdd((BigDecimal)chanzhiMap.get(reportSumVo.getRid() + ctime), reportSumVo.getProductionMny());
                        chanzhiMap.put(reportSumVo.getRid() + ctime, add);
                    } else {
                        chanzhiMap.put(reportSumVo.getRid() + ctime, reportSumVo.getProductionMny());
                    }
                    if (chengbenMap.containsKey(reportSumVo.getRid() + ctime)) {
                        add = MathUtil.safeAdd((BigDecimal)chengbenMap.get(reportSumVo.getRid() + ctime), reportSumVo.getFinishMny());
                        chengbenMap.put(reportSumVo.getRid() + ctime, add);
                    } else {
                        chengbenMap.put(reportSumVo.getRid() + ctime, reportSumVo.getFinishMny());
                    }
                }
                if (!this.indexTime(reportSumVo.getOccurDate(), this.firstMonth(ctime), ctime)) continue;
                if (chanzhiYear.containsKey(reportSumVo.getRid() + ctime)) {
                    add = MathUtil.safeAdd((BigDecimal)chanzhiYear.get(reportSumVo.getRid() + ctime), reportSumVo.getProductionMny());
                    chanzhiYear.put(reportSumVo.getRid() + ctime, add);
                } else {
                    chanzhiYear.put(reportSumVo.getRid() + ctime, reportSumVo.getProductionMny());
                }
                if (chengbenYear.containsKey(reportSumVo.getRid() + ctime)) {
                    add = MathUtil.safeAdd((BigDecimal)chengbenYear.get(reportSumVo.getRid() + ctime), reportSumVo.getFinishMny());
                    chengbenYear.put(reportSumVo.getRid() + ctime, add);
                    continue;
                }
                chengbenYear.put(reportSumVo.getRid() + ctime, reportSumVo.getFinishMny());
            }
        }
        for (ReportMonthVo reportMonthVo : responseList) {
            String ctime = reportMonthVo.getProjectId() + reportMonthVo.getCountMonth();
            BigDecimal sumReceiveMny = skFinishMny.get(ctime);
            BigDecimal yearProductionTaxMny = (BigDecimal)chanzhiYear.get(ctime);
            BigDecimal yearCostMny = (BigDecimal)chengbenYear.get(ctime);
            BigDecimal yearProfit = yearProductionTaxMny.subtract(yearCostMny);
            BigDecimal yearProfitRate = BigDecimal.ZERO;
            if (yearProductionTaxMny != null && yearProductionTaxMny.compareTo(BigDecimal.ZERO) != 0 && (yearProfitRate = yearProfit.divide(yearProductionTaxMny, 8, 4).multiply(new BigDecimal(100))).compareTo(BigDecimal.ZERO) > 0 && yearProfitRate.compareTo(new BigDecimal("0.01")) < 0 && yearProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                yearProfitRate = new BigDecimal("0.01");
            }
            BigDecimal sumProductionTaxMny = (BigDecimal)chanzhiMap.get(ctime);
            BigDecimal sumCostMny = (BigDecimal)chengbenMap.get(ctime);
            BigDecimal sumProfit = sumProductionTaxMny.subtract(sumCostMny);
            BigDecimal sumProfitRate = BigDecimal.ZERO;
            if (sumProductionTaxMny != null && sumProductionTaxMny.compareTo(BigDecimal.ZERO) != 0 && (sumProfitRate = sumProfit.divide(sumProductionTaxMny, 8, 4).multiply(new BigDecimal(100))).compareTo(BigDecimal.ZERO) != 0 && sumProfitRate.compareTo(new BigDecimal("0.01")) < 0 && sumProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                sumProfitRate = new BigDecimal("0.01");
            }
            reportMonthVo.setSumReceiveMny(sumReceiveMny);
            reportMonthVo.setYearProductionTaxMny(yearProductionTaxMny);
            reportMonthVo.setYearCostMny(yearCostMny);
            reportMonthVo.setYearProfit(yearProfit);
            reportMonthVo.setYearProfitRate(yearProfitRate);
            reportMonthVo.setSumProductionTaxMny(sumProductionTaxMny);
            reportMonthVo.setSumCostMny(sumCostMny);
            reportMonthVo.setSumProfit(sumProfit);
            reportMonthVo.setSumProfitRate(sumProfitRate);
        }
        page.put("records", responseList);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public ProjectReportVo projectMonth(Long projectId, Integer lastDay) {
        return ((ReportMapper)this.baseMapper).getDate(projectId, lastDay);
    }

    @Override
    public BigDecimal sumContractMny(Long projectId) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List entities = super.list((Wrapper)lambda);
        for (ContractEntity ce : entities) {
            contractTaxMny = contractTaxMny.add(ce.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public List<ProjectReportVo> getMonthProductionMny(Long projectId, Integer lastDay) {
        return ((ReportMapper)this.baseMapper).getMonthProductionMny(projectId, lastDay);
    }

    @Override
    public IncomeReportMnyVo getIncomeMny(Long projectId) {
        BigDecimal contractAmount = BigDecimal.ZERO;
        BigDecimal visaAmount = BigDecimal.ZERO;
        BigDecimal outputAmount = BigDecimal.ZERO;
        BigDecimal batchAmount = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ContractEntity::getBillState, billStatus);
        lambda.in(ContractEntity::getSupplementFlag, new Object[]{0});
        List entities = super.list((Wrapper)lambda);
        for (ContractEntity ce : entities) {
            contractAmount = contractAmount.add(ce.getContractTaxMny());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(ClaimEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(ClaimEntity::getBillState, billStatus);
        List claimEntities = this.claimService.list((Wrapper)lambda2);
        for (ClaimEntity ce : claimEntities) {
            visaAmount = visaAmount.add(ce.getReplyMny());
        }
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(ProductionEntity::getProjectId, (Object)projectId);
        lambda3.eq(BaseEntity::getDr, (Object)0);
        lambda3.in(ProductionEntity::getBillState, billStatus);
        List productionEntities = this.productionService.list((Wrapper)lambda3);
        for (ProductionEntity ce : productionEntities) {
            outputAmount = outputAmount.add(ce.getFinishTaxMny());
        }
        LambdaQueryWrapper lambda4 = Wrappers.lambdaQuery();
        lambda4.eq(QuoteEntity::getProjectId, (Object)projectId);
        lambda4.eq(BaseEntity::getDr, (Object)0);
        lambda4.in(QuoteEntity::getBillState, billStatus);
        List quoteEntities = this.quoteService.list((Wrapper)lambda4);
        for (QuoteEntity ce : quoteEntities) {
            batchAmount = batchAmount.add(ce.getQuoteTaxMny());
        }
        IncomeReportMnyVo incomeReportMnyVo = new IncomeReportMnyVo();
        incomeReportMnyVo.setContractAmount(contractAmount);
        incomeReportMnyVo.setContractQuantity(Integer.valueOf(entities.size()));
        incomeReportMnyVo.setVisaAmount(visaAmount);
        incomeReportMnyVo.setVisasNumber(Integer.valueOf(claimEntities.size()));
        incomeReportMnyVo.setOutputAmount(outputAmount);
        incomeReportMnyVo.setOutputNumber(Integer.valueOf(productionEntities.size()));
        incomeReportMnyVo.setBatchAmount(batchAmount);
        incomeReportMnyVo.setBatchNumber(Integer.valueOf(quoteEntities.size()));
        return incomeReportMnyVo;
    }

    @Override
    public List<ProjectReportVo> getMonthProduction(Long projectId) {
        return ((ReportMapper)this.baseMapper).getMonthProduction(projectId);
    }

    @Override
    public JSONObject productionCountList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        String text = param.getSearchText();
        String countMonth = null;
        JSONObject page = new JSONObject();
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        if (params.get("countMonth") == null) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        countMonth = (String)((Parameter)params.get("countMonth")).getValue();
        String engineeringType = params.get("engineeringType") == null ? null : (String)((Parameter)params.get("engineeringType")).getValue();
        List<Long> orgids = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<ProductionCountVO> list = ((ReportMapper)this.baseMapper).productionCountList(text, tenantId, orgids, engineeringType);
        if (list == null || list.size() <= 0) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        total = list.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList<Long> contractIds = new ArrayList<Long>();
        ArrayList<ProductionCountVO> res = new ArrayList<ProductionCountVO>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            ProductionCountVO productionCountVO = list.get(i);
            if (productionCountVO.getContractId() != null) {
                contractIds.add(productionCountVO.getContractId());
            }
            res.add(productionCountVO);
        }
        if (contractIds.size() <= 0) {
            page.put("records", res);
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        List<ProductionCountVO> monthPlanMny = ((ReportMapper)this.baseMapper).monthPlanMny(countMonth, contractIds);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String nextMonth = MonthUtil.monthAdd(sdf, countMonth, 1);
        List<ProductionCountVO> nextMonthPlanMny = ((ReportMapper)this.baseMapper).monthPlanMny(nextMonth, contractIds);
        List<ProductionCountVO> monthProduction = ((ReportMapper)this.baseMapper).monthProduction(countMonth, contractIds);
        List<ProductionCountVO> thisYearQuote = ((ReportMapper)this.baseMapper).thisYearQuote(countMonth, contractIds);
        List<ProductionCountVO> sumClaimMny = ((ReportMapper)this.baseMapper).sumClaimMny(countMonth, contractIds);
        List<ProductionCountVO> receiveMny = ((ReportMapper)this.baseMapper).receiveMny(countMonth, contractIds);
        List<ProductionCountVO> finishDate = ((ReportMapper)this.baseMapper).finishDate(countMonth, contractIds);
        List<ProductionCountVO> totalFinishTaxMnyVo = ((ReportMapper)this.baseMapper).getTotalFinishTaxMny(contractIds);
        HashMap<Long, ProductionCountVO> totalFinishTaxMnyMap = new HashMap<Long, ProductionCountVO>();
        for (ProductionCountVO productionCountVO : totalFinishTaxMnyVo) {
            if (totalFinishTaxMnyMap.containsKey(productionCountVO.getContractId())) {
                ProductionCountVO productionCountVO2 = (ProductionCountVO)totalFinishTaxMnyMap.get(productionCountVO.getContractId());
                if (MonthUtil.compareTime(productionCountVO.getCountMonth(), productionCountVO2.getCountMonth()) <= 0) continue;
                totalFinishTaxMnyMap.put(productionCountVO.getContractId(), productionCountVO);
                continue;
            }
            totalFinishTaxMnyMap.put(productionCountVO.getContractId(), productionCountVO);
        }
        HashMap<Long, BigDecimal> amap = new HashMap<Long, BigDecimal>();
        for (ProductionCountVO productionCountVO : monthPlanMny) {
            amap.put(productionCountVO.getContractId(), productionCountVO.getPlanTaxMny());
        }
        HashMap<Long, ProductionCountVO> hashMap = new HashMap<Long, ProductionCountVO>();
        for (ProductionCountVO productionCountVO : nextMonthPlanMny) {
            hashMap.put(productionCountVO.getContractId(), productionCountVO);
        }
        HashMap<Long, ProductionCountVO> hashMap2 = new HashMap<Long, ProductionCountVO>();
        for (ProductionCountVO vo : monthProduction) {
            hashMap2.put(vo.getContractId(), vo);
        }
        HashMap<Long, BigDecimal> hashMap3 = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> emap = new HashMap<Long, BigDecimal>();
        for (ProductionCountVO productionCountVO : thisYearQuote) {
            BigDecimal quoteMny = productionCountVO.getQuoteTaxMny() == null ? BigDecimal.ZERO : productionCountVO.getQuoteTaxMny();
            String FirstMonth = MonthUtil.getOneMonth(countMonth);
            if (MonthUtil.compareTime(productionCountVO.getCountMonth(), FirstMonth) >= 0) {
                if (hashMap3.containsKey(productionCountVO.getContractId())) {
                    BigDecimal dmny = hashMap3.get(productionCountVO.getContractId()) == null ? BigDecimal.ZERO : (BigDecimal)hashMap3.get(productionCountVO.getContractId());
                    hashMap3.put(productionCountVO.getContractId(), dmny.add(quoteMny));
                } else {
                    hashMap3.put(productionCountVO.getContractId(), quoteMny);
                }
            }
            if (emap.containsKey(productionCountVO.getContractId())) {
                BigDecimal emny = emap.get(productionCountVO.getContractId()) == null ? BigDecimal.ZERO : (BigDecimal)emap.get(productionCountVO.getContractId());
                emap.put(productionCountVO.getContractId(), emny.add(quoteMny));
                continue;
            }
            emap.put(productionCountVO.getContractId(), quoteMny);
        }
        HashMap<Long, ProductionCountVO> fmap = new HashMap<Long, ProductionCountVO>();
        for (ProductionCountVO vo : sumClaimMny) {
            BigDecimal sumOccurMny = vo.getSumOccurMny() == null ? BigDecimal.ZERO : vo.getSumOccurMny();
            BigDecimal sumReplyMny = vo.getSumReplyMny() == null ? BigDecimal.ZERO : vo.getSumReplyMny();
            vo.setOutClaimMny(sumOccurMny.subtract(sumReplyMny));
            fmap.put(vo.getContractId(), vo);
        }
        HashMap<Long, BigDecimal> hashMap4 = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> hmap = new HashMap<Long, BigDecimal>();
        for (ProductionCountVO vo : receiveMny) {
            BigDecimal receive;
            BigDecimal bigDecimal = receive = vo.getReceiveMny() == null ? BigDecimal.ZERO : vo.getReceiveMny();
            if (vo.getCountMonth().equals(countMonth)) {
                hashMap4.put(vo.getContractId(), receive);
            }
            if (hmap.containsKey(vo.getContractId())) {
                BigDecimal hmny = hmap.get(vo.getContractId()) == null ? BigDecimal.ZERO : (BigDecimal)hmap.get(vo.getContractId());
                hmap.put(vo.getContractId(), hmny.add(receive));
                continue;
            }
            hmap.put(vo.getContractId(), receive);
        }
        Map<Long, Date> finishMap = finishDate.stream().collect(Collectors.toMap(ProductionCountVO::getContractId, ProductionCountVO::getFinishDate));
        for (ProductionCountVO vo : res) {
            ProductionCountVO productionCountVO;
            Long contractId = vo.getContractId();
            vo.setPlanTaxMny((BigDecimal)amap.get(contractId));
            vo.setNextPlanTaxMny(hashMap.get(contractId) == null ? null : ((ProductionCountVO)hashMap.get(contractId)).getPlanTaxMny());
            vo.setNextPlanProgress(hashMap.get(contractId) == null ? null : ((ProductionCountVO)hashMap.get(contractId)).getNextPlanProgress());
            ProductionCountVO pVO = (ProductionCountVO)hashMap2.get(contractId);
            if (pVO != null) {
                vo.setFinishTaxMny(pVO.getFinishTaxMny());
                vo.setFinshRate(pVO.getFinshRate());
                vo.setSatisfyFlag(pVO.getSatisfyFlag());
                vo.setVisualProgress(pVO.getVisualProgress());
                vo.setExistProblem(pVO.getExistProblem());
                vo.setYearPlanTaxMny(pVO.getYearPlanTaxMny());
                vo.setYearFinishTaxMny(pVO.getYearFinishTaxMny());
                vo.setAllVisualProgress(pVO.getAllVisualProgress());
                vo.setEvaluateState(pVO.getEvaluateState());
                vo.setLagExplain(pVO.getLagExplain());
            }
            if ((productionCountVO = (ProductionCountVO)totalFinishTaxMnyMap.get(contractId)) != null) {
                vo.setTotalFinishTaxMny(productionCountVO.getTotalFinishTaxMny());
                vo.setTotalFinishRate(productionCountVO.getTotalFinishRate());
            }
            vo.setYearQuoteTaxMny((BigDecimal)hashMap3.get(contractId));
            vo.setTotalQuoteTaxMny((BigDecimal)emap.get(contractId));
            ProductionCountVO claimVo = (ProductionCountVO)fmap.get(contractId);
            if (claimVo != null) {
                vo.setSumReplyMny(claimVo.getSumReplyMny());
                vo.setOutClaimMny(claimVo.getOutClaimMny());
            }
            vo.setReceiveMny((BigDecimal)hashMap4.get(contractId));
            vo.setSumReceiveMny((BigDecimal)hmap.get(contractId));
            vo.setFinishDate(finishMap.get(contractId));
            BigDecimal sumReceiveRate = BigDecimal.ZERO;
            BigDecimal sumReceiveMny = vo.getSumReceiveMny();
            BigDecimal totalFinishTaxMny = vo.getTotalFinishTaxMny();
            sumReceiveRate = sumReceiveMny == null || totalFinishTaxMny == null || totalFinishTaxMny.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumReceiveMny.divide(totalFinishTaxMny, 8, 4).multiply(new BigDecimal(100));
            vo.setSumReceiveRate(sumReceiveRate);
        }
        page.put("records", res);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public JSONObject projectProductionCountList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map params = param.getParams();
        String text = param.getSearchText();
        String countMonth = null;
        JSONObject page = new JSONObject();
        int total = 0;
        int current = pageIndex;
        int size = pageSize;
        int pages = 0;
        if (params.get("countMonth") == null) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        countMonth = (String)((Parameter)params.get("countMonth")).getValue();
        List<Long> orgids = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        List<ProjectProductionVo> list = ((ReportMapper)this.baseMapper).projectProductionCountList(text, tenantId, orgids, countMonth);
        if (list == null || list.size() <= 0) {
            page.put("records", new ArrayList());
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        total = list.size();
        if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        int num = 0;
        num = (current - 1) * size + size > total ? total - (current - 1) * size : size;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        ArrayList<ProjectProductionVo> res = new ArrayList<ProjectProductionVo>();
        for (int i = (current - 1) * size; i < (current - 1) * size + num; ++i) {
            ProjectProductionVo projectProductionVo = list.get(i);
            if (projectProductionVo.getProjectId() != null) {
                projectIds.add(projectProductionVo.getProjectId());
            }
            res.add(projectProductionVo);
        }
        if (projectIds.size() <= 0) {
            page.put("records", res);
            page.put("total", (Object)total);
            page.put("current", (Object)current);
            page.put("size", (Object)size);
            page.put("pages", (Object)pages);
            return page;
        }
        page.put("records", res);
        page.put("total", (Object)total);
        page.put("current", (Object)current);
        page.put("size", (Object)size);
        page.put("pages", (Object)pages);
        return page;
    }

    private List<ReportVo> dateInterval(List<ReportVo> reportList, String beginTime) {
        ArrayList<ReportVo> list = new ArrayList<ReportVo>();
        Integer startTime = Integer.parseInt(beginTime.replaceAll("-", ""));
        for (ReportVo vo : reportList) {
            if (Integer.parseInt(vo.getConfirmTime().replaceAll("-", "")) < startTime) continue;
            list.add(vo);
        }
        return list;
    }

    private boolean indexTime(String t1, String t2, String t3) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        int trr3 = Integer.parseInt(t3.replaceAll("-", ""));
        return trr1 >= trr2 && trr1 <= trr3;
    }

    private String firstMonth(String t1) {
        return t1.substring(0, 5) + "01";
    }

    private Map<String, BigDecimal> getSumReceiveMny(List<ReportVo> reportList, Map<Long, Set<String>> cidTimeMap) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (ReportVo vo : reportList) {
            if (!cidTimeMap.containsKey(vo.getContractId())) continue;
            Set<String> ctimeList = cidTimeMap.get(vo.getContractId());
            for (String ctime : ctimeList) {
                if (MonthUtil.compareTime(ctime, vo.getConfirmTime()) < 0) continue;
                if (map.containsKey(vo.getContractId() + ctime)) {
                    BigDecimal add = ((BigDecimal)map.get(vo.getContractId() + ctime)).add(vo.getReceiveMny());
                    map.put(vo.getContractId() + ctime, add);
                    continue;
                }
                map.put(vo.getContractId() + ctime, vo.getReceiveMny());
            }
        }
        return map;
    }

    private Map<String, BigDecimal> getFinishMny(List<ReportSumVo> reportList, Map<Long, Set<String>> cidTimeMap) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (ReportSumVo vo : reportList) {
            if (!cidTimeMap.containsKey(vo.getRid())) continue;
            Set<String> ctimeList = cidTimeMap.get(vo.getRid());
            for (String ctime : ctimeList) {
                if (MonthUtil.compareTime(ctime, vo.getOccurDate()) < 0) continue;
                if (map.containsKey(vo.getRid() + ctime)) {
                    BigDecimal add = ((BigDecimal)map.get(vo.getRid() + ctime)).add(vo.getFinishMny() == null ? BigDecimal.ZERO : vo.getFinishMny());
                    map.put(vo.getRid() + ctime, add);
                    continue;
                }
                map.put(vo.getRid() + ctime, vo.getFinishMny() == null ? BigDecimal.ZERO : vo.getFinishMny());
            }
        }
        return map;
    }
}

