/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.FinalizedEntity;
import com.ejianc.business.income.enums.FinalStageEnum;
import com.ejianc.business.income.service.IFinalizedService;
import com.ejianc.business.income.vo.FinalizedVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"finalized"})
public class FinalizedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFinalizedService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.service.saveOrUpdate(saveorUpdateVO)));
    }

    @RequestMapping(value={"/validateFinalStage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    @RequestMapping(value={"/queryFinalStage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryFinalStage(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)this.service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    @RequestMapping(value={"/queryFinalized"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryFinalized(@RequestParam(required=false) Long projectId, @RequestParam Long contractId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(FinalizedEntity::getProjectId, (Object)projectId);
        query.eq(FinalizedEntity::getContractId, (Object)contractId);
        query.eq(FinalizedEntity::getFinalStage, (Object)1);
        query.in(FinalizedEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        List entities = this.service.list((Wrapper)query);
        BigDecimal settleMny = new BigDecimal(0);
        if (ListUtil.isNotEmpty((List)entities)) {
            for (FinalizedEntity entity : entities) {
                if (!Objects.equals(entity.getFinalStage(), FinalStageEnum.\u4e00\u5ba1.getCode())) continue;
                settleMny = entity.getReportSettleMny();
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)settleMny);
    }

    @RequestMapping(value={"/queryFinalizedList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required=false) Long projectId, @RequestParam Long contractId, @RequestParam(required=false) Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.service.queryFinalizedList(projectId, contractId, id)));
    }

    @RequestMapping(value={"/queryFinal"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FinalizedEntity>> queryFinal(@RequestParam(required=false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", this.service.queryFinalized(projectId, contractId));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
        FinalizedEntity entity = (FinalizedEntity)((Object)this.service.selectById(id));
        FinalizedVO vo = (FinalizedVO)((Object)BeanMapper.map((Object)((Object)entity), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, FinalizedVO.class);
        for (FinalizedVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e00\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e00\u5ba1");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e8c\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e8c\u5ba1");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.\u4e09\u5ba1.getCode())) {
                vo.setFinalStageName("\u4e09\u5ba1");
            }
            if (!Objects.equals(vo.getFinalStage(), FinalStageEnum.\u7ec8\u5ba1.getCode())) continue;
            vo.setFinalStageName("\u7ec8\u5ba1");
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFinalizedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FinalizedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

