/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionPlanEntity;
import com.ejianc.business.income.history.ProductionPlanHistoryVo;
import com.ejianc.business.income.mapper.ProductionPlanMapper;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionPlanService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.MonthUtil;
import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="productionPlanService")
public class ProductionPlanServiceImpl
extends BaseServiceImpl<ProductionPlanMapper, ProductionPlanEntity>
implements IProductionPlanService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCTION_PLAN = "PRODUCTION_PLAN";
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ProductionPlanMapper planMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<ProductionPlanVO> saveOrUpdate(ProductionPlanVO saveorUpdateVO) {
        List entities;
        block20: {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()));
            if (contractEntity != null && contractEntity.getIsFinish() == 1) {
                return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u505a\u7ae3\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u505a\u4ea7\u503c\u8ba1\u5212\uff01");
            }
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(saveorUpdateVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (saveorUpdateVO.getContractVersion() == null || saveorUpdateVO.getContractVersion() == 0) break block20;
                if (locked) {
                    Integer conVersion;
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    if (!version.equals(conVersion = saveorUpdateVO.getContractVersion())) {
                        CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block20;
                }
                CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return version;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(saveorUpdateVO.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)saveorUpdateVO.getContractId()));
        queryParam.getOrderMap().put("planMonth", "desc");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
        }
        if (ListUtil.isNotEmpty((List)(entities = super.queryList(queryParam, false)))) {
            DateTime maxDate;
            List billStateList = entities.stream().filter(list -> !billStatus.contains(list.getBillState())).collect(Collectors.toList());
            if (ListUtil.isNotEmpty(billStateList)) {
                throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u4ea7\u503c\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
            }
            List allMonth = entities.stream().map(ProductionPlanEntity::getPlanMonth).collect(Collectors.toList());
            if (allMonth.contains(saveorUpdateVO.getPlanMonth())) {
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u8be5\u8ba1\u5212\u6708\u4efd\u5df2\u5236\u5b9a\u4ea7\u503c\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
            }
            DateTime planMonth = DateUtil.parse((String)saveorUpdateVO.getPlanMonth(), (String)"yyyy-MM");
            if (planMonth.compareTo((Date)(maxDate = DateUtil.parse((String)((ProductionPlanEntity)((Object)entities.get(0))).getPlanMonth(), (String)"yyyy-MM"))) < 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u6bd4\u5f53\u524d\u8ba1\u5212\u6708\u4efd\u66f4\u665a\u7684\u4ea7\u503c\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
            }
        }
        DateTime planMonthDate = DateUtil.parse((String)saveorUpdateVO.getPlanMonth(), (String)"yyyy-MM");
        saveorUpdateVO.setPlanMonthDate((Date)planMonthDate);
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionPlanEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (ProductionPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionPlanEntity.class));
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PRODUCTION_PLAN, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (ProductionPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionPlanEntity.class));
        }
        super.saveOrUpdate((Object)entity, false);
        ProductionPlanVO vo = (ProductionPlanVO)BeanMapper.map((Object)((Object)entity), ProductionPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<ProductionPlanVO> getPlanMonth(Long contractId) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getOrderMap().put("planMonth", "desc");
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        List entities = super.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8ba1\u5212\u6708\u4efd\u6210\u529f\uff01", (Object)new ProductionPlanVO());
        }
        ProductionPlanVO vo = (ProductionPlanVO)BeanMapper.map(entities.get(0), ProductionPlanVO.class);
        vo.setPlanMonth(MonthUtil.monthAdd(new SimpleDateFormat("yyyy-MM"), vo.getPlanMonth(), 1));
        return CommonResponse.success((String)"\u67e5\u8be2\u8ba1\u5212\u6708\u4efd\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<ProductionPlanVO> getYearPlanTaxMny(Long contractId, Date planMonth) {
        String year;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getOrderMap().put("planMonth", "asc");
        List entities = super.queryList(queryParam, false);
        if (ListUtil.isEmpty((List)entities)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u672c\u5e74\u8ba1\u5212\u4ea7\u503c\u6210\u529f\uff01", (Object)new ProductionPlanVO());
        }
        Map<String, List<ProductionPlanEntity>> map = entities.stream().collect(Collectors.groupingBy(list -> list.getPlanMonth().split("-")[0]));
        if (map.containsKey(year = String.valueOf(DateUtil.year((Date)planMonth)))) {
            List<ProductionPlanEntity> list2 = map.get(year);
            ProductionPlanVO vo = (ProductionPlanVO)BeanMapper.map((Object)((Object)list2.get(0)), ProductionPlanVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u672c\u5e74\u8ba1\u5212\u4ea7\u503c\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u672c\u5e74\u8ba1\u5212\u4ea7\u503c\u6210\u529f\uff01", (Object)new ProductionPlanVO());
    }

    @Override
    public ProductionPlanHistoryVo queryProductionPlanHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List planEntities = this.planMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"plan_month", "create_time"}));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        ProductionPlanHistoryVo vo = new ProductionPlanHistoryVo();
        vo.setContractId(id);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractTaxMny(contractTaxMny);
        BigDecimal totalPlanTaxMny = null;
        BigDecimal totalPlanRate = null;
        if (ListUtil.isNotEmpty((List)planEntities)) {
            totalPlanTaxMny = planEntities.stream().filter(entity -> entity.getPlanTaxMny() != null).map(ProductionPlanEntity::getPlanTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalPlanRate = ComputeUtil.safeDiv(totalPlanTaxMny, contractTaxMny);
        }
        vo.setTotalPlanTaxMny(totalPlanTaxMny);
        vo.setTotalPlanRate(ComputeUtil.safeMultiply(totalPlanRate, new BigDecimal("100")));
        vo.setProductionPlanRecord(BeanMapper.mapList((Iterable)planEntities, ProductionPlanVO.class));
        return vo;
    }

    @Override
    public List<ProductionPlanVO> queryTotalPlanMny(List<Long> orgIds, Integer yearFlag) {
        return this.planMapper.queryTotalPlanMny(orgIds, yearFlag);
    }
}

