package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 甲方报量
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_quote")
public class QuoteEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 报量时间
     */
    @TableField("quote_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quoteDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 本期结算金额（含税）
     */
    @TableField("quote_tax_mny")
    private BigDecimal quoteTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本期结算金额（不含税）
     */
    @TableField("quote_mny")
    private BigDecimal quoteMny;

    /**
     * 截至上期累计结算金额（不含税）
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 截至上期累计结算金额（含税）
     */
    @TableField("sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同金额(含税)
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;
    /**
     * 截至上期累计结算比例
     */
    @TableField("sum_quote_rate")
    private BigDecimal sumQuoteRate;

    /**
     * 累计结算金额（不含税）
     */
    @TableField("total_quote_mny")
    private BigDecimal totalQuoteMny;

    /**
     * 累计结算金额（含税）
     */
    @TableField("total_quote_tax_mny")
    private BigDecimal totalQuoteTaxMny;

    /**
     * 累计结算比例
     */
    @TableField("total_quote_rate")
    private BigDecimal totalQuoteRate;

    /**
     * 累计完成产值（含税）
     */
    @TableField("total_finish_tax_mny")
    private BigDecimal totalFinishTaxMny;

    /**
     * 累计完成产值（不含税）
     */
    @TableField("total_finish_mny")
    private BigDecimal totalFinishMny;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 来源ID
     */
    @TableField("source_id")
    private String sourceId;

    /**
     * 部门ID
     */
    @TableField("dept_id")
    private Long deptId;
    /**
     * 部门名称
     */
    @TableField("dept_name")
    private String deptName;

    /**
     * 批量类型
     */
    @TableField("quote_type")
    private String quoteType;

    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteDetailService", pidName = "quoteId")
    private List<QuoteDetailEntity> checkList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteClaimService", pidName = "quoteId")
    private List<QuoteClaimEntity> claimList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteOtherService", pidName = "quoteId")
    private List<QuoteOtherEntity> otherList = new ArrayList<>();


    public BigDecimal getSumQuoteRate() {
        return sumQuoteRate;
    }

    public void setSumQuoteRate(BigDecimal sumQuoteRate) {
        this.sumQuoteRate = sumQuoteRate;
    }

    public List<QuoteDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<QuoteDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public List<QuoteClaimEntity> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<QuoteClaimEntity> claimList) {
        this.claimList = claimList;
    }

    public List<QuoteOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<QuoteOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getQuoteDate() {
        return quoteDate;
    }

    public void setQuoteDate(Date quoteDate) {
        this.quoteDate = quoteDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getTotalQuoteMny() {
        return totalQuoteMny;
    }

    public void setTotalQuoteMny(BigDecimal totalQuoteMny) {
        this.totalQuoteMny = totalQuoteMny;
    }

    public BigDecimal getTotalQuoteTaxMny() {
        return totalQuoteTaxMny;
    }

    public void setTotalQuoteTaxMny(BigDecimal totalQuoteTaxMny) {
        this.totalQuoteTaxMny = totalQuoteTaxMny;
    }

    public BigDecimal getTotalQuoteRate() {
        return totalQuoteRate;
    }

    public void setTotalQuoteRate(BigDecimal totalQuoteRate) {
        this.totalQuoteRate = totalQuoteRate;
    }

    public BigDecimal getTotalFinishTaxMny() {
        return totalFinishTaxMny;
    }

    public void setTotalFinishTaxMny(BigDecimal totalFinishTaxMny) {
        this.totalFinishTaxMny = totalFinishTaxMny;
    }

    public BigDecimal getTotalFinishMny() {
        return totalFinishMny;
    }

    public void setTotalFinishMny(BigDecimal totalFinishMny) {
        this.totalFinishMny = totalFinishMny;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(String quoteType) {
        this.quoteType = quoteType;
    }
}
