package com.ejianc.business.income.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 补充协议清单
 *
 * @author generator
 *
 */
 @TableName("ejc_income_contract_detail")
public class SupplementDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="contract_id")
    private Long contractId; // 施工合同主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="code")
    private String code; // 清单编号
    @TableField(value="parent_id")
    private Long parentId; // parent_id
    @TableField(value="name")
    private String name; // 清单名称
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private java.math.BigDecimal num; // 工程量
    @TableField(value="price")
    private java.math.BigDecimal price; // 综合单价（无税）
    @TableField(value="mny")
    private java.math.BigDecimal mny; // 合价（无税）
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="leaf_flag")
    private Boolean leafFlag; // 是否末级
    @TableField(value="change_type")
    private Integer changeType; // 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_bid")
    private Long changeBid; // 变更子表主键
    @TableField(value="src_supplement_flag")
    private Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private Long srcSupplementDetailId; // 来源补充协议明细ID
    /**
     * 税率
     */
    @TableField("detail_tax_rate")
    private BigDecimal detailTaxRate;

    /**
     * 综合单价
     */
    @TableField("detail_tax_price")
    private BigDecimal detailTaxPrice;

    /**
     * 合价
     */
    @TableField("detail_tax_mny")
    private BigDecimal detailTaxMny;
    /**
     * 税额
     */
    @TableField("detail_tax")
    private BigDecimal detailTax;


    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }

    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    /**
     * 施工合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 施工合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * 清单编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 清单编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 清单名称
     */
    public String getName() {
        return name;
    }

    /**
     * 清单名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 工程量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 工程量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 综合单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 综合单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 合价
     */
    public java.math.BigDecimal getMny() {
        return mny;
    }

    /**
     * 合价
     */
    public void setMny(java.math.BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型,1-变更量，2-变更价，3-增补项，4-变更量价，5-中止，6-其他
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }
    /**
     * 来源补充协议主表ID
     */
    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    /**
     * 来源补充协议主表ID
     */
    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }
    /**
     * 来源补充协议明细ID
     */
    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    /**
     * 来源补充协议明细ID
     */
    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }

}
