package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ProductionDetailEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IProductionDetailService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.vo.ContractDetailExportVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 产值进度 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/production")
public class ProductionController {
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private IContractDetailService contractDetailService;
    /**
     * 新增或编辑
     * @param productionVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionVo> saveOrUpdate(@RequestBody ProductionVo productionVo) {
        CommonResponse<ProductionVo> response = productionService.saveOrUpdate(productionVo);
        return response;
    }
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVo>  queryDetail(@RequestParam Long id) {
        ProductionVo vo= productionService.queryDetail(id);
        List<ProductionDetailVo> list=vo.getCheckList();
        for (ProductionDetailVo productionDetailVo : list) {
    		if(productionDetailVo.getContractDetailId() != null) {
        		QueryWrapper<ProductionDetailEntity> detailWrapper = new QueryWrapper<>();
            	detailWrapper.eq("contract_detail_id", productionDetailVo.getContractDetailId());
            	detailWrapper.eq("dr",0);
            	List<ProductionDetailEntity> entityList = productionDetailService.list(detailWrapper);
            	if(entityList.size()>0) {
            		BigDecimal productionNum = BigDecimal.ZERO;
            		BigDecimal productionMny = BigDecimal.ZERO;
            		for(ProductionDetailEntity ent :entityList) {
            			if(ent.getFinishNum() != null ) productionNum =  productionNum.add(ent.getFinishNum());
            			if(ent.getFinishMny() != null)  productionMny = productionMny.add(ent.getFinishMny());
            		} 
//            		BigDecimal productionNum=entityList.stream().map(ProductionDetailEntity::getFinishNum).reduce(BigDecimal.ZERO, BigDecimal::add);
//            		BigDecimal productionMny=entityList.stream().map(ProductionDetailEntity::getFinishMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            		productionDetailVo.setProductionMny(productionMny);
            		productionDetailVo.setProductionNum(productionNum);
            	}
    		}
		}
        vo.setCheckList(list);
        return CommonResponse.success(vo);
    }
    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        return CommonResponse.success("查询列表数据成功！",productionService.queryPage(param,false));
    }
    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVo> vos) {
        productionService.deleteProduction(vos);
        return CommonResponse.success("删除成功");
    }
    /**
     * 产值进度历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryProductionHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionHistoryVo> queryProductionHistory(@RequestParam Long id) {
        ProductionHistoryVo vo = productionService.queryProductionHistory(id);
        return CommonResponse.success(vo);
    }
    /**
     * 查询产值进度参照分页列表
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pageRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionEntity>> pageRef(@RequestParam(value = "contractId") String contractId,
                                                          @RequestParam(value = "searchText", required = false) String searchText,
                                                          @RequestParam(value = "productionDate", required = false) String productionDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,contractId));
        queryParam.getParams().put("quoteFlag",new Parameter(QueryParam.EQ,0));
        if(null!=productionDate && productionDate.length()>0){
            queryParam.getParams().put("productionDate",new Parameter(QueryParam.LE,productionDate));
        }
        List<Integer> billStatus=new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        queryParam.getOrderMap().put("productionDate","desc");
        queryParam.getOrderMap().put("createTime","desc");
        return CommonResponse.success("查询产值进度参照成功！",productionService.queryList(queryParam,false));
    }

    /**
     * 产值进度明细参照
     * @param productionId
     * @return
     */
    @RequestMapping(value = "/detailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionDetailVo>> detailRef(@RequestParam Long productionId) {
        return CommonResponse.success("查询产值进度明细成功！",productionService.detailRef(productionId));
    }
    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<ProductionEntity> pageData = productionService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<ProductionVo> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ProductionVo.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("production-export.xlsx", beans, response);
    }

    /**
     * 导出明细
     *
     * @param param
     * @return
     */
    @PostMapping("detailExcelExport")
    public void detailExcelExport(@RequestBody ProductionDetailVo vo, HttpServletResponse response) {
    	Long parentId=vo.getParentId();
    	QueryWrapper<ProductionDetailEntity> queryWrapper=new QueryWrapper<>();
    	queryWrapper.eq("dr", 0);
    	queryWrapper.eq("production_id", parentId);
    	queryWrapper.orderByAsc("create_time");
    	List<ProductionDetailEntity> list =productionDetailService.list(queryWrapper);
    	List<ProductionDetailVo> voList = BeanMapper.mapList(list, ProductionDetailVo.class);
    	for (ProductionDetailVo productionDetailVo : voList) {
    		if(productionDetailVo.getSourceType()==1) {
    			productionDetailVo.setSourceTypeName("合同内");
    		}else {
    			productionDetailVo.setSourceTypeName("合同外");
    		}
    		if(productionDetailVo.getContractDetailId() != null) {
        		QueryWrapper<ProductionDetailEntity> detailWrapper = new QueryWrapper<>();
            	detailWrapper.eq("contract_detail_id", productionDetailVo.getContractDetailId());
            	detailWrapper.eq("dr",0);
            	List<ProductionDetailEntity> entityList = productionDetailService.list(detailWrapper);
            	if(entityList.size()>0) {
            		BigDecimal productionNum=entityList.stream().map(ProductionDetailEntity::getFinishNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            		BigDecimal productionMny=entityList.stream().map(ProductionDetailEntity::getFinishMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            		productionDetailVo.setProductionMny(productionMny);
            		productionDetailVo.setProductionNum(productionNum);
            	}
    		}
		}
    	Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("productionDetail-export.xlsx", beans, response);
    }
    /**
     * 查询默认统计日期
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryDefaultDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionVo> queryDefaultDate(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        //已生效状态的单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 已生效
        queryParam.getOrderMap().put("productionDate", QueryParam.DESC);
        List<ProductionEntity> list = productionService.queryList(queryParam,false);
        Date nextMonth = CollectionUtils.isNotEmpty(list) ? DateUtil.nextMonth(list.get(0).getProductionDate()) : new Date();
        ProductionVo vo = new ProductionVo();
        vo.setProductionDate(nextMonth);
        return CommonResponse.success("查询数据成功！", vo);
    }

    /**
     * 根据合同主键，统计日期获取本年完工产值
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getYearFinishMny")
    @ResponseBody
    public CommonResponse<ProductionVo> getYearFinishMny(@RequestParam(value = "contractId") Long contractId,
            @RequestParam(value = "productionDate") Date productionDate) {
    	Date firstDate=productionService.getFirstDateByContract(contractId);
        LambdaQueryWrapper<ProductionEntity> lambda = new LambdaQueryWrapper();
        lambda.eq(ProductionEntity::getContractId, contractId);
        lambda.in(ProductionEntity::getBillState, Arrays.asList("1","3"));
        lambda.last("and date_format(production_date,'%Y')='" + DateUtil.getYear(productionDate)+ "'");
        List<ProductionEntity> list = productionService.list(lambda);
        ProductionVo vo = new ProductionVo();
        if(CollectionUtils.isNotEmpty(list)){
            BigDecimal yearFinishTaxMny = null;
            BigDecimal yearFinishMny = null;
            for(ProductionEntity entity : list){
                yearFinishTaxMny = ComputeUtil.safeAdd(yearFinishTaxMny, entity.getFinishTaxMny());
                yearFinishMny = ComputeUtil.safeAdd(yearFinishMny, entity.getFinishMny());
            }
            vo.setYearFinishTaxMny(yearFinishTaxMny);
            vo.setYearFinishMny(yearFinishMny);
            vo.setFirstDate(firstDate);
        }
        return CommonResponse.success("查询数据成功！", vo);
    }

    /**
     * 根据合同主键，查询是否有非生效单据、所有月份及最大月份
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getValidate")
    @ResponseBody
    public CommonResponse<JSONObject> getValidate(@RequestParam(value = "id", required = false) Long id, @RequestParam(value = "contractId") Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getOrderMap().put("productionDate", QueryParam.DESC);
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));//  编辑过滤自身
        }
        // 所有月份
        List<ProductionEntity> list = productionService.queryList(queryParam);
        List<String> allMonth = list.stream().map(x->DateUtil.getYearAndMonth(x.getProductionDate())).distinct().collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("allMonth", allMonth);
        // 最大月份
        json.put("maxDate", CollectionUtils.isNotEmpty(list) ? DateUtil.getYearAndMonth(list.get(0).getProductionDate()) : null);

        // 是否有非生效单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));// 非生效态
        List<ProductionEntity> list2 = productionService.queryList(queryParam);
        json.put("unEffective", CollectionUtils.isNotEmpty(list2) ? true : false);

        return CommonResponse.success("查询数据成功！", json);
    }
    
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadContractDetail", method = RequestMethod.POST)
    @ResponseBody
    public void downloadNew(@RequestBody ContractDetailVo vomc, HttpServletResponse response) {
    	QueryParam queryParam = new QueryParam();
    	queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vomc.getContractId()));
    	queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);

        List<ContractDetailEntity> listsub = contractDetailService.queryList(queryParam);
        /** 数据隔离 本下 */
        List<ContractDetailExportVo> exportVOS = new ArrayList<>();
        listsub.forEach(vo -> {
        	ContractDetailExportVo exportVO = BeanMapper.map(vo, ContractDetailExportVo.class);
        	exportVO.setSourceType("合同内");
            exportVOS.add(exportVO);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "production-import.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }
    
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(String contractId,String projectId,String orgId,HttpServletRequest request, HttpServletResponse response) {
    	MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ProductionDetailVo> successList = new ArrayList<>();
            List<ProductionDetailVo> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 12) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for(int i = 0; i < result.size();i++) {

                    List<String> datas = result.get(i);
                    ProductionDetailVo productionDetailVO = new ProductionDetailVo();
                    String index = String.valueOf((i+1));
                    productionDetailVO.setDetailIndex(index);
//                    if (StringUtils.isBlank(datas.get(0))) {
//                        productionDetailVO.setErrorMessage("物资分类为必填项");
//                    } else if (datas.get(0).length() > 20) {
//                        productionDetailVO.setErrorMessage("物资分类填写长度为0~20字");
//                    } else {
//                        productionDetailVO.setMaterialCategoryName(datas.get(0));
//                    }
                    if (StringUtils.isBlank(datas.get(0))) {
                    	productionDetailVO.setErrorMessage("清单编码为必填项");
                    } else {
                    	productionDetailVO.setCode(datas.get(0));
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                    	productionDetailVO.setErrorMessage("清单名称为必填项");
                    }  else {
                    	productionDetailVO.setName(datas.get(1));
                    }
                    
                    if(StringUtils.isNotBlank(datas.get(2))) {
                    	productionDetailVO.setUnit(datas.get(2));
                    }
                    
                    if (StringUtils.isBlank(datas.get(3))) {
                    	productionDetailVO.setErrorMessage("税率为必填项");
                    } else if (datas.get(3).contains("%")) {
                    	productionDetailVO.setErrorMessage("税率字段无需添加%号，请重新输入税率！");
                    } else {
                    	try {
                    		productionDetailVO.setDetailTaxRate(new BigDecimal(datas.get(3)));
                    	}catch(Exception e) {
                    		productionDetailVO.setErrorMessage("税率必须为数字");
                    	}
                    }

                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                        	productionDetailVO.setPrice(new BigDecimal(datas.get(4)));
//                            if (productionDetailVO.getTaxPrice().doubleValue() < 0) {
////                                productionDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("综合单价（无税）必须为数字");
                        }
                    } else {
                    	productionDetailVO.setPrice(new BigDecimal(0));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                        	productionDetailVO.setDetailTaxPrice(new BigDecimal(datas.get(5)));
//                            if (productionDetailVO.getPrice().doubleValue() < 0) {
////                                productionDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("综合单价必须为数字");
                        }
                    } else {
                    	productionDetailVO.setDetailTaxPrice(new BigDecimal(0));
                    }
                    

                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                        	productionDetailVO.setFinishNum(new BigDecimal(datas.get(6)));
                            if (productionDetailVO.getFinishNum().longValue() < 0) {
                            	productionDetailVO.setErrorMessage("本期结算量必须大于0");
                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("本期结算量必须为数字");
                        }
                    } else {
                    	productionDetailVO.setErrorMessage("本期结算量为必填项");
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                        	productionDetailVO.setFinishMny(new BigDecimal(datas.get(7)));
//                            if (productionDetailVO.getSettleMny().doubleValue() < 0) {
////                                productionDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("本期完成产值（无税）必须为数字");
                        }
                    } else {
                    	productionDetailVO.setFinishMny(productionDetailVO.getFinishNum().multiply(productionDetailVO.getPrice()));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                        	productionDetailVO.setDetailFinishTaxMny(new BigDecimal(datas.get(8)));
//                            if (productionDetailVO.getSettleMny().doubleValue() < 0) {
////                                productionDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("本期完成产值必须为数字");
                        }
                    } else {
                    	productionDetailVO.setDetailFinishTaxMny(productionDetailVO.getFinishNum().multiply(productionDetailVO.getDetailTaxPrice()));
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                        	productionDetailVO.setDetailTax(new BigDecimal(datas.get(9)));
//                            if (productionDetailVO.getSettleMny().doubleValue() < 0) {
////                                productionDetailVO.setErrorMessage("单价必须大于0");
//                            }
                        } catch (Exception e) {
                        	productionDetailVO.setErrorMessage("税额必须为数字");
                        }
                    } else {
                    	productionDetailVO.setDetailTax(productionDetailVO.getDetailFinishTaxMny().subtract(productionDetailVO.getFinishMny()));
                    }
                    
                    if (StringUtils.isBlank(datas.get(10))) {
                    	productionDetailVO.setErrorMessage("来源类型为必填项");
                    } else if(datas.get(10).equals("合同内")){
                    	productionDetailVO.setSourceType(1);
                    } else if(datas.get(10).equals("合同外")){
                    	productionDetailVO.setSourceType(2);
                    } else {
                    	productionDetailVO.setErrorMessage("请输入正确的来源类型数据（合同内/合同外）");
                    }
                    
                    if (StringUtils.isNotBlank(datas.get(11))) {
                    	productionDetailVO.setMemo(datas.get(11));
                    }
                    
                    QueryParam queryParamconlist = new QueryParam();
                    queryParamconlist.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
                    queryParamconlist.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
                    queryParamconlist.setPageIndex(0);
                    queryParamconlist.setPageSize(100000);

                    List<ContractDetailEntity> contractDetail = contractDetailService.queryList(queryParamconlist);
                    
                    for(ContractDetailEntity con:contractDetail) {
                    	DecimalFormat numtype = new DecimalFormat("#0.00");
                    	String findrate = numtype.format(con.getDetailTaxRate());
                    	String importrate = numtype.format(productionDetailVO.getDetailTaxRate());
                    	String findprice = numtype.format(con.getPrice());
                    	String importprice = numtype.format(productionDetailVO.getPrice());
                    	
                    	if(con.getCode().equals(productionDetailVO.getCode()) && con.getName().equals(productionDetailVO.getName()) &&
                    			findrate.equals(importrate) && findprice.equals(importprice)) {
                    		if(productionDetailVO.getSourceType().equals(1)) {
                            	productionDetailVO.setContractDetailId(con.getId());//合同明细id
                            }
                    		
                    		//----------------------
                    		QueryWrapper<ProductionDetailEntity> detailWrapper = new QueryWrapper<>();
                        	detailWrapper.eq("contract_detail_id",productionDetailVO.getContractDetailId());
                        	detailWrapper.eq("dr",0);
                        	List<ProductionDetailEntity> entityList = productionDetailService.list(detailWrapper);
                        	if(entityList.size()>0) {
                        		BigDecimal productionNum = BigDecimal.ZERO;
                        		BigDecimal productionMny = BigDecimal.ZERO;
                        		for(ProductionDetailEntity ent :entityList) {
                        			if(ent.getFinishNum() != null ) productionNum =  productionNum.add(ent.getFinishNum());
                        			if(ent.getFinishMny() != null)  productionMny = productionMny.add(ent.getFinishMny());
                        		} 
                        		productionDetailVO.setProductionMny(productionMny);//累计完成量
                        		productionDetailVO.setProductionNum(productionNum);//累计产值
                        	}else {
                        		productionDetailVO.setProductionMny(new BigDecimal("0"));//累计完成量
                        		productionDetailVO.setProductionNum(new BigDecimal("0"));//累计产值
                        	}
                            
                            productionDetailVO.setNum(con.getNum());//工程量
                            productionDetailVO.setParentId(con.getParentId());//父id
                            productionDetailVO.setLeafFlag(con.getLeafFlag());//是否末级
//                            productionDetailVO.setOrgAccountingId();//集团核算对象主键
                    	}
                    }
                    if(productionDetailVO.getErrorMessage() != null && productionDetailVO.getErrorMessage().length()>1) {
                    	errorList.add(productionDetailVO);
                    }else {
                    	successList.add(productionDetailVO);
                    }
                }
            }
            new TaxCalculateUtil<ProductionDetailVo>().calculate(successList);
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    
    }
}
