package com.ejianc.business.income.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.history.ProductionPlanHistoryVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.income.bean.ProductionPlanEntity;
import com.ejianc.business.income.service.IProductionPlanService;
import com.ejianc.business.income.vo.ProductionPlanVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 产值计划
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("productionPlan")
public class ProductionPlanController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;


    @Autowired
    private IProductionPlanService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionPlanVO> saveOrUpdate(@RequestBody ProductionPlanVO saveorUpdateVO) {

    	return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionPlanVO> queryDetail(Long id) {
    	ProductionPlanEntity entity = service.selectById(id);
    	ProductionPlanVO vo = BeanMapper.map(entity, ProductionPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionPlanVO> vos) {
        service.removeByIds(vos.stream().map(ProductionPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductionPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 本下 */
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ProductionPlanEntity> page = service.queryPage(param,false);
        IPage<ProductionPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductionPlanVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 根据合同主键获取计划月份
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getPlanMonth")
    @ResponseBody
    public CommonResponse<ProductionPlanVO> getPlanMonth(Long contractId) {
        return service.getPlanMonth(contractId);
    }

    /**
     * 根据合同主键，计划月份获取本年计划产值
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getYearPlanTaxMny")
    @ResponseBody
    public CommonResponse<ProductionPlanVO> getYearPlanTaxMny(@RequestParam(value = "contractId") Long contractId
            , @RequestParam(value = "planMonth") Date planMonth) {
        return service.getYearPlanTaxMny(contractId, planMonth);
    }

    /**
     * 产值计划历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryProductionPlanHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionPlanHistoryVo> queryProductionPlanHistory(@RequestParam Long id) {
        ProductionPlanHistoryVo vo = service.queryProductionPlanHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 导出
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        param.setPageIndex(1);
        param.setPageSize(-1);

        IPage<ProductionPlanEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<>();
        List<ProductionPlanVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ProductionPlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("productionPlan-export.xlsx", beans, response);
    }

    /**
     * 根据合同主键，查询是否有非生效单据、所有月份及最大月份
     * @param id
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/getValidate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getValidate(@RequestParam(value = "id", required = false) Long id
            , @RequestParam(value = "contractId") Long contractId) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getOrderMap().put("planMonth", QueryParam.DESC);
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id)); // 编辑过滤自身
        }

        // 所有月份
        List<ProductionPlanEntity> list = service.queryList(queryParam);
        List<String> allMonth = list.stream().map(ProductionPlanEntity::getPlanMonth).collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("allMonth", allMonth);

        // 最大月份
        json.put("maxDate", CollectionUtils.isNotEmpty(list) ?list.get(0).getPlanMonth() : null);

        // 是否有非生效单据
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));// 非生效态
        List<ProductionPlanEntity> entities = service.queryList(queryParam, false);
        json.put("unEffective", CollectionUtils.isNotEmpty(entities) ? true : false);

        return CommonResponse.success("查询数据成功！", json);
    }

}
