package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.vo.report.ProductionCountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

@RestController
@RequestMapping("/report")
public class ReportController {
    @Autowired
    private IReportService reportService;

    /**
     * 项目回款台账
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> projectPageList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.pageList(param));
    }

    /**
     * 月度经营报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/monthPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> monthPageList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！",reportService.monthPageList(param) );
    }

    /**
     * 项目回款台账导出
     *
     * @param param
     * @return
     */
    @PostMapping("projectExport")
    public void projectExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = reportService.pageList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get("records"));
        ExcelExport.getInstance().export("projectReport-export.xlsx", beans, response);
    }

    /**
     * 月度经营报表导出
     *
     * @param param
     * @return
     */
    @PostMapping("monthExport")
    public void monthExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        JSONObject pageList = reportService.monthPageList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get("records"));
        ExcelExport.getInstance().export("monthReport-export.xlsx", beans, response);
    }
    /**
     * 产值统计报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/productionCountList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> productionCountList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.productionCountList(param));
    }
    
    /**
     * 施工生产产值统计报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectProductionCountList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> projectProductionCountList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectProductionCountList(param));
    }

    /**
     * 产值统计报表导出
     * @param param
     * @param response
     */
    @PostMapping("productionCountExport")
    public void productionCountExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(999999);
        JSONObject pageList = reportService.productionCountList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<ProductionCountVO> list = new ArrayList<>();
        if (null != pageList.get("records") && CollectionUtils.isNotEmpty((List)pageList.get("records"))) {
            list = BeanMapper.mapList((List)pageList.get("records"), ProductionCountVO.class);
            list.forEach(vo -> {
                if (null != vo.getType()) {
                    if (vo.getType().equals("1")) {
                        vo.setTypeName("自营");
                    } else if (vo.getType().equals("2")) {
                        vo.setTypeName("联营");
                    }
                } else {
                    vo.setTypeName("");
                }
                if (null != vo.getStatus()) {
                    if (vo.getStatus().equals("1")) {
                        vo.setStatusName("未开工");
                    } else if (vo.getStatus().equals("2")) {
                        vo.setStatusName("在建");
                    } else if (vo.getStatus().equals("3")) {
                        vo.setStatusName("完成");
                    }
                } else {
                    vo.setStatusName("");
                }
                if (null != vo.getEvaluateState()) {
                    if (vo.getEvaluateState().equals("1")) {
                        vo.setEvaluateStateName("良好");
                    } else if (vo.getEvaluateState().equals("2")) {
                        vo.setEvaluateStateName("正常");
                    } else if (vo.getEvaluateState().equals("3")) {
                        vo.setEvaluateStateName("滞后");
                    } else if (vo.getEvaluateState().equals("4")) {
                        vo.setEvaluateStateName("完工");
                    }
                } else {
                    vo.setEvaluateStateName("");
                }
                if (null != vo.getSatisfyFlag()) {
                    if (vo.getSatisfyFlag().equals("0")) {
                        vo.setSatisfyFlagName("否");
                    } else if (vo.getSatisfyFlag().equals("1")) {
                        vo.setSatisfyFlagName("是");
                    }
                } else {
                    vo.setSatisfyFlagName("");
                }
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("countReport-export.xlsx", beans, response);
    }
}
