package com.ejianc.business.income.mapper;

import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.ProjectCountVO;
import com.ejianc.business.income.vo.ProjectInOutVO;
import com.ejianc.business.income.vo.SqlParam;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 施工合同表 Mapper 接口
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    @Select("SELECT sign_date from ejc_income_contract where id=#{id}")
    Date getSignDate(Long id);
    @Select("SELECT * from ejc_income_contract where dr = 0 and project_id = #{projectId} and bill_state in (1,3) ORDER BY create_time desc LIMIT 0,1")
    ContractVo searchContract(Long projectId);

    BigDecimal inContractMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalReceiveMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal outContractMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalSettleMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalOutMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);
    
    BigDecimal totalLoadApplyMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);
    
    BigDecimal totalLoadBackMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);
    
    List<Map> getproject(@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    Map getProjectDetail(@Param("projectId")Long projectId);

    BigDecimal outputMoney(@Param("projectId")Long projectId);

    BigDecimal contractMoney(@Param("projectId")Long projectId);

    List<Map> costCount(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<ProjectCountVO> projectCount(@Param("range")String range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId);

    BigDecimal allInMoney(@Param("ids")List<Long> ids);

    BigDecimal allOutMoney(@Param("ids")List<Long> ids);

    Long count(Map<String,Object> params);

    List<ProjectInOutVO> getList(Map<String,Object> params);

    Map getProjectDate(@Param("projectId")Long projectId);

    List<Map<String,Object>> incomeMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<IncomeContractWarnVo> outIncomeMnyWarn(@Param(value = "tenantIds") List<Long> tenantIds);

    List<Map<String,BigDecimal>> totalQuoteMoney(@Param("range")Integer range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId);

    BigDecimal totalProductionMoney(@Param("range")Integer range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId);
    
    BigDecimal totalCostMoney(@Param("range")Integer range, @Param("year")String year, @Param("projectIds")List<Long> projectIds, @Param("tenantId")Long tenantId);
    
    BigDecimal bidProfitRate(@Param("range")Integer range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId);

    BigDecimal bidProfitRateByProject(@Param("range")Integer range, @Param("year")String year, @Param("orgId") Long orgId, @Param("tenantId")Long tenantId);

    List<Map<String,BigDecimal>> planRate(@Param("range")Integer range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId") Long tenantId, @Param("projectId") Long projectId);

    
    
}
