package com.ejianc.business.income.plan.bean;

import java.util.Date;
import java.math.*;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 年度计划详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_year_plan_detail")
public class YearPlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="year_plan_id")
    private Long yearPlanId; // 父id
    @TableField(value="schedule_month")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date scheduleMonth; // 时间
    @TableField(value="production_tax_mny")
    private BigDecimal productionTaxMny; // 本月计划产值
    @TableField(value="production_mny")
    private BigDecimal productionMny; // 本月计划产值(无税)
    @TableField(value="detail_memo")
    private String detailMemo; // 备注
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率


    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public Long getYearPlanId() {
        return yearPlanId;
    }

    public void setYearPlanId(Long yearPlanId) {
        this.yearPlanId = yearPlanId;
    }
    public Date getScheduleMonth() {
        return scheduleMonth;
    }

    public void setScheduleMonth(Date scheduleMonth) {
        this.scheduleMonth = scheduleMonth;
    }
    public BigDecimal getProductionTaxMny() {
        return productionTaxMny;
    }

    public void setProductionTaxMny(BigDecimal productionTaxMny) {
        this.productionTaxMny = productionTaxMny;
    }
    public BigDecimal getProductionMny() {
        return productionMny;
    }

    public void setProductionMny(BigDecimal productionMny) {
        this.productionMny = productionMny;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
