package com.ejianc.business.income.plan.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.paln.vo.YearPlanVO;
import com.ejianc.business.income.plan.bean.YearPlanEntity;
import com.ejianc.business.income.plan.service.IYearPlanService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 年度计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("yearPlan")
public class YearPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "YEAR_PLAN";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IYearPlanService service;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YearPlanVO> saveOrUpdate(@RequestBody YearPlanVO saveOrUpdateVO) {
    	YearPlanEntity entity = BeanMapper.map(saveOrUpdateVO, YearPlanEntity.class);
        QueryWrapper<YearPlanEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("project_id",entity.getProjectId());
        String strDateFormat = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        listQuery.eq("plan_date",sdf.format(entity.getPlanDate()));
        listQuery.eq("dr",0);
        if(entity.getId() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else {
            listQuery.notLike("id",entity.getId());
        }
        int resultCount = service.count(listQuery);
        if (resultCount > 0) {
            throw new BusinessException("该项目已存在本年度的产值计划，不能重复新增");
        }
    	service.saveOrUpdate(entity, false);
    	YearPlanVO vo = BeanMapper.map(entity, YearPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearPlanVO> queryDetail(Long id) {
    	YearPlanEntity entity = service.selectById(id);
    	YearPlanVO vo = BeanMapper.map(entity, YearPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (YearPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(YearPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YearPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        IPage<YearPlanEntity> page = service.queryPage(param, false);
        page.getRecords().forEach(e->{
        	e.setYearProductionMny(e.getYearProductionMny().divide(new BigDecimal(10000)));
        	e.setYearProductionTaxMny(e.getYearProductionTaxMny().divide(new BigDecimal(10000)));
        });
        IPage<YearPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), YearPlanVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<YearPlanVO>> iPageCommonResponse = queryList(param);
        List<YearPlanVO> list = new ArrayList<>();
        if (null != iPageCommonResponse.getData()) {
            list = iPageCommonResponse.getData().getRecords();

            if (CollectionUtils.isNotEmpty(list)){
                for (YearPlanVO vo : list) {
                    vo.setBillStateStr(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                    vo.setPlanDateStr(sdf.format(vo.getPlanDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("YearPlan-export.xlsx", beans, response);
    }

}
