/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ClaimDetailEntity;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.history.ClaimHistoryVo;
import com.ejianc.business.income.mapper.ClaimMapper;
import com.ejianc.business.income.service.IClaimDetailService;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ClaimDetailVo;
import com.ejianc.business.income.vo.ClaimVo;
import com.ejianc.business.income.vo.comparator.ClaimDetailComparatorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="ClaimService")
public class ClaimServiceImpl
extends BaseServiceImpl<ClaimMapper, ClaimEntity>
implements IClaimService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CLAIM_BILL_CODE = "INCOME_CLAIM";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IClaimDetailService claimDetailService;
    @Autowired
    private ClaimMapper claimMapper;
    @Autowired
    private IClaimDetailService detailsService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<ClaimVo> saveOrUpdate(ClaimVo claimVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Date signDate;
        ContractEntity contractEntity;
        block26: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(claimVo.getContractId()));
            if (claimVo.getContractVersion() != null && claimVo.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(claimVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = claimVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block26;
                    }
                    CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return version;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(claimVo.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        if (null != (signDate = contractEntity.getSignDate()) && claimVo.getOccurDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u53d1\u751f\u65f6\u95f4\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ClaimEntity entity = null;
        String operateType = null;
        if (claimVo.getId() != null && claimVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)claimVo.getBillCode())) {
                claimVo.setBillCode(null);
            }
            entity = (ClaimEntity)((Object)BeanMapper.map((Object)claimVo, ClaimEntity.class));
            operateType = "edit";
        } else {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CLAIM_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            claimVo.setBillCode((String)billCode.getData());
            entity = (ClaimEntity)((Object)BeanMapper.map((Object)claimVo, ClaimEntity.class));
            operateType = "add";
        }
        if (claimVo.getId() != null && claimVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ClaimEntity::getBillCode, (Object)claimVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)claimVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ClaimEntity::getBillCode, (Object)claimVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity);
        List detailsVos = claimVo.getCheckList();
        ArrayList<ClaimDetailEntity> saveOrUpldates = new ArrayList<ClaimDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (ClaimDetailVo detailsVo : detailsVos) {
            ClaimDetailEntity detailslist;
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (ClaimDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ClaimDetailEntity.class));
                detailslist.setClaimId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (ClaimDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ClaimDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.claimDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ClaimDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ClaimDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.claimDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.claimDetailService.removeByIds(deleteIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ClaimVo queryDetail(Long id) {
        ClaimEntity entity = (ClaimEntity)((Object)this.claimMapper.selectById(id));
        if (entity != null) {
            ClaimVo vo = (ClaimVo)BeanMapper.map((Object)((Object)entity), ClaimVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("claimId", new Parameter("eq", (Object)vo.getId()));
            List details = this.detailsService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ClaimDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, ClaimDetailVo.class);
                Collections.sort(resultMapList, new ClaimDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            return vo;
        }
        return null;
    }

    @Override
    public void deleteClaim(List<ClaimVo> vos) {
        for (ClaimVo vo : vos) {
            this.detailsService.deleteByClaimId(vo.getId());
            this.claimMapper.deleteById(vo.getId());
        }
    }

    @Override
    public ClaimHistoryVo queryClaimHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List claimEntities = this.claimMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"occur_date", "create_time"}));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ClaimHistoryVo vo = new ClaimHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        if (null != claimEntities && claimEntities.size() > 0) {
            List claimVos = BeanMapper.mapList((Iterable)claimEntities, ClaimVo.class);
            BigDecimal sumVisaMny = BigDecimal.ZERO;
            BigDecimal sumChangeMny = BigDecimal.ZERO;
            BigDecimal sumClaimMny = BigDecimal.ZERO;
            BigDecimal sumSecondManage = BigDecimal.ZERO;
            for (ClaimVo cv : claimVos) {
                BigDecimal replyMny;
                Integer changeType = cv.getChangeType();
                BigDecimal bigDecimal = replyMny = cv.getReplyMny() == null ? BigDecimal.ZERO : cv.getReplyMny();
                if (1 == changeType) {
                    sumVisaMny = sumVisaMny.add(replyMny);
                }
                if (2 == changeType) {
                    sumChangeMny = sumChangeMny.add(replyMny);
                }
                if (3 != changeType) continue;
                sumClaimMny = sumClaimMny.add(replyMny);
            }
            sumSecondManage = sumVisaMny.add(sumChangeMny).add(sumClaimMny);
            vo.setSumVisaMny(sumVisaMny);
            vo.setSumChangeMny(sumChangeMny);
            vo.setSumClaimMny(sumClaimMny);
            vo.setSumSecondManage(sumSecondManage);
            BigDecimal secondManageRate = sumSecondManage.divide(vo.getContractTaxMny(), 8, 4).multiply(new BigDecimal(100));
            vo.setSecondManageRate(secondManageRate);
            vo.setClaimRecord(claimVos);
        }
        return vo;
    }

    @Override
    public IPage selectPage(Page<ClaimEntity> page, QueryWrapper wrapper) {
        return ((ClaimMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)wrapper);
    }
}

