/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.income.bean.ContractClauseEntity;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.consts.EJCDateUtil;
import com.ejianc.business.income.consts.ProjectSurveyEnum;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.income.mapper.ContractMapper;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.business.income.mapper.QuoteMapper;
import com.ejianc.business.income.service.IContractClauseService;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.utils.AddressResolutionUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ContractClauseVo;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.ProjectCountVO;
import com.ejianc.business.income.vo.ProjectDataVO;
import com.ejianc.business.income.vo.ProjectInOutVO;
import com.ejianc.business.income.vo.ProjectVo;
import com.ejianc.business.income.vo.SqlParam;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.income.vo.report.FinanceUseResSubVO;
import com.ejianc.business.income.vo.report.FinanceUseResVO;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ContractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "INCOME_CONTRACT";
    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IContractDetailService detailsService;
    @Autowired
    private IContractClauseService clauseService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private QuoteMapper quoteMapper;
    @Autowired
    private IQuoteService quoteService;
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ProductionMapper productionMapper;

    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUse(String dateIn, List<Long> orgIds) {
        String startMonth = null;
        String endMonth = null;
        if ("thisYear".equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01";
            endMonth = EJCDateUtil.getYear() + "-12";
        } else if ("near3Year".equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-35);
            endMonth = EJCDateUtil.getMonth((int)0);
        } else if ("near3Mon".equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-2);
            endMonth = EJCDateUtil.getMonth((int)0);
        } else if ("near6Mon".equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-5);
            endMonth = EJCDateUtil.getMonth((int)0);
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01";
            endMonth = EJCDateUtil.getLastYear() + "-12";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<FinanceUseResSubVO> proRes = this.productionMapper.totalProductionMoney(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> openRes = this.contractMapper.totalOpenInvince(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> recRes = this.contractMapper.totalReceiveInvince(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> quoteRes = this.quoteMapper.totalFinQuoteMoney(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> recMoneyRes = this.contractMapper.totalFinReceiveMoney(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> payRes = this.contractMapper.totalFinOutMoney(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> payContractRes = this.contractMapper.totalPayContractFinOutMoney(startMonth, endMonth, orgIds, tenantId);
        List<FinanceUseResSubVO> settleRes = this.contractMapper.totalFinSettleMoney(startMonth, endMonth, orgIds, tenantId);
        Map<String, BigDecimal> prodMap = proRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> openInvoiceMap = openRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> recInvoiceMap = recRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> quoteMap = quoteRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> recMoneyMap = recMoneyRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> payMap = payRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> settleMap = settleRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        Map<String, BigDecimal> payContractMap = payContractRes.stream().collect(Collectors.toMap(FinanceUseResSubVO::getMon, FinanceUseResSubVO::getTotal));
        FinanceUseResVO resVO = new FinanceUseResVO();
        List monthData = EJCDateUtil.getMonthBetween((String)startMonth, (String)endMonth);
        HashMap<String, FinanceUseResSubVO> subVOMap = new HashMap<String, FinanceUseResSubVO>();
        List<String> keyList = Arrays.asList("production", "partAReport", "backMoney", "openInvince", "jiesuanjine", "receiveInvince", "payMoney", "yingshouweishou", "yingfuweifu", "zhangmianjine");
        for (String mon : monthData) {
            BigDecimal monVal = BigDecimal.ZERO;
            for (String key : keyList) {
                FinanceUseResSubVO subVO;
                if (key.equals(keyList.get(0))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)prodMap.get(mon));
                }
                if (key.equals(keyList.get(1))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)quoteMap.get(mon));
                }
                if (key.equals(keyList.get(2))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)recMoneyMap.get(mon));
                }
                if (key.equals(keyList.get(3))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)openInvoiceMap.get(mon));
                }
                if (key.equals(keyList.get(4))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)settleMap.get(mon));
                }
                if (key.equals(keyList.get(5))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)recInvoiceMap.get(mon));
                }
                if (key.equals(keyList.get(6))) {
                    monVal = ComputeUtil.nullToZero((BigDecimal)payMap.get(mon));
                }
                if (key.equals(keyList.get(7))) {
                    monVal = ComputeUtil.safeSub((BigDecimal)quoteMap.get(mon), (BigDecimal)recMoneyMap.get(mon));
                }
                if (key.equals(keyList.get(8))) {
                    monVal = ComputeUtil.safeSub((BigDecimal)settleMap.get(mon), (BigDecimal)payContractMap.get(mon));
                }
                if (key.equals(keyList.get(9))) {
                    monVal = ComputeUtil.safeSub((BigDecimal)recMoneyMap.get(mon), (BigDecimal)payMap.get(mon));
                }
                if ((subVO = (FinanceUseResSubVO)subVOMap.get(key)) == null) {
                    subVO = new FinanceUseResSubVO();
                    subVOMap.put(key, subVO);
                }
                subVO.setTotal(ComputeUtil.safeAdd((BigDecimal)subVO.getTotal(), (BigDecimal)monVal));
                ArrayList<BigDecimal> monthDataList = subVO.getMonthData();
                if (monthDataList == null) {
                    monthDataList = new ArrayList<BigDecimal>();
                    subVO.setMonthData(monthDataList);
                }
                monthDataList.add(monVal);
            }
        }
        resVO.setMonthData(monthData);
        resVO.setProduction((FinanceUseResSubVO)subVOMap.get(keyList.get(0)));
        resVO.setPartAReport((FinanceUseResSubVO)subVOMap.get(keyList.get(1)));
        resVO.setBackMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(2)));
        resVO.setOpenInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(3)));
        resVO.setSettleMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(4)));
        resVO.setReceiveInvince((FinanceUseResSubVO)subVOMap.get(keyList.get(5)));
        resVO.setPayMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(6)));
        resVO.setShouldRecNotRec((FinanceUseResSubVO)subVOMap.get(keyList.get(7)));
        resVO.setShouldPayNotPay((FinanceUseResSubVO)subVOMap.get(keyList.get(8)));
        resVO.setBillMoney((FinanceUseResSubVO)subVOMap.get(keyList.get(9)));
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    @Override
    public CommonResponse<ContractVo> saveOrUpdate(ContractVo contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isBlank((CharSequence)contractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(INCOME_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                contractVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
        lambda.ne(contractVo.getId() != null && contractVo.getId() > 0L, BaseEntity::getId, (Object)contractVo.getId());
        List entities = super.list((Wrapper)lambda);
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseTaxMoney(entity.getContractTaxMny());
        entity.setBaseMoney(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity);
        List detailsVos = contractVo.getCheckList();
        ArrayList<ContractDetailEntity> saveOrUpldates = new ArrayList<ContractDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            ContractDetailEntity detailslist;
            detailsVo.setChangeType(Integer.valueOf(0));
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (ContractDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ContractDetailEntity.class));
                detailslist.setContractId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (ContractDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ContractDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.detailsService.removeByIds(deleteIds, false);
        }
        List clauseVos = contractVo.getClauseList();
        ArrayList<ContractClauseEntity> clauseList = new ArrayList<ContractClauseEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (ContractClauseVo clauseVo : clauseVos) {
            ContractClauseEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (ContractClauseEntity)((Object)BeanMapper.map((Object)clauseVo, ContractClauseEntity.class));
                detailslist.setContractId(entity.getId());
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (ContractClauseEntity)((Object)BeanMapper.map((Object)clauseVo, ContractClauseEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.clauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.clauseService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ContractVo queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById(id));
        if (entity != null) {
            ContractVo contractVo = (ContractVo)BeanMapper.map((Object)((Object)entity), ContractVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter("ne", (Object)5));
            List purchaseDetailss = this.detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (ContractDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)purchaseDetailss, ContractDetailVo.class);
                Collections.sort(resultMapList, new ContractDetailComparatorVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter("eq", (Object)contractVo.getId()));
            query.getOrderMap().put("createTime", "asc");
            List clauses = this.clauseService.queryList(query, false);
            if (clauses != null && clauses.size() > 0) {
                List clauseVoList = BeanMapper.mapList((Iterable)clauses, ContractClauseVo.class);
                contractVo.setClauseList(clauseVoList);
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteContract(List<ContractVo> vos) {
        for (ContractVo vo : vos) {
            this.detailsService.deleteByContractId(vo.getId());
            this.clauseService.deleteByContractId(vo.getId());
            this.contractMapper.deleteById(vo.getId());
        }
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public Date getSignDate(Long id) {
        return this.contractMapper.getSignDate(id);
    }

    @Override
    public void updateCollectMny(Long contractId, BigDecimal collectMny, Boolean type) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        BigDecimal sumCollectMny = contractEntity.getSumCollectMny() == null ? BigDecimal.ZERO : contractEntity.getSumCollectMny();
        sumCollectMny = type != false ? sumCollectMny.add(collectMny) : sumCollectMny.subtract(collectMny);
        contractEntity.setSumCollectMny(sumCollectMny);
        super.updateById((Object)contractEntity);
    }

    @Override
    public void updateInvoicingMny(Long contractId, BigDecimal invoicingTaxMny, BigDecimal invoicingMny, Boolean type) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        BigDecimal sumInvoicingMny = contractEntity.getSumInvoicingMny() == null ? BigDecimal.ZERO : contractEntity.getSumInvoicingMny();
        sumInvoicingMny = type != false ? sumInvoicingMny.add(invoicingMny) : sumInvoicingMny.subtract(invoicingMny);
        BigDecimal sumInvoicingTaxMny = contractEntity.getSumInvoicingTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumInvoicingTaxMny();
        sumInvoicingTaxMny = type != false ? sumInvoicingTaxMny.add(invoicingTaxMny) : sumInvoicingTaxMny.subtract(invoicingTaxMny);
        contractEntity.setSumInvoicingTaxMny(sumInvoicingTaxMny);
        contractEntity.setSumInvoicingMny(sumInvoicingMny);
        super.updateById((Object)contractEntity);
    }

    @Override
    public ContractVo searchContract(Long projectId) {
        ContractVo contractVo = this.contractMapper.searchContract(projectId);
        return contractVo;
    }

    @Override
    public ContractEntity queryFinanceHistory(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)((ContractMapper)this.baseMapper).selectById(id));
        CommonResponse sumReceiveVOList = this.receiveManageApi.getSumReceiveVOList(id);
        if (!sumReceiveVOList.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        contractEntity.setReceiveVOList(((SumReceiveVO)sumReceiveVOList.getData()).getReceiveVOList());
        CommonResponse invoiceOpenRecord = this.invoiceApi.getInvoiceOpenRecord(id);
        if (invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = (InvoiceOpenRecordVO)invoiceOpenRecord.getData();
            contractEntity.setSumInvoicingTaxMny(data.getInvoiceTaxMny());
        }
        return contractEntity;
    }

    @Override
    public InvoiceOpenRecordVO queryTaxHistory(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)((ContractMapper)this.baseMapper).selectById(id));
        CommonResponse invoiceOpenRecord = this.invoiceApi.getInvoiceOpenRecord(id);
        if (invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = (InvoiceOpenRecordVO)invoiceOpenRecord.getData();
            data.setContractTaxMny(contractEntity.getContractTaxMny());
            data.setTaxRate(contractEntity.getTaxRate());
            return data;
        }
        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u67e5\u8be2\u53d1\u7968\u8bb0\u5f55\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
    }

    @Override
    public ContractVo contractDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractMapper.selectById(id));
        ContractVo contractVo = (ContractVo)BeanMapper.map((Object)((Object)entity), ContractVo.class);
        ContractVo vo = new ContractVo();
        vo.setId(contractVo.getId());
        vo.setContractName(contractVo.getContractName());
        vo.setContractTaxMny(contractVo.getContractTaxMny());
        vo.setTaxRate(contractVo.getTaxRate());
        vo.setProjectId(contractVo.getProjectId());
        vo.setProjectName(contractVo.getProjectName());
        vo.setCustomerId(contractVo.getCustomerId());
        vo.setCustomerName(contractVo.getCustomerName());
        vo.setContractorUnit(contractVo.getContractorUnit());
        vo.setContractorUnitName(contractVo.getContractorUnitName());
        vo.setOrgId(contractVo.getOrgId());
        vo.setOrgName(contractVo.getOrgName());
        vo.setVersion(contractVo.getVersion());
        return vo;
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> capitalCount(Integer range, List<Long> orgIds) {
        String year = null;
        String startMonth = null;
        String endMonth = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
            startMonth = EJCDateUtil.getYear() + "-01";
            endMonth = EJCDateUtil.getMonth((int)0);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal inContractMoney = this.contractMapper.inContractMoney(range, year, orgIds, tenantId);
        BigDecimal totalReceiveMoney = this.contractMapper.totalReceiveMoney(range, year, orgIds, tenantId);
        BigDecimal outContractMoney = this.contractMapper.outContractMoney(range, year, orgIds, tenantId);
        BigDecimal totalSettleMoney = this.contractMapper.totalSettleMoney(range, year, orgIds, tenantId);
        BigDecimal totalOutMoney = this.contractMapper.totalOutMoney(range, year, orgIds, tenantId);
        BigDecimal totalQuoteMoney = this.quoteService.totalQuoteMoney(range, year, orgIds, tenantId);
        BigDecimal totalContractOutMoney = this.contractMapper.totalContractOutMoney(range, year, orgIds, tenantId);
        BigDecimal shouldRecNotRec = ComputeUtil.safeSub((BigDecimal)totalQuoteMoney, (BigDecimal)totalReceiveMoney);
        BigDecimal shouldPayNotPay = ComputeUtil.safeSub((BigDecimal)totalSettleMoney, (BigDecimal)totalContractOutMoney);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("inContractMoney", inContractMoney);
        map.put("shouldRecNotRec", shouldRecNotRec);
        map.put("shouldPayNotPay", shouldPayNotPay);
        map.put("totalReceiveMoney", totalReceiveMoney);
        map.put("outContractMoney", outContractMoney);
        map.put("totalSettleMoney", totalSettleMoney);
        map.put("totalOutMoney", totalOutMoney);
        map.put("bookMoney", this.getProjectSumMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    private BigDecimal getProjectSumMny() {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SumAggregationBuilder aggregation = (SumAggregationBuilder)((SumAggregationBuilder)AggregationBuilders.sum((String)"sum_mny").field("xiangmukeyongzijin")).missing((Object)0);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"projectDepartmentId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        SearchRequest searchRequest = new SearchRequest(new String[]{"project_finance"});
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder);
        BigDecimal sumMny = null;
        try {
            SearchResponse response = null;
            try {
                response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                Aggregations aggregations = response.getAggregations();
                ParsedSum sum_mny = (ParsedSum)aggregations.get("sum_mny");
                sumMny = ComputeUtil.toBigDecimal((Double)sum_mny.getValue());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ComputeUtil.nullToZero(sumMny);
    }

    @Override
    public CommonResponse<List<Map>> getproject(List<Long> orgIds) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map> map = this.contractMapper.getproject(orgIds, tenantId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    @Override
    public CommonResponse<Map> getprogress(Long projectId) {
        Map map = this.contractMapper.getProjectDetail(projectId);
        Map Datemap = this.contractMapper.getProjectDate(projectId);
        SimpleDateFormat fm = new SimpleDateFormat("yyy-MM-dd");
        String now = fm.format(new Date());
        String start = null;
        String end = null;
        if (Datemap != null) {
            if (Datemap.get("endDate") != null) {
                end = fm.format((Date)Datemap.get("endDate"));
            }
            if (Datemap.get("startDate") != null) {
                start = fm.format((Date)Datemap.get("startDate"));
            }
        }
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("customerName", map.get("customerName"));
        map.put("projectState", map.get("projectState"));
        if (StringUtils.isNotEmpty((CharSequence)end) && StringUtils.isNotEmpty((CharSequence)start)) {
            if (ContractServiceImpl.subtractDay(now, end) >= 0) {
                map.put("dateProgress", "100%");
            } else {
                int a = ContractServiceImpl.subtractDay(now, start);
                if (a <= 0) {
                    map.put("dateProgress", "0%");
                } else {
                    int b = ContractServiceImpl.subtractDay(end, start);
                    int c = a * 100 / b;
                    map.put("dateProgress", c + "%");
                }
            }
        } else {
            map.put("dateProgress", "0%");
        }
        BigDecimal outputMoney = this.contractMapper.outputMoney(projectId);
        BigDecimal contractMoney = this.contractMapper.contractMoney(projectId);
        map.put("contractMoney", contractMoney);
        map.put("outputMoney", outputMoney);
        if (contractMoney.compareTo(BigDecimal.ZERO) == 0) {
            map.put("outputProgress", "0%");
        } else {
            map.put("outputProgress", outputMoney.divide(contractMoney, 8, 4).multiply(new BigDecimal("100")).setScale(0, 4) + "%");
        }
        CommonResponse membersResp = this.userApi.getEmployeeList((Long)map.get("projectDepartmentId"));
        if (!membersResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u6210\u5458\u5931\u8d25\u3002");
        }
        map.put("managerNum", ((List)membersResp.getData()).size());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)map);
    }

    @Override
    public CommonResponse<List<ProjectProgressVo>> getprogressList(List<Long> projectIds) {
        List<ProjectProgressVo> projectDetailList = this.contractMapper.getProjectDetailList(projectIds);
        for (ProjectProgressVo pro : projectDetailList) {
            pro.setOutputMoney(this.contractMapper.outputMoney(pro.getProjectId()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", projectDetailList);
    }

    @Override
    public CommonResponse<List<Map>> costCount(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {
            year = Calendar.getInstance().get(1) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map> map = this.contractMapper.costCount(range, year, orgIds, tenantId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", map);
    }

    @Override
    public CommonResponse<JSONObject> projectCount(String range, String name, String dateIn, String projectType, List<Long> orgIds) {
        List<ProjectCountVO> projectCountVOS;
        Map<String, List<ProjectCountVO>> map;
        BigDecimal contractTaxMny;
        Long tenantId = InvocationInfoProxy.getTenantid();
        String year = Calendar.getInstance().get(1) + "";
        String startDate = null;
        String endDate = null;
        String type = null;
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = Calendar.getInstance().get(1) + "";
            type = "1";
        } else if (ProjectSurveyEnum.LASTYEAR.getCode().equals(dateIn)) {
            dateIn = Calendar.getInstance().get(1) - 1 + "";
            type = "1";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            instance.add(2, -5);
            type = "2";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            instance.add(2, -2);
            type = "2";
        } else if (ProjectSurveyEnum.THISMON.getCode().equals(dateIn)) {
            instance.add(2, 0);
            type = "2";
        }
        startDate = dateFormat.format(instance.getTime());
        endDate = dateFormat.format(new Date());
        List<ProjectCountVO> list = this.contractMapper.projectCount_project(range, year, startDate, endDate, dateIn, projectType, orgIds, tenantId, type);
        ArrayList<Long> ids = new ArrayList<Long>();
        BigDecimal allContractMoney = BigDecimal.ZERO;
        HashSet<String> provinceSet = new HashSet<String>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            BigDecimal contractTaxMny2 = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            allContractMoney = allContractMoney.add(contractTaxMny2);
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMmap != null) {
                    String string = areaMmap.get("province") == null ? "\u5176\u4ed6" : areaMmap.get("province");
                    String string2 = areaMmap.get("city") == null ? "\u5176\u4ed6" : (String)areaMmap.get("city");
                    String county = areaMmap.get("county") == null ? "\u5176\u4ed6" : (String)areaMmap.get("county");
                    vo.setProvince(string);
                    vo.setCity(string2);
                    vo.setCounty(county);
                    provinceSet.add(string);
                    citySet.add(string2);
                    countySet.add(county);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string2.equals(name)) continue;
                    pname = string;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    String string = projectCountVO.getCounty();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!countyMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        countyMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    String string = projectCountVO.getCity();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!cityMap.containsKey(string)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        pvo.setContractMoney(contractTaxMny);
                        cityMap.put(string, pvo);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    projectCountVOS = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        ProjectVo projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO.setProjectList(projectVos);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO projectCountVO : list) {
                String string = projectCountVO.getProvince();
                BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                if (!provinceMap.containsKey(string)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    pvo.setContractMoney(contractTaxMny);
                    provinceMap.put(string, pvo);
                    continue;
                }
                ProjectDataVO projectDataVO = (ProjectDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                provinceMap.put(string, projectDataVO);
            }
            map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (ProjectDataVO projectDataVO : dataVOS) {
                if (!map.containsKey(projectDataVO.getName())) continue;
                projectCountVOS = map.get(projectDataVO.getName());
                ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    ProjectVo projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVos.add(projectVo);
                }
                projectDataVO.setProjectList(projectVos);
            }
        }
        int allProjectNumber = list.size();
        BigDecimal allInMoney = ids.size() > 0 ? this.contractMapper.allInMoney(ids) : BigDecimal.ZERO;
        BigDecimal bigDecimal = ids.size() > 0 ? this.contractMapper.allOutMoney(ids) : BigDecimal.ZERO;
        BigDecimal bigDecimal2 = allInMoney.subtract(bigDecimal);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)allProjectNumber);
        jsonObject.put("allContractMoney", (Object)allContractMoney);
        jsonObject.put("allInMoney", (Object)allInMoney);
        jsonObject.put("allOutMoney", (Object)bigDecimal);
        jsonObject.put("bookMoney", (Object)bigDecimal2);
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>(){

                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, ProjectDataVO> map = new HashMap<String, ProjectDataVO>();
        for (ProjectCountVO vo : list) {
            BigDecimal contractTaxMny;
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            if (!map.containsKey(childrenName)) {
                ProjectDataVO pvo = new ProjectDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                pvo.setContractMoney(contractTaxMny);
                map.put(childrenName, pvo);
                continue;
            }
            ProjectDataVO projectDataVO = (ProjectDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity)) : list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<ProjectDataVO>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
            for (ProjectCountVO projectCountVO : projectCountVOS) {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setId(projectCountVO.getId());
                projectVo.setName(projectCountVO.getProjectName());
                projectVo.setOrgId(projectCountVO.getOrgId());
                projectVos.add(projectVo);
            }
            dataVO.setProjectList(projectVos);
        }
        return projectDataVOS;
    }

    @Override
    public IPage<ProjectInOutVO> proPageList(Map<String, Object> params) {
        Object orgIds = params.get("orgIds");
        if (orgIds == null) {
            return new Page();
        }
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageIndex").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.contractMapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.contractMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<Map<String, Object>> incomeMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).incomeMnyWarn(sqlParamList);
    }

    @Override
    public List<IncomeContractWarnVo> outIncomeMnyWarn(List<Long> tenantIds) {
        return ((ContractMapper)this.baseMapper).outIncomeMnyWarn(tenantIds);
    }

    @Override
    public BigDecimal getInContractMoneySum(Map<String, Object> params) {
        return this.contractMapper.getInContractMoneySum(params);
    }

    @Override
    public void refreshInvoiceMny(Map<Long, BigDecimal> map) {
    }

    @Override
    public IPage selectPage(Page<ContractEntity> pageData, QueryWrapper wrapper) {
        return ((ContractMapper)this.baseMapper).selectPage((IPage)pageData, (Wrapper)wrapper);
    }

    @Override
    public CommonResponse<String> refreshAddress(Long projectId, String address) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ContractEntity::getProjectId, (Object)projectId);
        updateWrapper.set(ContractEntity::getAddress, (Object)address);
        super.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u8be6\u7ec6\u5730\u5740\u4fee\u6539\u6210\u529f\uff01");
    }

    @Override
    public List<ContractVo> projectSumCollectMny(List<Long> tids) {
        return ((ContractMapper)this.baseMapper).projectSumCollectMny(tids);
    }

    public static int subtractDay(String date1, String date2) {
        int rs = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = simpleDateFormat.parse(date1);
            Date end = simpleDateFormat.parse(date2);
            long sss = (start.getTime() - end.getTime()) / 1000L;
            rs = (int)sss / 86400;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static void main(String[] args) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(2, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = dateFormat.format(instance.getTime());
        System.out.println(EJCDateUtil.getMonth((int)-35));
    }
}

