/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="production")
public class ProductionBpmService
implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionClaimService productionClaimService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProductionEntity productionEntity = (ProductionEntity)((Object)this.productionService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionEntity.getContractId()));
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        contractEntity.setSumProductionTaxMny(finishTaxMny.add(sumProductionTaxMny));
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        contractEntity.setSumProductionMny(finishMny.add(sumProductionMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter("eq", (Object)productionEntity.getId()));
        List claimList = this.productionClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumProductionMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny()).add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            this.callBackProduction(billId, state, billTypeCode);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    private void callBackProduction(Long billId, Integer state, String billTypeCode) {
        ProductionEntity productionEntity = (ProductionEntity)((Object)this.productionService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionEntity.getContractId()));
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        contractEntity.setSumProductionTaxMny(sumProductionTaxMny.subtract(finishTaxMny));
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        contractEntity.setSumProductionMny(sumProductionMny.subtract(finishMny));
        this.contractService.updateById((Object)contractEntity);
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter("eq", (Object)productionEntity.getId()));
        List claimList = this.productionClaimService.queryList(parm, false);
        if (null != claimList && claimList.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            HashMap<Long, BigDecimal> idMap = new HashMap<Long, BigDecimal>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            List claimEntities = this.claimService.queryList(queryParam, false);
            Iterator iterator = claimEntities.iterator();
            while (iterator.hasNext()) {
                ClaimEntity ce;
                ce.setSumProductionMny(((ce = (ClaimEntity)((Object)iterator.next())).getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny()).subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : (BigDecimal)idMap.get(ce.getId())));
            }
            this.claimService.updateBatchById(claimEntities);
        }
    }
}

