/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionDetailEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.ProductionOtherEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionDetailService;
import com.ejianc.business.income.service.IProductionOtherService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ProductionClaimVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionOtherVO;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.comparator.ProductionDetailComparatorVo;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="ProductionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCTION_BILL_CODE = "INCOME_PRODUCTION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionClaimService productionClaimService;
    @Autowired
    private IProductionOtherService productionOtherService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IClaimService claimService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo) {
        List entities;
        LambdaQueryWrapper lambda;
        ContractEntity contractEntity;
        block44: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionVo.getContractId()));
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                CommonResponse param;
                List claimVos;
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (productionVo.getContractVersion() != null && productionVo.getContractVersion() != 0) {
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = productionVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                    } else {
                        CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        return version;
                    }
                }
                if ((claimVos = productionVo.getClaimList()) == null || claimVos.size() <= 0) break block44;
                HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                for (ProductionClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() == null || claimVo.getClaimVersion() == 0) continue;
                    versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                }
                if (versionMap == null || versionMap.size() <= 0) break block44;
                if (locked) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                    List claimEntities = this.claimService.queryList((QueryParam)param, false);
                    for (ClaimEntity claimEntity : claimEntities) {
                        if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) == (Integer)versionMap.get(claimEntity.getId())) continue;
                        CommonResponse commonResponse = CommonResponse.error((String)"\u53d8\u66f4\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block44;
                }
                param = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return param;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && productionVo.getProductionDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u4ea7\u503c\u65f6\u95f4\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Date lastDate = this.productionMapper.getLastDate(productionVo.getContractId());
        if (null != lastDate && productionVo.getProductionDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("\u4ea7\u503c\u65f6\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u4e0b\u7684\u4ea7\u503c\u65f6\u95f4");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionEntity entity = null;
        String operateType = null;
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)productionVo.getBillCode())) {
                productionVo.setBillCode(null);
            }
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "edit";
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)productionVo.getContractId()));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
            List entities2 = super.queryList(queryParam, false);
            if (null != entities2 && entities2.size() > 0) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PRODUCTION_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            productionVo.setBillCode((String)billCode.getData());
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "add";
        }
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)productionVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity);
        List detailsVos = productionVo.getCheckList();
        ArrayList<ProductionDetailEntity> saveOrUpldates = new ArrayList<ProductionDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            ProductionDetailEntity detailslist;
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (ProductionDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ProductionDetailEntity.class));
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (ProductionDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ProductionDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.productionDetailService.removeByIds(deleteIds, false);
        }
        List clauseVos = productionVo.getClaimList();
        ArrayList<ProductionClaimEntity> clauseList = new ArrayList<ProductionClaimEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (ProductionClaimVo clauseVo : clauseVos) {
            ProductionClaimEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (ProductionClaimEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionClaimEntity.class));
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (ProductionClaimEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionClaimEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.productionClaimService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.productionClaimService.removeByIds(deleteClauseIds, false);
        }
        List otherVOs = productionVo.getOtherList();
        ArrayList<ProductionOtherEntity> otherList = new ArrayList<ProductionOtherEntity>();
        ArrayList<Long> deleteOtherIds = new ArrayList<Long>();
        for (ProductionOtherVO clauseVo : otherVOs) {
            ProductionOtherEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (ProductionOtherEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionOtherEntity.class));
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                otherList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (ProductionOtherEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionOtherEntity.class));
                otherList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteOtherIds.add(clauseVo.getId());
        }
        if (otherList.size() > 0) {
            this.productionOtherService.saveOrUpdateBatch(otherList, otherList.size(), false);
        }
        if (deleteOtherIds.size() > 0) {
            this.productionOtherService.removeByIds(deleteOtherIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ProductionVo queryDetail(Long id) {
        ProductionEntity entity = (ProductionEntity)((Object)this.productionMapper.selectById(id));
        if (entity != null) {
            ProductionVo vo = (ProductionVo)BeanMapper.map((Object)((Object)entity), ProductionVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List details = this.productionDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ProductionDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
                Collections.sort(resultMapList, new ProductionDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List productionClaimEntities = this.productionClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList((Iterable)productionClaimEntities, ProductionClaimVo.class));
            List productionOtherEntities = this.productionOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList((Iterable)productionOtherEntities, ProductionOtherVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteProduction(List<ProductionVo> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ProductionHistoryVo queryProductionHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List prodEntities = this.productionMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"production_date", "create_time"}));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        ProductionHistoryVo vo = new ProductionHistoryVo();
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        BigDecimal add = contractTaxMny;
        if (add.compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumImageProgress(BigDecimal.ZERO);
        } else {
            vo.setSumImageProgress(sumProductionTaxMny.divide(add, 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setProductionRecord(BeanMapper.mapList((Iterable)prodEntities, ProductionVo.class));
        return vo;
    }

    @Override
    public List<ProductionDetailVo> detailRef(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("productionId", new Parameter("eq", (Object)id));
        List details = this.productionDetailService.queryList(queryParam, false);
        if (details != null && details.size() > 0) {
            for (ProductionDetailEntity cdEntity : details) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
            Collections.sort(resultMapList, new ProductionDetailComparatorVo());
            return TreeNodeBUtil.buildTree((List)resultMapList);
        }
        return null;
    }

    @Override
    public JSONObject queryProductionDetailHistory(ProductionDetailVo productionDetailVo) {
        BigDecimal sumFinishNum = new BigDecimal(0);
        BigDecimal sumFinishMny = new BigDecimal(0);
        if (productionDetailVo.getContractDetailId() != null) {
            productionDetailVo.setSourceType(Integer.valueOf(1));
            List<ProductionDetailVo> list = ((ProductionMapper)this.baseMapper).queryProductionDetailHistory(productionDetailVo);
            if (CollectionUtils.isNotEmpty(list)) {
                for (ProductionDetailVo vo : list) {
                    sumFinishNum = BigDecimalUtils.safeAdd((BigDecimal)sumFinishNum, (BigDecimal)vo.getFinishNum());
                    sumFinishMny = BigDecimalUtils.safeAdd((BigDecimal)sumFinishMny, (BigDecimal)vo.getFinishMny());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumFinishNum", (Object)sumFinishNum);
        jo.put("sumFinishMny", (Object)sumFinishMny);
        return jo;
    }

    @Override
    public ProductionVo queryInfoProjectId(Long projectId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.select(new String[]{"IFNULL(sum(finish_tax_mny) , 0 ) AS sumProductionTaxMny"});
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumProductionTaxMny = BigDecimal.ZERO;
        if (list.get(0) != null) {
            sumProductionTaxMny = list.stream().map(ProductionEntity::getSumProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        ProductionVo productionVo = new ProductionVo();
        productionVo.setSumProductionTaxMny(sumProductionTaxMny);
        return productionVo;
    }
}

