package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

@Service("quote")
public class QuoteBpmService implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IProductionService productionService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
        QuoteEntity quoteEntity = quoteService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
        //本期报量金额（含税）
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        //累计报量（含税）
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        //累加
        contractEntity.setSumQuoteTaxMny(quoteTaxMny.add(sumQuoteTaxMny));

        //本期报量金额（不含税）
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        //累计报量（不含税）
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        //累计报量（不含税）
        contractEntity.setSumQuoteMny(quoteMny.add(sumQuoteMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter(QueryParam.EQ, quoteEntity.getId()));
        List<QuoteClaimEntity> claimList = quoteClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumQuoteMny((ce.getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny())
                        .add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        // 回写产值报量是否被引用过
        List<QuoteDetailEntity> checkList = quoteDetailService.queryList(parm, false);

        if (null != checkList && checkList.size() > 0) {
            Set<Long> ids = new HashSet<>();
            for(QuoteDetailEntity qde:checkList){
                if(null!=qde.getProductionId()&&qde.getProductionId()>0){
                    if(ids.add(qde.getProductionId())){
                        LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
                        updateWrapper.set(ProductionEntity::getQuoteFlag,1);//已被引用
                        updateWrapper.eq(ProductionEntity::getId,qde.getProductionId());
                        productionService.update(updateWrapper);
                    }
                }
            }
        }

        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            callBackQuote(billId,state,billTypeCode);
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    private void callBackQuote(Long billId, Integer state, String billTypeCode){
        //回写主表
        QuoteEntity quoteEntity = quoteService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
        //本期报量金额（含税）
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        //累计报量（含税）
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        //累加
        contractEntity.setSumQuoteTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));

        //本期报量金额（不含税）
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        //累计报量（不含税）
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        //累计报量（不含税）
        contractEntity.setSumQuoteMny(sumQuoteMny.subtract(quoteMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter(QueryParam.EQ, quoteEntity.getId()));
        List<QuoteClaimEntity> claimList = quoteClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumQuoteMny((ce.getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny())
                        .subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        // 回写产值报量是否被引用过
        List<QuoteDetailEntity> checkList = quoteDetailService.queryList(parm, false);

        if (null != checkList && checkList.size() > 0) {
            Set<Long> ids = new HashSet<>();
            for(QuoteDetailEntity qde:checkList){
                if(null!=qde.getProductionId()&&qde.getProductionId()>0){
                    if(ids.add(qde.getProductionId())){
                        LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
                        updateWrapper.set(ProductionEntity::getQuoteFlag,0);//已被引用
                        updateWrapper.eq(ProductionEntity::getId,qde.getProductionId());
                        productionService.update(updateWrapper);
                    }
                }
            }
        }
    }
}
