/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.equipment.api.IEquipmentWarnApi;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.FinanceWarnV0;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.SqlParam;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialWarnApi;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.sub.api.ISubWarnApi;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projectPayWarn/"})
public class PayContractWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL_INCOME = "/ejc-income-frontend/#/incomeContract/contractApprove?id=";
    private static final String PC_URL_PROJECT = "/ejc-report-frontend/#/proPeportDetail?id=";
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISubWarnApi subWarnApi;
    @Autowired
    private IMaterialWarnApi materialWarnApi;
    @Autowired
    private IEquipmentWarnApi equipmentWarnApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IPayContractApi payContractApi;

    @PostMapping(value={"projectPayContractMnyWarn"})
    public CommonResponse<String> outIncomeMnyWarn(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            return CommonResponse.error((String)"\u6267\u884c\u9879\u76ee\u7c7b\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u6536\u5165\u5408\u540c\u91d1\u989d\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Long> tids = sqlParamList.stream().map(SqlParam::getTenantId).collect(Collectors.toList());
        CommonResponse subCommon = this.subWarnApi.subProjectOutMny(tids);
        this.logger.debug("\u67e5\u8be2\u5206\u5305\u5408\u540c\u652f\u51fa\u91d1\u989d\uff01");
        if (!subCommon.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u5206\u5305\u5408\u540c\u652f\u51fa\u91d1\u989d\u5931\u8d25\uff01");
        }
        CommonResponse materialCommon = this.materialWarnApi.materialProjectOutMny(tids);
        this.logger.debug("\u67e5\u8be2\u7269\u8d44\u5408\u540c\u652f\u51fa\u91d1\u989d\uff01");
        this.logger.info("tids\uff1a{}", tids);
        if (!materialCommon.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u7269\u8d44\u5408\u540c\u652f\u51fa\u91d1\u989d\u5931\u8d25\uff01");
        }
        CommonResponse equipmentCommon = this.equipmentWarnApi.equipmentProjectOutMny(tids);
        this.logger.debug("\u67e5\u8be2\u8bbe\u5907\u91c7\u8d2d\u3001\u8bbe\u5907\u79df\u8d41\u652f\u51fa\u91d1\u989d\uff01");
        if (!equipmentCommon.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u3001\u8bbe\u5907\u79df\u8d41\u652f\u51fa\u91d1\u989d\u5931\u8d25\uff01");
        }
        List<IncomeContractWarnVo> incomeList = this.contractService.outIncomeMnyWarn(tids);
        CommonResponse projectPayMny = this.payContractApi.getProjectPayMny();
        this.logger.debug("\u67e5\u8be2\u9879\u76ee\u5408\u540c\u7684\u5b9e\u9645\u4ed8\u6b3e\u989d\uff01");
        if (!projectPayMny.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u9879\u76ee\u5408\u540c\u7684\u5b9e\u9645\u4ed8\u6b3e\u989d\u5931\u8d25\uff01");
        }
        List<IncomeContractWarnVo> incomeContractWarnVos = this.outIncomeWarn(incomeList, sqlParamList, (List)subCommon.getData(), (List)materialCommon.getData(), (List)equipmentCommon.getData(), (List)projectPayMny.getData());
        if (CollectionUtils.isEmpty(incomeContractWarnVos)) {
            this.logger.error("\u6267\u884c\u672a\u4ed8\u6b3e\u989d\u5927\u4e8e\u672a\u6536\u6b3e\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.payTransToWarnVO2(incomeContractWarnVos, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }

    private List<IncomeContractWarnVo> outIncomeWarn(List<IncomeContractWarnVo> incomeVo, List<SqlParam> sqlParamList, List<SubWarnVo> subVo, List<MaterialWarnVo> materialVo, List<EquipmentWarnVo> equipmentVo, List<FinanceWarnV0> list) {
        ArrayList outList = new ArrayList();
        outList.addAll(BeanMapper.mapList(subVo, IncomeContractWarnVo.class));
        outList.addAll(BeanMapper.mapList(materialVo, IncomeContractWarnVo.class));
        outList.addAll(BeanMapper.mapList(equipmentVo, IncomeContractWarnVo.class));
        if (outList.size() < 1) {
            this.logger.debug("\u6267\u884c\u8be5\u9879\u76ee\u6240\u6709\u6536\u5165\u5408\u540c\u7684\u5408\u540c\u603b\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u652f\u51fa\u5408\u540c\u4e3a\u7a7a\uff01");
            return null;
        }
        HashMap<Long, Object> outMap = new HashMap<Long, Object>();
        for (Object outVo : outList) {
            if (outMap.containsKey(outVo.getProjectId())) {
                IncomeContractWarnVo incomeContractWarnVo = (IncomeContractWarnVo)outMap.get(outVo.getProjectId());
                incomeContractWarnVo.setOutMny(incomeContractWarnVo.getOutMny().add(outVo.getOutMny()));
                outMap.put(outVo.getProjectId(), incomeContractWarnVo);
                continue;
            }
            outMap.put(outVo.getProjectId(), outVo);
        }
        HashMap<Long, FinanceWarnV0> map = new HashMap<Long, FinanceWarnV0>();
        for (FinanceWarnV0 financeWarnV0 : list) {
            map.put(financeWarnV0.getProjectId(), financeWarnV0);
        }
        HashMap<Long, IncomeContractWarnVo> inMap = new HashMap<Long, IncomeContractWarnVo>();
        for (IncomeContractWarnVo incomeContractWarnVo : incomeVo) {
            inMap.put(incomeContractWarnVo.getProjectId(), incomeContractWarnVo);
        }
        HashMap<Long, SqlParam> hashMap = new HashMap<Long, SqlParam>();
        for (SqlParam sqlParam : sqlParamList) {
            hashMap.put(sqlParam.getTenantId(), sqlParam);
        }
        ArrayList<IncomeContractWarnVo> arrayList = new ArrayList<IncomeContractWarnVo>();
        for (IncomeContractWarnVo inoutVo : outMap.values()) {
            SqlParam sqlParam = (SqlParam)hashMap.get(inoutVo.getTenantId());
            BigDecimal outMny = inoutVo.getOutMny();
            if (outMny == null) {
                outMny = BigDecimal.ZERO;
            }
            if (map.containsKey(inoutVo.getProjectId())) {
                inoutVo.setUncollectedMny(ComputeUtil.safeSub((BigDecimal)outMny, (BigDecimal)((FinanceWarnV0)map.get(inoutVo.getProjectId())).getSumPayMny()));
            } else {
                inoutVo.setUncollectedMny(outMny);
            }
            if (inMap.containsKey(inoutVo.getProjectId())) {
                BigDecimal sumCollectMny;
                IncomeContractWarnVo incomeContractWarnVo;
                BigDecimal inContractTaxMny;
                BigDecimal overMny;
                BigDecimal uncollectedMny = inoutVo.getUncollectedMny();
                if (uncollectedMny.compareTo(overMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeSub((BigDecimal)(inContractTaxMny = (incomeContractWarnVo = (IncomeContractWarnVo)inMap.get(inoutVo.getProjectId())).getContractTaxMny()), (BigDecimal)(sumCollectMny = incomeContractWarnVo.getSumCollectMny())), (BigDecimal)new BigDecimal(sqlParam.getValue()))) < 0) continue;
                inoutVo.setUncollectedMny(uncollectedMny);
                inoutVo.setOverMny(overMny);
                inoutVo.setDiff(ComputeUtil.safeSub((BigDecimal)uncollectedMny, (BigDecimal)overMny));
                inoutVo.setWarnLevel(sqlParam.getWarnLevel());
                inoutVo.setPercent(Double.valueOf(sqlParam.getValue() * 100.0));
                arrayList.add(inoutVo);
                continue;
            }
            inoutVo.setOverMny(BigDecimal.ZERO);
            inoutVo.setDiff(inoutVo.getUncollectedMny());
            inoutVo.setWarnLevel(sqlParam.getWarnLevel());
            inoutVo.setPercent(Double.valueOf(sqlParam.getValue() * 100.0));
            arrayList.add(inoutVo);
        }
        if (arrayList.size() > 0) {
            List list2 = arrayList.stream().map(IncomeContractWarnVo::getProjectId).collect(Collectors.toList());
            CommonResponse res = this.projectApi.queryProjectByIds(list2);
            Map<Object, Object> projectMap = new HashMap();
            if (res.isSuccess() && !((List)res.getData()).isEmpty()) {
                projectMap = ((List)res.getData()).stream().collect(Collectors.toMap(BaseVO::getId, ProjectRegisterVO::getCode));
            }
            for (IncomeContractWarnVo re : arrayList) {
                re.setProjectCode((String)projectMap.get(re.getProjectId()));
            }
            return arrayList;
        }
        this.logger.debug("\u6267\u884c\u672a\u4ed8\u6b3e\u989d\u5927\u4e8e\u672a\u6536\u6b3e\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u7b26\u5408\u9884\u8b66\u7684\u4e3a\u7a7a\uff01");
        return null;
    }

    private List<EarlyWarnTransVO> payTransToWarnVO2(List<IncomeContractWarnVo> result, JSONObject defaultWarnInfo) {
        this.logger.debug("\u672a\u4ed8\u6b3e=\u8be5\u9879\u76ee\u6240\u6709\u652f\u51fa\u5408\u540c\u7684\u5408\u540c\u603b\u989d\uff08\u53bb\u6389\u96c6\u91c7\u5408\u540c\uff09-\u5408\u540c\u7684\u5b9e\u9645\u4ed8\u6b3e\u989d\uff1b\u672a\u6536\u6b3e=\u8be5\u9879\u76ee\u6240\u6709\u6536\u5165\u5408\u540c\u7684\u5408\u540c\u603b\u989d-\u5408\u540c\u7684\u5b9e\u9645\u6536\u6b3e\u989d\uff1b\n\u6309\u7167\u9879\u76ee\u7ef4\u5ea6\uff0c\u672a\u4ed8\u6b3e\u989d\u5927\u4e8e\u672a\u6536\u6b3e\u989d\u9884\u8b66\u5b8c\u6210\uff0c\u53d1\u9001\u9884\u8b66\uff01");
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (IncomeContractWarnVo m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.getProjectCode());
            vo.setPcTitle("\u672a\u4ed8\u6b3e\u989d\u5927\u4e8e\u672a\u6536\u6b3e\u989d");
            vo.setPcUrl(PC_URL_PROJECT + m.getProjectId() + "&orgId=" + m.getOrgId());
            vo.setOrgId(Long.valueOf(m.getOrgId()));
            vo.setOrgName(m.getOrgName());
            vo.setSourceId(m.getProjectId().toString());
            vo.setTenantId(Long.valueOf(m.getTenantId().toString()));
            vo.setWarnLevel(m.getWarnLevel());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", m.getProjectName()).replaceAll("#uncollectedMny#", df.format(this.getBigDecimal(m.getUncollectedMny()))).replaceAll("#percent#", m.getPercent().toString()).replaceAll("#overMny#", df.format(this.getBigDecimal(m.getOverMny()))).replaceAll("#diff#", df.format(this.getBigDecimal(m.getDiff()))));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

