/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.mapper.ContractFinishSettleMapper;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.FinishHistoryVo;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFinishSettleService")
public class ContractFinishSettleServiceImpl
extends BaseServiceImpl<ContractFinishSettleMapper, ContractFinishSettleEntity>
implements IContractFinishSettleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IVoucherApi voucherApi;
    @Autowired
    private ContractFinishSettleMapper contractFinishSettleMapper;
    @Autowired
    private IContractService contractService;

    @Override
    public ContractFinishSettleVO queryByContractId(Long contractId) {
        ContractFinishSettleVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ContractFinishSettleEntity entity = (ContractFinishSettleEntity)((Object)this.contractFinishSettleMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (ContractFinishSettleVO)BeanMapper.map((Object)((Object)entity), ContractFinishSettleVO.class);
        }
        return resp;
    }

    @Override
    public FinishHistoryVo queryFinishHistory(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)id);
        queryWrapper.orderByDesc((Object)"create_time");
        List finishSettleEntities = this.contractFinishSettleMapper.selectList((Wrapper)queryWrapper);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        FinishHistoryVo vo = new FinishHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        BigDecimal endSettleMny = finishSettleEntities.stream().filter(item -> item.getEndSettleMny() != null).map(ContractFinishSettleEntity::getEndSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setEndSettleMny(endSettleMny);
        vo.setFinishSettleVOList(BeanMapper.mapList((Iterable)finishSettleEntities, ContractFinishSettleVO.class));
        return vo;
    }

    public CommonResponse handleVoucher(ContractFinishSettleEntity entity, String voucherOptFlag) {
        CommonResponse response = null;
        if ("del".equals(voucherOptFlag) || "save".equals(voucherOptFlag)) {
            if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
                response = this.voucherApi.del((VoucherInfo)JSONObject.parseObject((String)entity.getVoucherInfo(), VoucherInfo.class));
                this.logger.info("{}\u5220\u9664\u51ed\u8bc1\u7ed3\u679c\uff1a{}", (Object)voucherOptFlag, (Object)DataConvertUtil.toPrettyFormat((Object)response));
                if (response.isSuccess()) {
                    LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
                    lambda.eq(BaseEntity::getId, (Object)entity.getId());
                    lambda.set(ContractFinishSettleEntity::getVoucherInfo, null);
                    lambda.set(ContractFinishSettleEntity::getVoucherFlag, (Object)0);
                    this.update((Wrapper)lambda);
                }
            }
            if ("del".equals(voucherOptFlag)) {
                return response;
            }
        }
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId((String)"BT202308000001", (Object)((Object)entity), (SystemCodeEnum)SystemCodeEnum.INCOME);
        response = this.voucherApi.save(voucherParams);
        this.logger.info("{}\u4fdd\u5b58\u51ed\u8bc1\u7ed3\u679c\uff1a{}", (Object)voucherOptFlag, (Object)DataConvertUtil.toPrettyFormat((Object)response));
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        lambda.eq(BaseEntity::getId, (Object)entity.getId());
        if (response.isSuccess()) {
            VoucherInfo voucherInfo = (VoucherInfo)response.getData();
            lambda.set(ContractFinishSettleEntity::getVoucherInfo, (Object)DataConvertUtil.objToString((Object)voucherInfo));
            lambda.set(ContractFinishSettleEntity::getVoucherFlag, (Object)voucherInfo.getVoucherFlag());
        } else {
            lambda.set(ContractFinishSettleEntity::getVoucherInfo, (Object)response.getMsg());
            lambda.set(ContractFinishSettleEntity::getVoucherFlag, (Object)VoucherFlag.FAILED);
        }
        this.update((Wrapper)lambda);
        return response;
    }
}

