package com.ejianc.business.integration.base.datacenter.impl;

import com.ejianc.business.integration.base.datacenter.DataCenterUrlProvider;
import com.ejianc.business.integration.base.properties.OpenApiProperties;
import com.ejianc.business.integration.base.datacenter.pojo.GatewayAddressResponse;
import lombok.Getter;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author nishch
 * @description: TODO
 * @date 2022/3/8
 */
@Service
public class DataCenterUrlProviderImpl implements DataCenterUrlProvider {

    @Resource
    @Getter
    RestTemplate restTemplate;
    @Resource
    OpenApiProperties properties;

    @Override
    public String buildBusinessUrl() {
        return useGatewayAddress().getGatewayUrl();
    }

    @Override
    public String buildTokenUrl() {
        return useGatewayAddress().getTokenUrl();
    }

    private GatewayAddressResponse.GatewayAddressDTO useGatewayAddress(){
        return queryGatewayAddress();
    }

    /**
     * TODO：不建议每次都调用接口，租户一旦创建所属数据中心不会再改变，建议将租户地址对应关系持久化到数据库和缓存中
     * @return GatewayAddressResponse.GatewayAddressDTO
     */
    @Override
    public GatewayAddressResponse.GatewayAddressDTO queryGatewayAddress() {
        ResponseEntity<GatewayAddressResponse> responseEntity =  restTemplate.getForEntity(properties.getGatewayAddressUrl().replace("%s",queryTenantId()),GatewayAddressResponse.class);
        return Objects.requireNonNull(responseEntity.getBody()).getData();
    }

    @Override
    public String queryTenantId() {
        return properties.getTenantId();
    }
}
