package com.ejianc.business.invest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目预立项
 * 
 * @author generator
 * 
 */
public class ProjectAdvanceSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织
    private String billCode; // 项目编码
    private String name; // 项目名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planBeginDate; // 计划开始日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planFinishDate; // 计划结束日期
    private Integer projectCycleNum; // 项目周期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planStartDate; // 计划开工日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planEndDate; // 计划竣工日期
    private Integer constructionPeriodNum; // 建设工期
    private Long engineeringTypeId; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    private String belowName; // 所属
    private String belowGrade; // 所属-级
    private Long serviceModeId; // 服务模式
    private String serviceModeName; // 服务模式名称
    private Integer serviceNum; // 服务周期
    private Long projectSetDepartmentId; // 立项部门
    private String projectSetDepartmentName; // 立项部门名称
    private Long projectStatusId; // 项目状态
    private String projectStatusName; // 项目状态名称
    private Long constructionNatureId; // 建设性质
    private String constructionNatureName; // 建设性质名称
    private BigDecimal totalInvestmentScale; // 总投资规模
    private Long projectManagementId; // 项目负责人
    private String projectManagementName; // 项目负责人名称
    private String projectManagementPhone; // 项目负责人联系方式
    private Long belongOrgId; // 所属单位
    private String belongOrgName; // 所属单位名称
    private String companyCode; // 公司代码
    private String area; // 项目地点
    private String constructionScale; // 建设规模
    private String otherRemark; // 其他说明
    private String projectOverview; // 工程概况
    private String projectFeasibility; // 项目建设的可行性和必要性
    private String mainConstructionScale; // 主要建设规模及内容
    private String investmentPlan; // 分期建设投资计划
    private String memo; // 备注
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }
    public Date getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(Date planFinishDate) {
        this.planFinishDate = planFinishDate;
    }
    public Integer getProjectCycleNum() {
        return projectCycleNum;
    }

    public void setProjectCycleNum(Integer projectCycleNum) {
        this.projectCycleNum = projectCycleNum;
    }
    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }
    public Integer getConstructionPeriodNum() {
        return constructionPeriodNum;
    }

    public void setConstructionPeriodNum(Integer constructionPeriodNum) {
        this.constructionPeriodNum = constructionPeriodNum;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    public String getBelowName() {
        return belowName;
    }

    public void setBelowName(String belowName) {
        this.belowName = belowName;
    }
    public String getBelowGrade() {
        return belowGrade;
    }

    public void setBelowGrade(String belowGrade) {
        this.belowGrade = belowGrade;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getServiceModeId() {
        return serviceModeId;
    }
    @ReferDeserialTransfer
    public void setServiceModeId(Long serviceModeId) {
        this.serviceModeId = serviceModeId;
    }
    public String getServiceModeName() {
        return serviceModeName;
    }

    public void setServiceModeName(String serviceModeName) {
        this.serviceModeName = serviceModeName;
    }
    public Integer getServiceNum() {
        return serviceNum;
    }

    public void setServiceNum(Integer serviceNum) {
        this.serviceNum = serviceNum;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getProjectSetDepartmentId() {
        return projectSetDepartmentId;
    }
    @ReferDeserialTransfer
    public void setProjectSetDepartmentId(Long projectSetDepartmentId) {
        this.projectSetDepartmentId = projectSetDepartmentId;
    }
    public String getProjectSetDepartmentName() {
        return projectSetDepartmentName;
    }

    public void setProjectSetDepartmentName(String projectSetDepartmentName) {
        this.projectSetDepartmentName = projectSetDepartmentName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectStatusId() {
        return projectStatusId;
    }
    @ReferDeserialTransfer
    public void setProjectStatusId(Long projectStatusId) {
        this.projectStatusId = projectStatusId;
    }
    public String getProjectStatusName() {
        return projectStatusName;
    }

    public void setProjectStatusName(String projectStatusName) {
        this.projectStatusName = projectStatusName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getConstructionNatureId() {
        return constructionNatureId;
    }
    @ReferDeserialTransfer
    public void setConstructionNatureId(Long constructionNatureId) {
        this.constructionNatureId = constructionNatureId;
    }
    public String getConstructionNatureName() {
        return constructionNatureName;
    }

    public void setConstructionNatureName(String constructionNatureName) {
        this.constructionNatureName = constructionNatureName;
    }
    public BigDecimal getTotalInvestmentScale() {
        return totalInvestmentScale;
    }

    public void setTotalInvestmentScale(BigDecimal totalInvestmentScale) {
        this.totalInvestmentScale = totalInvestmentScale;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectManagementId() {
        return projectManagementId;
    }
    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    public String getProjectManagementPhone() {
        return projectManagementPhone;
    }

    public void setProjectManagementPhone(String projectManagementPhone) {
        this.projectManagementPhone = projectManagementPhone;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getBelongOrgId() {
        return belongOrgId;
    }
    @ReferDeserialTransfer
    public void setBelongOrgId(Long belongOrgId) {
        this.belongOrgId = belongOrgId;
    }
    public String getBelongOrgName() {
        return belongOrgName;
    }

    public void setBelongOrgName(String belongOrgName) {
        this.belongOrgName = belongOrgName;
    }
    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getConstructionScale() {
        return constructionScale;
    }

    public void setConstructionScale(String constructionScale) {
        this.constructionScale = constructionScale;
    }
    public String getOtherRemark() {
        return otherRemark;
    }

    public void setOtherRemark(String otherRemark) {
        this.otherRemark = otherRemark;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public String getProjectFeasibility() {
        return projectFeasibility;
    }

    public void setProjectFeasibility(String projectFeasibility) {
        this.projectFeasibility = projectFeasibility;
    }
    public String getMainConstructionScale() {
        return mainConstructionScale;
    }

    public void setMainConstructionScale(String mainConstructionScale) {
        this.mainConstructionScale = mainConstructionScale;
    }
    public String getInvestmentPlan() {
        return investmentPlan;
    }

    public void setInvestmentPlan(String investmentPlan) {
        this.investmentPlan = investmentPlan;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
