package com.ejianc.business.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 年度投资计划
 * 
 * @author generator
 * 
 */
public class YearPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private String description; // 描述
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private String constructType; // 建设性质
    private Integer yearf; // 年度
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date sdate; // 开始日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date edate; // 结束日期
    private String constructContent; // 建设内容及规模
    private String biuledContent; // 本年计划完成内容
    private String constructer; // 责任单位
    private BigDecimal landDemand; // 总用地需求
    private BigDecimal totalMony; // 总投资额
    private BigDecimal topMoney; // 上级财政金额
    private BigDecimal selfMoney; // 企业自筹额
    private BigDecimal secondeMoney; // 本级财政金额
    private BigDecimal qtMoney; // 融资额
    private BigDecimal yearMoney; // 本年度计划投资额
    private BigDecimal yearTopMoney; // 本年上级财政金额
    private BigDecimal yearSelfMoney; // 本年企业自筹额
    private BigDecimal yearSecondeMoney; // 本年本级财政金额
    private BigDecimal yearQtMoney; // 本年融资额
    private BigDecimal totalMoney; // 累计投资额
    private String sourceDesc; // 资金来源说明
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    @ReferSerialTransfer(referCode="invest_project_set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getConstructType() {
        return constructType;
    }

    public void setConstructType(String constructType) {
        this.constructType = constructType;
    }
    public Integer getYearf() {
        return yearf;
    }

    public void setYearf(Integer yearf) {
        this.yearf = yearf;
    }
    public Date getSdate() {
        return sdate;
    }

    public void setSdate(Date sdate) {
        this.sdate = sdate;
    }
    public Date getEdate() {
        return edate;
    }

    public void setEdate(Date edate) {
        this.edate = edate;
    }
    public String getConstructContent() {
        return constructContent;
    }

    public void setConstructContent(String constructContent) {
        this.constructContent = constructContent;
    }
    public String getBiuledContent() {
        return biuledContent;
    }

    public void setBiuledContent(String biuledContent) {
        this.biuledContent = biuledContent;
    }
    public String getConstructer() {
        return constructer;
    }

    public void setConstructer(String constructer) {
        this.constructer = constructer;
    }
    public BigDecimal getLandDemand() {
        return landDemand;
    }

    public void setLandDemand(BigDecimal landDemand) {
        this.landDemand = landDemand;
    }
    public BigDecimal getTotalMony() {
        return totalMony;
    }

    public void setTotalMony(BigDecimal totalMony) {
        this.totalMony = totalMony;
    }
    public BigDecimal getTopMoney() {
        return topMoney;
    }

    public void setTopMoney(BigDecimal topMoney) {
        this.topMoney = topMoney;
    }
    public BigDecimal getSelfMoney() {
        return selfMoney;
    }

    public void setSelfMoney(BigDecimal selfMoney) {
        this.selfMoney = selfMoney;
    }
    public BigDecimal getSecondeMoney() {
        return secondeMoney;
    }

    public void setSecondeMoney(BigDecimal secondeMoney) {
        this.secondeMoney = secondeMoney;
    }
    public BigDecimal getQtMoney() {
        return qtMoney;
    }

    public void setQtMoney(BigDecimal qtMoney) {
        this.qtMoney = qtMoney;
    }
    public BigDecimal getYearMoney() {
        return yearMoney;
    }

    public void setYearMoney(BigDecimal yearMoney) {
        this.yearMoney = yearMoney;
    }
    public BigDecimal getYearTopMoney() {
        return yearTopMoney;
    }

    public void setYearTopMoney(BigDecimal yearTopMoney) {
        this.yearTopMoney = yearTopMoney;
    }
    public BigDecimal getYearSelfMoney() {
        return yearSelfMoney;
    }

    public void setYearSelfMoney(BigDecimal yearSelfMoney) {
        this.yearSelfMoney = yearSelfMoney;
    }
    public BigDecimal getYearSecondeMoney() {
        return yearSecondeMoney;
    }

    public void setYearSecondeMoney(BigDecimal yearSecondeMoney) {
        this.yearSecondeMoney = yearSecondeMoney;
    }
    public BigDecimal getYearQtMoney() {
        return yearQtMoney;
    }

    public void setYearQtMoney(BigDecimal yearQtMoney) {
        this.yearQtMoney = yearQtMoney;
    }
    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }
    public String getSourceDesc() {
        return sourceDesc;
    }

    public void setSourceDesc(String sourceDesc) {
        this.sourceDesc = sourceDesc;
    }
    
}
