package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目预算主实体
 * 
 * @author generator
 * 
 */
public class BudgetProjectProVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private BigDecimal budgetTaxMny; // 预算总金额（含税）
    private BigDecimal budgetMny; // 预算总金额(无税)
    private BigDecimal indirectionTaxMny; // 间接费(含税)
    private BigDecimal indirectionMny; // 间接费（无税）
    private BigDecimal laborTaxMny; // 人工费（含税）
    private BigDecimal laborMny; // 人工费（无税）
    private BigDecimal materialTaxMny; // 材料费（含税）
    private BigDecimal materialMny; // 材料费（无税）
    private BigDecimal majorTaxMny; // 专业费（含税）
    private BigDecimal majorMny; // 专业费（无税）
    private BigDecimal mechanicalTaxMny; // 机械费(含税 )
    private BigDecimal mechanicalMny; // 机械费（无税）
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer changeVersion; // 变更版本
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer billState; // 单据状态
    private String changeReason; // 变更原因
    private String memo; // 备注
    private String costTypeShow; // 备注
    private BigDecimal sporadicMaterialMny; // 零星材料费
    private List<BudgetProjectDetailProVO> detailList = new ArrayList<>(); // 项目预算清单明细

    private Integer estimateType; // 估算类型


    private String theme; // 名称

    private String engineeringNature; // 工程性质

    private String businessType; // 业态类型

    /**
     * 建筑面积(㎡)
     */
    private BigDecimal builtArea;
    /**
     * 估算单方造价
     */
    private BigDecimal estimatePerCost;

    private String designStage;

    public String getDesignStage() {
        return designStage;
    }

    public void setDesignStage(String designStage) {
        this.designStage = designStage;
    }

    public String getEngineeringNature() {
        return engineeringNature;
    }

    public void setEngineeringNature(String engineeringNature) {
        this.engineeringNature = engineeringNature;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getEstimatePerCost() {
        return estimatePerCost;
    }

    public void setEstimatePerCost(BigDecimal estimatePerCost) {
        this.estimatePerCost = estimatePerCost;
    }
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Integer getEstimateType() {
        return estimateType;
    }

    public void setEstimateType(Integer estimateType) {
        this.estimateType = estimateType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public BigDecimal getSporadicMaterialMny() {
        return sporadicMaterialMny;
    }

    public void setSporadicMaterialMny(BigDecimal sporadicMaterialMny) {
        this.sporadicMaterialMny = sporadicMaterialMny;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getIndirectionMny() {
        return indirectionMny;
    }

    public void setIndirectionMny(BigDecimal indirectionMny) {
        this.indirectionMny = indirectionMny;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getMajorMny() {
        return majorMny;
    }

    public void setMajorMny(BigDecimal majorMny) {
        this.majorMny = majorMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }

    public List<BudgetProjectDetailProVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetProjectDetailProVO> detailList) {
        this.detailList = detailList;
    }
}
