package com.ejianc.business.invest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 合约规划变更
 *
 * @author generator
 *
 */
public class ContractChangePlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private String name; // 合约规划名称
    private Long planId; // 原计划id
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private Long subjectId; // 科目名称
    private String subjectCode; // 科目编码
    private String subjectName; // 科目名称
    private BigDecimal targetCost; // 目标成本总额
    private String contractRule; // 控制规则
    private Long billTypeId; // 合同类型
    private String billTypeName; // 合同类型
    private String generalFlag; // 是否总包
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planDate; // 计划签约日期
    private BigDecimal planMny; // 合约规划金额
    private String bidWay; // 招标方式
    private String contractScope; // 合约范围
    private String contractDesc; // 合约说明

    private BigDecimal beforePlanMny; // 变更前合约规划金额

    private Date effectiveDate;

    private String changeReason; // 变更原因

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }


    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BigDecimal getBeforePlanMny() {
        return beforePlanMny;
    }

    public void setBeforePlanMny(BigDecimal beforePlanMny) {
        this.beforePlanMny = beforePlanMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "invest-budgetProjectDetail")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTargetCost() {
        return targetCost;
    }

    public void setTargetCost(BigDecimal targetCost) {
        this.targetCost = targetCost;
    }

    public String getContractRule() {
        return contractRule;
    }

    public void setContractRule(String contractRule) {
        this.contractRule = contractRule;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBillTypeId() {
        return billTypeId;
    }

    @ReferDeserialTransfer
    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getGeneralFlag() {
        return generalFlag;
    }

    public void setGeneralFlag(String generalFlag) {
        this.generalFlag = generalFlag;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }

    public String getBidWay() {
        return bidWay;
    }

    public void setBidWay(String bidWay) {
        this.bidWay = bidWay;
    }

    public String getContractScope() {
        return contractScope;
    }

    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }

    public String getContractDesc() {
        return contractDesc;
    }

    public void setContractDesc(String contractDesc) {
        this.contractDesc = contractDesc;
    }

}
