/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.schedule;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.jobbean.RemoteHttpJobBean;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.thread.JobFailMonitorHelper;
import com.xxl.job.admin.core.thread.JobRegistryMonitorHelper;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.call.CallType;
import com.xxl.rpc.remoting.invoker.reference.XxlRpcReferenceBean;
import com.xxl.rpc.remoting.invoker.route.LoadBalance;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.net.impl.servlet.server.ServletServerHandler;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.serialize.Serializer;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class XxlJobDynamicScheduler {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobDynamicScheduler.class);
    private static Scheduler scheduler;
    private static ServletServerHandler servletServerHandler;
    private static ConcurrentHashMap<String, ExecutorBiz> executorBizRepository;

    public void setScheduler(Scheduler scheduler) {
        XxlJobDynamicScheduler.scheduler = scheduler;
    }

    public void start() throws Exception {
        Assert.notNull((Object)scheduler, (String)"quartz scheduler is null");
        this.initI18n();
        JobRegistryMonitorHelper.getInstance().start();
        JobFailMonitorHelper.getInstance().start();
        this.initRpcProvider();
        logger.info(">>>>>>>>> init xxl-job admin success.");
    }

    public void destroy() throws Exception {
        JobTriggerPoolHelper.toStop();
        JobRegistryMonitorHelper.getInstance().toStop();
        JobFailMonitorHelper.getInstance().toStop();
        this.stopRpcProvider();
    }

    private void initI18n() {
        for (ExecutorBlockStrategyEnum item : ExecutorBlockStrategyEnum.values()) {
            item.setTitle(I18nUtil.getString("jobconf_block_".concat(item.name())));
        }
    }

    private void initRpcProvider() {
        XxlRpcProviderFactory xxlRpcProviderFactory = new XxlRpcProviderFactory();
        xxlRpcProviderFactory.initConfig(NetEnum.NETTY_HTTP, Serializer.SerializeEnum.HESSIAN.getSerializer(), null, 0, XxlJobAdminConfig.getAdminConfig().getAccessToken(), null, null);
        xxlRpcProviderFactory.addService(AdminBiz.class.getName(), null, (Object)XxlJobAdminConfig.getAdminConfig().getAdminBiz());
        servletServerHandler = new ServletServerHandler(xxlRpcProviderFactory);
    }

    private void stopRpcProvider() throws Exception {
        XxlRpcInvokerFactory.getInstance().stop();
    }

    public static void invokeAdminService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        servletServerHandler.handle(null, request, response);
    }

    public static ExecutorBiz getExecutorBiz(String address) throws Exception {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        ExecutorBiz executorBiz = executorBizRepository.get(address = address.trim());
        if (executorBiz != null) {
            return executorBiz;
        }
        executorBiz = (ExecutorBiz)new XxlRpcReferenceBean(NetEnum.NETTY_HTTP, Serializer.SerializeEnum.HESSIAN.getSerializer(), CallType.SYNC, LoadBalance.ROUND, ExecutorBiz.class, null, 5000L, address, XxlJobAdminConfig.getAdminConfig().getAccessToken(), null, null).getObject();
        executorBizRepository.put(address, executorBiz);
        return executorBiz;
    }

    public static void fillJobInfo(XxlJobInfo jobInfo) {
        String name = String.valueOf(jobInfo.getId());
        TriggerKey triggerKey = TriggerKey.triggerKey((String)name);
        try {
            Trigger.TriggerState triggerState;
            Trigger trigger = scheduler.getTrigger(triggerKey);
            if (trigger != null && trigger instanceof CronTriggerImpl) {
                String cronExpression = ((CronTriggerImpl)trigger).getCronExpression();
                jobInfo.setJobCron(cronExpression);
            }
            if ((triggerState = scheduler.getTriggerState(triggerKey)) != null) {
                jobInfo.setJobStatus(triggerState.name());
            }
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean addJob(String jobName, String cronExpression) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName);
        JobKey jobKey = new JobKey(jobName);
        if (scheduler.checkExists(triggerKey)) {
            return true;
        }
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing();
        CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        Class<RemoteHttpJobBean> jobClass_ = RemoteHttpJobBean.class;
        JobDetail jobDetail = JobBuilder.newJob(jobClass_).withIdentity(jobKey).build();
        Date date = scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        logger.info(">>>>>>>>>>> addJob success(quartz), jobDetail:{}, cronTrigger:{}, date:{}", new Object[]{jobDetail, cronTrigger, date});
        return true;
    }

    public static boolean removeJob(String jobName) throws SchedulerException {
        JobKey jobKey = new JobKey(jobName);
        scheduler.deleteJob(jobKey);
        logger.info(">>>>>>>>>>> removeJob success(quartz), jobKey:{}", (Object)jobKey);
        return true;
    }

    public static boolean updateJobCron(String jobName, String cronExpression) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName);
        if (!scheduler.checkExists(triggerKey)) {
            return true;
        }
        CronTrigger oldTrigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        String oldCron = oldTrigger.getCronExpression();
        if (oldCron.equals(cronExpression)) {
            return true;
        }
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing();
        oldTrigger = (CronTrigger)oldTrigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        scheduler.rescheduleJob(triggerKey, (Trigger)oldTrigger);
        logger.info(">>>>>>>>>>> resumeJob success, JobName:{}", (Object)jobName);
        return true;
    }

    static {
        executorBizRepository = new ConcurrentHashMap();
    }
}

