/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobRegistry;
import com.xxl.job.core.enums.RegistryConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRegistryMonitorHelper {
    private static Logger logger = LoggerFactory.getLogger(JobRegistryMonitorHelper.class);
    private static JobRegistryMonitorHelper instance = new JobRegistryMonitorHelper();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static JobRegistryMonitorHelper getInstance() {
        return instance;
    }

    public void start() {
        this.registryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobRegistryMonitorHelper.this.toStop) {
                    block13: {
                        try {
                            String dbType = XxlJobAdminConfig.getAdminConfig().getDbType();
                            List<XxlJobGroup> groupList = XxlJobAdminConfig.getAdminConfig().getXxlJobGroupDao().findByAddressType(0);
                            if (groupList != null && !groupList.isEmpty()) {
                                XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().removeDead(90, dbType);
                                HashMap appAddressMap = new HashMap();
                                List<XxlJobRegistry> list = XxlJobAdminConfig.getAdminConfig().getXxlJobRegistryDao().findAll(90, dbType);
                                if (list != null) {
                                    for (XxlJobRegistry item : list) {
                                        if (!RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) continue;
                                        String appName = item.getRegistryKey();
                                        ArrayList<String> registryList = (ArrayList<String>)appAddressMap.get(appName);
                                        if (registryList == null) {
                                            registryList = new ArrayList<String>();
                                        }
                                        if (!registryList.contains(item.getRegistryValue())) {
                                            registryList.add(item.getRegistryValue());
                                        }
                                        appAddressMap.put(appName, registryList);
                                    }
                                }
                                for (XxlJobGroup group : groupList) {
                                    List registryList = (List)appAddressMap.get(group.getAppName());
                                    String addressListStr = null;
                                    if (registryList != null && !registryList.isEmpty()) {
                                        Collections.sort(registryList);
                                        addressListStr = "";
                                        for (String item : registryList) {
                                            addressListStr = addressListStr + item + ",";
                                        }
                                        addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
                                    }
                                    group.setAddressList(addressListStr);
                                    XxlJobAdminConfig.getAdminConfig().getXxlJobGroupDao().update(group);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (JobRegistryMonitorHelper.this.toStop) break block13;
                            logger.error(">>>>>>>>>>> xxl-job, job registry monitor thread error:{}", (Throwable)e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        if (JobRegistryMonitorHelper.this.toStop) continue;
                        logger.error(">>>>>>>>>>> xxl-job, job registry monitor thread error:{}", (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, job registry monitor thread stop");
            }
        });
        this.registryThread.setDaemon(true);
        this.registryThread.setName("xxl-job, admin JobRegistryMonitorHelper");
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryThread.interrupt();
        try {
            this.registryThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

