package com.xxl.job.admin.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.CommonResponse;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import com.xxl.job.admin.core.schedule.XxlJobDynamicScheduler;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.LogResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * index controller
 * @author xuxueli 2015-12-19 16:13:16
 */
@Controller
@RequestMapping("api/jobinfo")
public class JobInfoApi {

	@Resource
	private XxlJobService xxlJobService;
	@Resource
	private XxlJobInfoDao xxlJobInfoDao;
	@Resource
	public XxlJobGroupDao xxlJobGroupDao;
	@Resource
	public XxlJobLogDao xxlJobLogDao;

	@PostMapping("/add")
	@ResponseBody
	public CommonResponse<XxlJobInfo> add(@RequestBody XxlJobInfo jobInfo) {
		ReturnT<String> addResponse = xxlJobService.add(jobInfo);
		if(addResponse.getCode() == ReturnT.SUCCESS_CODE){
			XxlJobInfo info = xxlJobInfoDao.loadById(Integer.parseInt(addResponse.getContent()));
			return CommonResponse.success(info);
		}
		return CommonResponse.error(addResponse.getMsg());
	}

	@PostMapping("/update")
	@ResponseBody
	public CommonResponse<String> update(@RequestBody XxlJobInfo jobInfo) {
		ReturnT<String> addResponse =  xxlJobService.update(jobInfo);
		if(addResponse.getCode() == ReturnT.SUCCESS_CODE){
			return CommonResponse.success(addResponse.getMsg());
		}
		return CommonResponse.error(addResponse.getMsg());
	}

	@GetMapping("/triggerJob")
	@ResponseBody
	public CommonResponse<String> triggerJob(@RequestParam int id,@RequestParam String executorParam) {
		// force cover job param
		if (executorParam == null) {
			executorParam = "";
		}
		JobTriggerPoolHelper.trigger(id, TriggerTypeEnum.MANUAL, -1, null, executorParam);
		return CommonResponse.success("执行成功");
	}

	@GetMapping("/queryOne")
	@ResponseBody
	public CommonResponse<XxlJobInfo> queryOne(@RequestParam Integer id) {
		XxlJobInfo info = xxlJobInfoDao.loadById(id);
		if(info != null){
			return CommonResponse.success(info);
		}
		return CommonResponse.error("调度任务不存在");
	}

	@GetMapping("/remove")
	@ResponseBody
	public CommonResponse<String> remove(@RequestParam Integer id){
		ReturnT<String> removeResponse =   xxlJobService.remove(id);
		if(removeResponse.getCode() == ReturnT.SUCCESS_CODE){
			return CommonResponse.success(removeResponse.getMsg());
		}
		return CommonResponse.error(removeResponse.getMsg());
	}
	
	@GetMapping("/stop")
	@ResponseBody
	public CommonResponse<String> stop(@RequestParam Integer id) {
		ReturnT<String> stopResponse =  xxlJobService.stop(id);
		if(stopResponse.getCode() == ReturnT.SUCCESS_CODE){
			return CommonResponse.success(stopResponse.getMsg());
		}
		return CommonResponse.error(stopResponse.getMsg());
	}
	
	@GetMapping("/start")
	@ResponseBody
	public CommonResponse<String> start(@RequestParam Integer id) {
		 ReturnT<String> startResponse = xxlJobService.start(id);
		 if(startResponse.getCode() == ReturnT.SUCCESS_CODE){
			 return CommonResponse.success(startResponse.getMsg());
		 }
		 return CommonResponse.error(startResponse.getMsg());
	}


	/**
	 * 新增调度任务执行器
	 *
	 * @return
	 */
	@PostMapping("/addGroup")
	@ResponseBody
	public CommonResponse<XxlJobGroup> addGroup(@RequestBody XxlJobGroup xxlJobGroup){
		if (xxlJobGroup.getAppName()==null || xxlJobGroup.getAppName().trim().isEmpty()) {
			return CommonResponse.error(I18nUtil.getString("system_please_input"));
		}
		if (xxlJobGroup.getAppName().length()<4 || xxlJobGroup.getAppName().length()>64) {
			return CommonResponse.error(I18nUtil.getString("jobgroup_field_appName_length") );
		}
		if (xxlJobGroup.getTitle()==null || xxlJobGroup.getTitle().trim().isEmpty()) {
			return CommonResponse.error(I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
		}
		if (xxlJobGroup.getAddressType()!=0) {
			if (xxlJobGroup.getAddressList()==null || xxlJobGroup.getAddressList().trim().isEmpty()) {
				return CommonResponse.error(I18nUtil.getString("jobgroup_field_addressType_limit") );
			}
			String[] addresss = xxlJobGroup.getAddressList().split(",");
			for (String item: addresss) {
				if (item==null || item.trim().isEmpty()) {
					return CommonResponse.error(I18nUtil.getString("jobgroup_field_registryList_unvalid") );
				}
			}
		}
		xxlJobGroupDao.save(xxlJobGroup);
		if (xxlJobGroup.getId() < 1) {
			return CommonResponse.error("新增执行器失败！" );
		}
		return CommonResponse.success(xxlJobGroup);
	}


	/**
	 * 更新调度任务执行器
	 *
	 * @return
	 */
	@PostMapping("/updateGroup")
	@ResponseBody
	public CommonResponse<String> updateGroup(@RequestBody XxlJobGroup xxlJobGroup){
		if (xxlJobGroup.getAppName()==null || xxlJobGroup.getAppName().trim().isEmpty()) {
			return CommonResponse.error(I18nUtil.getString("system_please_input"));
		}
		if (xxlJobGroup.getAppName().length()<4 || xxlJobGroup.getAppName().length()>64) {
			return CommonResponse.error(I18nUtil.getString("jobgroup_field_appName_length") );
		}
		if (xxlJobGroup.getTitle()==null || xxlJobGroup.getTitle().trim().isEmpty()) {
			return CommonResponse.error(I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title"));
		}
		if (xxlJobGroup.getAddressType()!=0) {
			if (xxlJobGroup.getAddressList()==null || xxlJobGroup.getAddressList().trim().isEmpty()) {
				return CommonResponse.error(I18nUtil.getString("jobgroup_field_addressType_limit") );
			}
			String[] addresss = xxlJobGroup.getAddressList().split(",");
			for (String item: addresss) {
				if (item==null || item.trim().isEmpty()) {
					return CommonResponse.error(I18nUtil.getString("jobgroup_field_registryList_unvalid") );
				}
			}
		}
		int ret = xxlJobGroupDao.update(xxlJobGroup);
		if (ret < 1) {
			return CommonResponse.error("更新执行器失败！" );
		}
		return CommonResponse.success("更新执行器成功！");
	}

	/**
	 * 查询执行器列表
	 *
	 * @return
	 */
	@GetMapping("/queryGroupList")
	@ResponseBody
	public CommonResponse<List<XxlJobGroup>> queryGroupList(){
		List<XxlJobGroup> list = xxlJobGroupDao.findAll();
		return CommonResponse.success(list);
	}

	/**
	 * 查询执行器列表
	 *
	 * @return
	 */
	@GetMapping("/removeGroup")
	@ResponseBody
	public CommonResponse<String> removeGroup(@RequestParam Integer id){

		// valid
		int count = xxlJobInfoDao.pageListCount(0, 10, id, null, null);
		if (count > 0) {
			return CommonResponse.error(I18nUtil.getString("jobgroup_del_limit_0") );
		}

		List<XxlJobGroup> allList = xxlJobGroupDao.findAll();
		if (allList.size() == 1) {
			return CommonResponse.error( I18nUtil.getString("jobgroup_del_limit_1") );
		}

		int ret = xxlJobGroupDao.remove(id);
		return (ret>0)?CommonResponse.success("删除成功！"):CommonResponse.error("删除失败！");
	}


	@GetMapping("/pageLogList")
	@ResponseBody
	public CommonResponse<Page<XxlJobLog>> pageLogList(@RequestParam(required = false, defaultValue = "1") int pageIndex,
										@RequestParam(required = false, defaultValue = "10") int pageSize,
										@RequestParam int jobGroup,
										@RequestParam int jobId,
										@RequestParam int logStatus,
										@RequestParam(required = false) String filterTime) {

		// parse param
		Date triggerTimeStart = null;
		Date triggerTimeEnd = null;
		if (filterTime!=null && filterTime.trim().length()>0) {
			String[] temp = filterTime.split(",");
			if (temp.length == 2) {
				triggerTimeStart = DateUtil.parseDateTime(temp[0]);
				triggerTimeEnd = DateUtil.parseDateTime(temp[1]);
			}
		}
		int start = (pageIndex-1)*pageSize;
		// page query
		List<XxlJobLog> list = xxlJobLogDao.pageList(start, pageSize, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
		int list_count = xxlJobLogDao.pageListCount(start, pageSize, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
		Page<XxlJobLog> page = new Page<>(pageIndex, pageSize, list_count);
		page.setRecords(list);
		return CommonResponse.success(page);
	}

	/**
	 * 查询执行日志详情
	 *
	 * @param executorAddress 执行器地址
	 * @param triggerTime     触发时间
	 * @param logId           日志ID
	 * @param fromLineNum     从行数
	 * @return
	 */
	@RequestMapping("/logDetailCat")
	@ResponseBody
	public CommonResponse<String> logDetailCat(@RequestParam String executorAddress,
											   @RequestParam long triggerTime,
											   @RequestParam int logId,
											   @RequestParam int fromLineNum){
		try {
			ExecutorBiz executorBiz = XxlJobDynamicScheduler.getExecutorBiz(executorAddress);
			ReturnT<LogResult> logResult = executorBiz.log(triggerTime, logId, fromLineNum);
			if (logResult.getContent()!=null && logResult.getContent().getFromLineNum() > logResult.getContent().getToLineNum()) {
				XxlJobLog jobLog = xxlJobLogDao.load(logId);
				if (jobLog.getHandleCode() > 0) {
					logResult.getContent().setEnd(true);
				}
			}
			return CommonResponse.success("查询成功！",logResult.getContent().getLogContent());
		} catch (Exception e) {
			return CommonResponse.error( e.getMessage());
		}
	}

	/**
	 * 获取调度任务统计信息
	 *
	 * @return
	 */
	@RequestMapping("/dashboardInfo")
	@ResponseBody
	public CommonResponse<Map<String,Object>> dashboardInfo(){
		return CommonResponse.success(xxlJobService.dashboardInfo());
	}

	/**
	 * 获取调度任务统计信息
	 *
	 * @return
	 */
	@RequestMapping("/pieAndBarInfo")
	@ResponseBody
	public CommonResponse<Map<String,Object>> pieAndBarInfo(@RequestParam String startDateStr,@RequestParam String endDateStr){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date startDate = sdf.parse(startDateStr);
			Date endDate = sdf.parse(endDateStr);
			ReturnT<Map<String, Object>> chartInfo = xxlJobService.chartInfo(startDate, endDate);
			return CommonResponse.success(chartInfo.getContent());
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}
}
