/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.route.ExecutorRouteStrategyEnum;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobinfo"})
public class JobInfoController {
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobService xxlJobService;

    @RequestMapping
    public String index(Model model, @RequestParam(required=false, defaultValue="-1") int jobGroup) {
        model.addAttribute("ExecutorRouteStrategyEnum", (Object)ExecutorRouteStrategyEnum.values());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("ExecutorBlockStrategyEnum", (Object)ExecutorBlockStrategyEnum.values());
        List<XxlJobGroup> jobGroupList = this.xxlJobGroupDao.findAll();
        model.addAttribute("JobGroupList", jobGroupList);
        model.addAttribute("jobGroup", (Object)jobGroup);
        return "jobinfo/jobinfo.index";
    }

    @RequestMapping(value={"/pageList"})
    @ResponseBody
    public Map<String, Object> pageList(@RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, int jobGroup, String jobDesc, String executorHandler, String filterTime) {
        return this.xxlJobService.pageList(start, length, jobGroup, jobDesc, executorHandler, filterTime);
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        return this.xxlJobService.add(jobInfo);
    }

    @RequestMapping(value={"/webinsert"})
    @ResponseBody
    public ReturnT<String> webInsert(@RequestBody XxlJobInfo jobInfo) {
        XxlJobInfo uniqueBean = this.xxlJobService.loadBySourceId(jobInfo.getSourceid());
        if (uniqueBean != null) {
            uniqueBean.setJobCron(jobInfo.getJobCron());
            uniqueBean.setExecutorParam(jobInfo.getExecutorParam());
            return this.xxlJobService.update(uniqueBean);
        }
        jobInfo.setJobGroup(1);
        jobInfo.setExecutorRouteStrategy("FIRST");
        jobInfo.setGlueType("BEAN");
        jobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        jobInfo.setExecutorTimeout(0);
        jobInfo.setExecutorFailRetryCount(0);
        jobInfo.setAuthor("\u90ed\u660e");
        jobInfo.setAlarmEmail("450321726@qq.com");
        ReturnT<String> saveResponse = this.xxlJobService.add(jobInfo);
        this.xxlJobService.start(Integer.parseInt((String)saveResponse.getContent()));
        return saveResponse;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        return this.xxlJobService.update(jobInfo);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ReturnT<String> remove(int id) {
        return this.xxlJobService.remove(id);
    }

    @RequestMapping(value={"/stop"})
    @ResponseBody
    public ReturnT<String> pause(int id) {
        return this.xxlJobService.stop(id);
    }

    @RequestMapping(value={"/start"})
    @ResponseBody
    public ReturnT<String> start(int id) {
        return this.xxlJobService.start(id);
    }

    @RequestMapping(value={"/trigger"})
    @ResponseBody
    public ReturnT<String> triggerJob(int id, String executorParam) {
        if (executorParam == null) {
            executorParam = "";
        }
        JobTriggerPoolHelper.trigger(id, TriggerTypeEnum.MANUAL, -1, null, executorParam);
        return ReturnT.SUCCESS;
    }
}

