/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.CommonResponse;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import com.xxl.job.admin.core.schedule.XxlJobDynamicScheduler;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.LogResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/jobinfo"})
public class JobInfoApi {
    @Resource
    private XxlJobService xxlJobService;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;

    @PostMapping(value={"/add"})
    @ResponseBody
    public CommonResponse<XxlJobInfo> add(@RequestBody XxlJobInfo jobInfo) {
        ReturnT<String> addResponse = this.xxlJobService.add(jobInfo);
        if (addResponse.getCode() == 200) {
            XxlJobInfo info = this.xxlJobInfoDao.loadById(Integer.parseInt((String)addResponse.getContent()));
            return CommonResponse.success((Object)info);
        }
        return CommonResponse.error((String)addResponse.getMsg());
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    public CommonResponse<String> update(@RequestBody XxlJobInfo jobInfo) {
        ReturnT<String> addResponse = this.xxlJobService.update(jobInfo);
        if (addResponse.getCode() == 200) {
            return CommonResponse.success((String)addResponse.getMsg());
        }
        return CommonResponse.error((String)addResponse.getMsg());
    }

    @GetMapping(value={"/triggerJob"})
    @ResponseBody
    public CommonResponse<String> triggerJob(@RequestParam int id, @RequestParam String executorParam) {
        if (executorParam == null) {
            executorParam = "";
        }
        JobTriggerPoolHelper.trigger(id, TriggerTypeEnum.MANUAL, -1, null, executorParam);
        return CommonResponse.success((String)"\u6267\u884c\u6210\u529f");
    }

    @GetMapping(value={"/queryOne"})
    @ResponseBody
    public CommonResponse<XxlJobInfo> queryOne(@RequestParam Integer id) {
        XxlJobInfo info = this.xxlJobInfoDao.loadById(id);
        if (info != null) {
            return CommonResponse.success((Object)info);
        }
        return CommonResponse.error((String)"\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/remove"})
    @ResponseBody
    public CommonResponse<String> remove(@RequestParam Integer id) {
        ReturnT<String> removeResponse = this.xxlJobService.remove(id);
        if (removeResponse.getCode() == 200) {
            return CommonResponse.success((String)removeResponse.getMsg());
        }
        return CommonResponse.error((String)removeResponse.getMsg());
    }

    @GetMapping(value={"/stop"})
    @ResponseBody
    public CommonResponse<String> stop(@RequestParam Integer id) {
        ReturnT<String> stopResponse = this.xxlJobService.stop(id);
        if (stopResponse.getCode() == 200) {
            return CommonResponse.success((String)stopResponse.getMsg());
        }
        return CommonResponse.error((String)stopResponse.getMsg());
    }

    @GetMapping(value={"/start"})
    @ResponseBody
    public CommonResponse<String> start(@RequestParam Integer id) {
        ReturnT<String> startResponse = this.xxlJobService.start(id);
        if (startResponse.getCode() == 200) {
            return CommonResponse.success((String)startResponse.getMsg());
        }
        return CommonResponse.error((String)startResponse.getMsg());
    }

    @PostMapping(value={"/addGroup"})
    @ResponseBody
    public CommonResponse<XxlJobGroup> addGroup(@RequestBody XxlJobGroup xxlJobGroup) {
        if (xxlJobGroup.getAppName() == null || xxlJobGroup.getAppName().trim().isEmpty()) {
            return CommonResponse.error((String)I18nUtil.getString("system_please_input"));
        }
        if (xxlJobGroup.getAppName().length() < 4 || xxlJobGroup.getAppName().length() > 64) {
            return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_appName_length"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().isEmpty()) {
            return CommonResponse.error((String)(I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title")));
        }
        if (xxlJobGroup.getAddressType() != 0) {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().isEmpty()) {
                return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && !item.trim().isEmpty()) continue;
                return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        this.xxlJobGroupDao.save(xxlJobGroup);
        if (xxlJobGroup.getId() < 1) {
            return CommonResponse.error((String)"\u65b0\u589e\u6267\u884c\u5668\u5931\u8d25\uff01");
        }
        return CommonResponse.success((Object)xxlJobGroup);
    }

    @PostMapping(value={"/updateGroup"})
    @ResponseBody
    public CommonResponse<String> updateGroup(@RequestBody XxlJobGroup xxlJobGroup) {
        int ret;
        if (xxlJobGroup.getAppName() == null || xxlJobGroup.getAppName().trim().isEmpty()) {
            return CommonResponse.error((String)I18nUtil.getString("system_please_input"));
        }
        if (xxlJobGroup.getAppName().length() < 4 || xxlJobGroup.getAppName().length() > 64) {
            return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_appName_length"));
        }
        if (xxlJobGroup.getTitle() == null || xxlJobGroup.getTitle().trim().isEmpty()) {
            return CommonResponse.error((String)(I18nUtil.getString("system_please_input") + I18nUtil.getString("jobgroup_field_title")));
        }
        if (xxlJobGroup.getAddressType() != 0) {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().isEmpty()) {
                return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_addressType_limit"));
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && !item.trim().isEmpty()) continue;
                return CommonResponse.error((String)I18nUtil.getString("jobgroup_field_registryList_unvalid"));
            }
        }
        if ((ret = this.xxlJobGroupDao.update(xxlJobGroup)) < 1) {
            return CommonResponse.error((String)"\u66f4\u65b0\u6267\u884c\u5668\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u6267\u884c\u5668\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryGroupList"})
    @ResponseBody
    public CommonResponse<List<XxlJobGroup>> queryGroupList() {
        List<XxlJobGroup> list = this.xxlJobGroupDao.findAll();
        return CommonResponse.success(list);
    }

    @GetMapping(value={"/removeGroup"})
    @ResponseBody
    public CommonResponse<String> removeGroup(@RequestParam Integer id) {
        int count = this.xxlJobInfoDao.pageListCount(0, 10, id, null, null);
        if (count > 0) {
            return CommonResponse.error((String)I18nUtil.getString("jobgroup_del_limit_0"));
        }
        List<XxlJobGroup> allList = this.xxlJobGroupDao.findAll();
        if (allList.size() == 1) {
            return CommonResponse.error((String)I18nUtil.getString("jobgroup_del_limit_1"));
        }
        int ret = this.xxlJobGroupDao.remove(id);
        return ret > 0 ? CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01") : CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/pageLogList"})
    @ResponseBody
    public CommonResponse<Page<XxlJobLog>> pageLogList(@RequestParam(required=false, defaultValue="1") int pageIndex, @RequestParam(required=false, defaultValue="10") int pageSize, @RequestParam int jobGroup, @RequestParam int jobId, @RequestParam int logStatus, @RequestParam(required=false) String filterTime) {
        String[] temp;
        Date triggerTimeStart = null;
        Date triggerTimeEnd = null;
        if (filterTime != null && filterTime.trim().length() > 0 && (temp = filterTime.split(",")).length == 2) {
            triggerTimeStart = DateUtil.parseDateTime((String)temp[0]);
            triggerTimeEnd = DateUtil.parseDateTime((String)temp[1]);
        }
        int start = (pageIndex - 1) * pageSize;
        List<XxlJobLog> list = this.xxlJobLogDao.pageList(start, pageSize, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
        int list_count = this.xxlJobLogDao.pageListCount(start, pageSize, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
        Page page = new Page((long)pageIndex, (long)pageSize, (long)list_count);
        page.setRecords(list);
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/logDetailCat"})
    @ResponseBody
    public CommonResponse<String> logDetailCat(@RequestParam String executorAddress, @RequestParam long triggerTime, @RequestParam int logId, @RequestParam int fromLineNum) {
        try {
            XxlJobLog jobLog;
            ExecutorBiz executorBiz = XxlJobDynamicScheduler.getExecutorBiz(executorAddress);
            ReturnT logResult = executorBiz.log(triggerTime, logId, fromLineNum);
            if (logResult.getContent() != null && ((LogResult)logResult.getContent()).getFromLineNum() > ((LogResult)logResult.getContent()).getToLineNum() && (jobLog = this.xxlJobLogDao.load(logId)).getHandleCode() > 0) {
                ((LogResult)logResult.getContent()).setEnd(true);
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((LogResult)logResult.getContent()).getLogContent());
        }
        catch (Exception e) {
            return CommonResponse.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/dashboardInfo"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> dashboardInfo() {
        return CommonResponse.success(this.xxlJobService.dashboardInfo());
    }

    @RequestMapping(value={"/pieAndBarInfo"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> pieAndBarInfo(@RequestParam String startDateStr, @RequestParam String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date startDate = sdf.parse(startDateStr);
            Date endDate = sdf.parse(endDateStr);
            ReturnT<Map<String, Object>> chartInfo = this.xxlJobService.chartInfo(startDate, endDate);
            return CommonResponse.success((Object)chartInfo.getContent());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

