/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getInstance() {
        return objectMapper;
    }

    public static String writeValueAsString(Object obj) {
        try {
            return JacksonUtil.getInstance().writeValueAsString(obj);
        }
        catch (JsonGenerationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T readValue(String jsonStr, Class<T> clazz) {
        try {
            return (T)JacksonUtil.getInstance().readValue(jsonStr, clazz);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static <T> T readValue(String jsonStr, Class<?> parametrized, Class<?> ... parameterClasses) {
        try {
            JavaType javaType = JacksonUtil.getInstance().getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)JacksonUtil.getInstance().readValue(jsonStr, javaType);
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("aaa", "111");
            map.put("bbb", "222");
            String json = JacksonUtil.writeValueAsString(map);
            System.out.println(json);
            System.out.println(JacksonUtil.readValue(json, Map.class));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

