/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.service.impl;

import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.route.ExecutorRouteStrategyEnum;
import com.xxl.job.admin.core.schedule.XxlJobDynamicScheduler;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.admin.dao.XxlJobLogGlueDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static Logger logger = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;
    private static final String TRIGGER_CHART_DATA_CACHE = "trigger_chart_data_cache";

    @Override
    public Map<String, Object> pageList(int start, int length, int jobGroup, String jobDesc, String executorHandler, String filterTime) {
        List<XxlJobInfo> list = this.xxlJobInfoDao.pageList(start, length, jobGroup, jobDesc, executorHandler);
        int list_count = this.xxlJobInfoDao.pageListCount(start, length, jobGroup, jobDesc, executorHandler);
        if (list != null && list.size() > 0) {
            for (XxlJobInfo jobInfo : list) {
                XxlJobDynamicScheduler.fillJobInfo(jobInfo);
            }
        }
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    @Override
    public ReturnT<String> add(XxlJobInfo jobInfo) {
        XxlJobGroup group = this.xxlJobGroupDao.load(jobInfo.getJobGroup());
        if (group == null) {
            return new ReturnT(500, I18nUtil.getString("system_please_choose") + I18nUtil.getString("jobinfo_field_jobgroup"));
        }
        if (!CronExpression.isValidExpression((String)jobInfo.getJobCron())) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_cron_unvalid"));
        }
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_author"));
        }
        if (ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorRouteStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorBlockStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (GlueTypeEnum.match((String)jobInfo.getGlueType()) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_gluetype") + I18nUtil.getString("system_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match((String)jobInfo.getGlueType()) && (jobInfo.getExecutorHandler() == null || jobInfo.getExecutorHandler().trim().length() == 0)) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + "JobHandler");
        }
        if (GlueTypeEnum.GLUE_SHELL == GlueTypeEnum.match((String)jobInfo.getGlueType()) && jobInfo.getGlueSource() != null) {
            jobInfo.setGlueSource(jobInfo.getGlueSource().replaceAll("\r", ""));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.valueOf(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        this.xxlJobInfoDao.save(jobInfo);
        if (jobInfo.getId() < 1) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_add") + I18nUtil.getString("system_fail"));
        }
        return new ReturnT((Object)String.valueOf(jobInfo.getId()));
    }

    private boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        XxlJobGroup jobGroup;
        if (!CronExpression.isValidExpression((String)jobInfo.getJobCron())) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_cron_unvalid"));
        }
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_jobdesc"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("system_please_input") + I18nUtil.getString("jobinfo_field_author"));
        }
        if (ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorRouteStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_executorBlockStrategy") + I18nUtil.getString("system_unvalid"));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.valueOf(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_not_found"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString("jobinfo_field_childJobId") + "({0})" + I18nUtil.getString("system_unvalid"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        if ((jobGroup = this.xxlJobGroupDao.load(jobInfo.getJobGroup())) == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_jobgroup") + I18nUtil.getString("system_unvalid"));
        }
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(jobInfo.getId());
        if (exists_jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_id") + I18nUtil.getString("system_not_found"));
        }
        exists_jobInfo.setJobGroup(jobInfo.getJobGroup());
        exists_jobInfo.setJobCron(jobInfo.getJobCron());
        exists_jobInfo.setJobDesc(jobInfo.getJobDesc());
        exists_jobInfo.setAuthor(jobInfo.getAuthor());
        exists_jobInfo.setAlarmEmail(jobInfo.getAlarmEmail());
        exists_jobInfo.setExecutorRouteStrategy(jobInfo.getExecutorRouteStrategy());
        exists_jobInfo.setExecutorHandler(jobInfo.getExecutorHandler());
        exists_jobInfo.setExecutorParam(jobInfo.getExecutorParam());
        exists_jobInfo.setExecutorBlockStrategy(jobInfo.getExecutorBlockStrategy());
        exists_jobInfo.setExecutorTimeout(jobInfo.getExecutorTimeout());
        exists_jobInfo.setExecutorFailRetryCount(jobInfo.getExecutorFailRetryCount());
        exists_jobInfo.setChildJobId(jobInfo.getChildJobId());
        this.xxlJobInfoDao.update(exists_jobInfo);
        try {
            String qz_name = String.valueOf(exists_jobInfo.getId());
            XxlJobDynamicScheduler.updateJobCron(qz_name, exists_jobInfo.getJobCron());
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public ReturnT<String> remove(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        if (xxlJobInfo == null) {
            return ReturnT.SUCCESS;
        }
        String name = String.valueOf(xxlJobInfo.getId());
        try {
            XxlJobDynamicScheduler.removeJob(name);
            this.xxlJobInfoDao.delete(id);
            this.xxlJobLogDao.delete(id);
            this.xxlJobLogGlueDao.deleteByJobId(id);
            return ReturnT.SUCCESS;
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ReturnT.FAIL;
        }
    }

    @Override
    public ReturnT<String> start(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        String name = String.valueOf(xxlJobInfo.getId());
        String cronExpression = xxlJobInfo.getJobCron();
        try {
            boolean ret = XxlJobDynamicScheduler.addJob(name, cronExpression);
            return ret ? ReturnT.SUCCESS : ReturnT.FAIL;
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ReturnT.FAIL;
        }
    }

    @Override
    public ReturnT<String> stop(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        String name = String.valueOf(xxlJobInfo.getId());
        try {
            boolean ret = XxlJobDynamicScheduler.pauseJob(name);
            return ret ? ReturnT.SUCCESS : ReturnT.FAIL;
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ReturnT.FAIL;
        }
    }

    @Override
    public Map<String, Object> dashboardInfo() {
        int jobInfoCount = this.xxlJobInfoDao.findAllCount();
        int jobLogCount = this.xxlJobLogDao.triggerCountByHandleCode(-1);
        int jobLogSuccessCount = this.xxlJobLogDao.triggerCountByHandleCode(200);
        HashSet executerAddressSet = new HashSet();
        List<XxlJobGroup> groupList = this.xxlJobGroupDao.findAll();
        if (groupList != null && !groupList.isEmpty()) {
            for (XxlJobGroup group : groupList) {
                if (group.getRegistryList() == null || group.getRegistryList().isEmpty()) continue;
                executerAddressSet.addAll(group.getRegistryList());
            }
        }
        int executorCount = executerAddressSet.size();
        HashMap<String, Object> dashboardMap = new HashMap<String, Object>();
        dashboardMap.put("jobInfoCount", jobInfoCount);
        dashboardMap.put("jobLogCount", jobLogCount);
        dashboardMap.put("jobLogSuccessCount", jobLogSuccessCount);
        dashboardMap.put("executorCount", executorCount);
        return dashboardMap;
    }

    @Override
    public ReturnT<Map<String, Object>> chartInfo(Date startDate, Date endDate) {
        ArrayList<String> triggerDayList = new ArrayList<String>();
        ArrayList<Integer> triggerDayCountRunningList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountSucList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountFailList = new ArrayList<Integer>();
        int triggerCountRunningTotal = 0;
        int triggerCountSucTotal = 0;
        int triggerCountFailTotal = 0;
        List<Map<String, Object>> triggerCountMapAll = this.xxlJobLogDao.triggerCountByDay(startDate, endDate);
        if (triggerCountMapAll != null && triggerCountMapAll.size() > 0) {
            for (Map<String, Object> item : triggerCountMapAll) {
                String day = String.valueOf(item.get("triggerDay"));
                int triggerDayCount = Integer.valueOf(String.valueOf(item.get("triggerDayCount")));
                int triggerDayCountRunning = Integer.valueOf(String.valueOf(item.get("triggerDayCountRunning")));
                int triggerDayCountSuc = Integer.valueOf(String.valueOf(item.get("triggerDayCountSuc")));
                int triggerDayCountFail = triggerDayCount - triggerDayCountRunning - triggerDayCountSuc;
                triggerDayList.add(day);
                triggerDayCountRunningList.add(triggerDayCountRunning);
                triggerDayCountSucList.add(triggerDayCountSuc);
                triggerDayCountFailList.add(triggerDayCountFail);
                triggerCountRunningTotal += triggerDayCountRunning;
                triggerCountSucTotal += triggerDayCountSuc;
                triggerCountFailTotal += triggerDayCountFail;
            }
        } else {
            for (int i = 4; i > -1; --i) {
                triggerDayList.add(DateUtil.formatDate((Date)DateUtil.addDays((Date)new Date(), (int)(-i))));
                triggerDayCountRunningList.add(0);
                triggerDayCountSucList.add(0);
                triggerDayCountFailList.add(0);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("triggerDayList", triggerDayList);
        result.put("triggerDayCountRunningList", triggerDayCountRunningList);
        result.put("triggerDayCountSucList", triggerDayCountSucList);
        result.put("triggerDayCountFailList", triggerDayCountFailList);
        result.put("triggerCountRunningTotal", Integer.valueOf(triggerCountRunningTotal));
        result.put("triggerCountSucTotal", Integer.valueOf(triggerCountSucTotal));
        result.put("triggerCountFailTotal", Integer.valueOf(triggerCountFailTotal));
        return new ReturnT(result);
    }

    @Override
    public XxlJobInfo loadBySourceId(String sourceid) {
        XxlJobInfo jobInfo = this.xxlJobInfoDao.loadBySourceId(sourceid);
        return jobInfo;
    }
}

